:setvar DatabaseName "RegistryQA"
----------------------------------------------------------------------------------
----------------------------------------------------------------------------------
--2.0.2.1
----------------------------------------------------------------------------------

:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "2"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.2.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO

IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'AHOBPR.VIEW_REGISTRANT_DEPLOYMENT'))
DROP VIEW AHOBPR.VIEW_REGISTRANT_DEPLOYMENT;
GO

CREATE VIEW AHOBPR.VIEW_REGISTRANT_DEPLOYMENT
AS SELECT  
        R.REGISTRANT_FULL_NAME              AS DEPLOYED_REGISTRANT_FULL_NAME
      , [REGISTRANT_DEPLOYMENT_ID]   
      , D.[DEPLOYMENT_COUNTRY]  
      , D.[DEPLOYMENT_BASE]  
      , D.[DEPLOYMENT_START_DATE]   
      , D.[DEPLOYMENT_END_DATE]
      , D. [IS_ELIGIBLE_FLAG]               AS DEPLOYMENT_IS_ELIGIBLE_FLAG
      , D.[STD_BRANCH_OF_SERVICE_ID]        AS DEPLOYMENT_BRANCH_OF_SERVICE_ID
      , [BRANCH_OF_SERVICE]                 AS DEPLOYMENT_BRANCH_OF_SERVICE
      , [DUTY_PROJECT_CODE]
      , [USER_ENTERED_FLAG]         
      , [USER_VERIFIED_FLAG]

      , D.[STD_SERVICE_OCCUPATION_ID]       AS DEPLOYMENT_SERVICE_OCCUPATION_ID
      , [SERVICE_OCCUPATION_CODE]           AS DEPLOYMENT_SERVICE_OCCUPATION_CODE
      , [SERVICE_TITLE]                     AS DEPLOYMENT_SERVICE_TITLE
      , [MILITARY_RANK]                     AS DEPLOYMENT_MILITARY_RANK
      , [DEPLOYMENT_UIC]
      , [IS_GULF_WAR_VETERAN_FLAG]
      , D.[STD_COMPONENT_ID]                AS DEPLOYMENT_COMPONENT_ID
      , C.[CATEGORY_CODE]                   AS DEPLOYMENT_COMPONENT_CATEGORY_CODE
      , C.[DESCRIPTION]                     AS DEPLOYMENT_COMPONENT
      , R.*
FROM    [AHOBPR].[VIEW_REGISTRANT] AS R
JOIN    [AHOBPR].[REGISTRANT_DEPLOYMENT] AS D
  ON    R.[REGISTRANT_ID] = D.[REGISTRANT_ID]
LEFT
JOIN    [AHOBPR].[STD_BRANCH_OF_SERVICE] BoS
  ON    BoS.[STD_BRANCH_OF_SERVICE_ID] = D.[STD_BRANCH_OF_SERVICE_ID]
LEFT
JOIN    [AHOBPR].[STD_SERVICE_OCCUPATION] SO
  ON    SO.[STD_SERVICE_OCCUPATION_ID] = D.[STD_SERVICE_OCCUPATION_ID]
LEFT
JOIN    [AHOBPR].[STD_COMPONENT] C
  ON    C.[STD_COMPONENT_ID] = D.[STD_COMPONENT_ID];
  
GO

PRINT 'CREATE VIEW AHOBPR.VIEW_REGISTRANT_QUESTION...';
GO

IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'AHOBPR.VIEW_REGISTRANT_QUESTION'))
DROP VIEW AHOBPR.VIEW_REGISTRANT_QUESTION;
GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_QUESTION]
AS SELECT  
           r.REGISTRANT_ID                        AS ASKED_REGISTRANT_ID
         , R.REGISTRANT_FULL_NAME                 AS ASKED_REGISTRANT_NAME
         , SFQ.[FORM_QUESTION_UNIQUE_ID]
         , PQ.[SHORT_TEXT]                AS PARENT_QUESTION_TEXT
         , SFQ.[SHORT_TEXT]               AS QUESTION_TEXT
         , SFQ.[TYPE]                     AS QUESTION_TYPE
         , FRQ.[STARTED_DATE]             AS QUESTION_STARTED_DATE
         , FRQ.[COMPLETED_DATE]           AS QUESTION_COMPLETED_DATE
         , FR.FORM_RESPONSE_ID
         , FRQ.FORM_RESPONSE_QUESTION_ID
         , FRQ.[STD_FORM_QUESTION_ID] 
         , R.*
         , D.[REGISTRANT_DEPLOYMENT_ID]

        , D.[DEPLOYMENT_COUNTRY]  
        , D.[DEPLOYMENT_BASE]  
        , D.[DEPLOYMENT_START_DATE]   
        , D.[DEPLOYMENT_END_DATE]
        , D.DEPLOYMENT_IS_ELIGIBLE_FLAG
        , D.DEPLOYMENT_BRANCH_OF_SERVICE_ID
        , D.DEPLOYMENT_BRANCH_OF_SERVICE
        , D.[DUTY_PROJECT_CODE]
        , D.[USER_ENTERED_FLAG]         
        , D.[USER_VERIFIED_FLAG]

         , FR.CREATEDBY               AS RESPONSE_CREATEDBY
         , FR.CREATED                 AS RESPONSE_CREATED
         , FR.UPDATED                 AS RESPONSE_UPDATED
         , FR.UPDATEDBY               AS RESPONSE_UPDATEDBY
         , FRQ.CREATEDBY              AS RESPONSE_QUESTION_CREATEDBY
         , FRQ.CREATED                AS RESPONSE_QUESTION_CREATED
         , FRQ.UPDATEDBY              AS RESPONSE_QUESTION_UPDATEDBY
         , FRQ.UPDATED                AS RESPONSE_QUESTION_UPDATED
        
FROM    [AHOBPR].[VIEW_REGISTRANT] AS R
JOIN    [AHOBPR].[FORM_RESPONSE] AS FR
  ON    R.[REGISTRANT_ID] = FR.[REGISTRANT_ID]
JOIN    [AHOBPR].[FORM_RESPONSE_QUESTION] AS FRQ
  ON     FR.[FORM_RESPONSE_ID] = FRQ.[FORM_RESPONSE_ID]
JOIN    [AHOBPR].[STD_FORM_QUESTION] AS SFQ
  ON    FRQ.[STD_FORM_QUESTION_ID] = SFQ.[STD_FORM_QUESTION_ID]
LEFT
JOIN    [AHOBPR].[STD_FORM_QUESTION] AS PQ
  ON    PQ.[STD_FORM_QUESTION_ID] = SFQ.[PARENT_ID]
LEFT
JOIN    [AHOBPR].VIEW_REGISTRANT_DEPLOYMENT D
  ON    D.[REGISTRANT_DEPLOYMENT_ID] = FRQ.[REGISTRANT_DEPLOYMENT_ID];
GO

PRINT 'CREATE VIEW AHOBPR.VIEW_REGISTRANT_ANSWER...';
GO

IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'AHOBPR.VIEW_REGISTRANT_ANSWER'))
DROP VIEW AHOBPR.VIEW_REGISTRANT_ANSWER;
GO

CREATE VIEW AHOBPR.VIEW_REGISTRANT_ANSWER
AS SELECT  SFA.[TEXT]                 AS ANSWER_TEXT
         , FRA.ANSWER_VALUE
         , ISNULL(SFA.[TEXT], ANSWER_VALUE)  AS ANSWER_COALESCED
         , SFA.[ORDER]                AS ANSWER_ORDER
         , SFA.[EDITABLE]             AS EDITABLE
         , SFA.HELP                   AS ANSWER_HELP
         , Q.*
        
FROM    [AHOBPR].VIEW_REGISTRANT_QUESTION AS Q
JOIN    [AHOBPR].[FORM_RESPONSE_ANSWER] AS FRA
  ON    Q.[FORM_RESPONSE_QUESTION_ID] = FRA.[FORM_RESPONSE_QUESTION_ID]
JOIN    [AHOBPR].[STD_FORM_ANSWER] AS SFA
  ON    FRA.[STD_FORM_ANSWER_ID] = SFA.[STD_FORM_ANSWER_ID];

GO

IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'AHOBPR.VIEW_REGISTRANT_DEPLOYMENT_EXPOSURE_RESPONSE'))
DROP VIEW AHOBPR.VIEW_REGISTRANT_DEPLOYMENT_EXPOSURE_RESPONSE;
GO

CREATE VIEW AHOBPR.VIEW_REGISTRANT_DEPLOYMENT_EXPOSURE_RESPONSE
AS  SELECT  V.*
    FROM    AHOBPR.VIEW_REGISTRANT_DEPLOYMENT V
    JOIN    AHOBPR.VIEW_REGISTRANT_ANSWER exposure 
      ON    V.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID 
    WHERE FORM_QUESTION_UNIQUE_ID = '1.2.A';
GO


PRINT 'CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_VISIT]..';
GO

IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'AHOBPR.VIEW_REGISTRANT_VISIT'))
DROP VIEW AHOBPR.[VIEW_REGISTRANT_VISIT];
GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_VISIT]
AS SELECT 
        R.REGISTRANT_ID           AS PATIENT_REGISTRANT_ID
      , R.REGISTRANT_FULL_NAME    AS PATIENT_NAME
      , V.[VISIT_DATE_TIME]
      , [EVALUATION_FLAG]
      , [APPOINTMENT_TYPE]
      , [STOP_CODE]
      , [VISTA_EncounterID]
      , [VISTA_Sta3n]
      , [VISTA_EligibilityStatus]
      , I.NAME                    AS INSTITUTION_NAME
      , VISTANAME
      , FT.NAME                   AS FACILITY_TYPE
      , CASE FT.ISMEDICALTREATING WHEN 1 THEN 'True' WHEN '0' THEN 'False' ELSE FT.ISMEDICALTREATING END AS IS_MEDICAL_TREATING
      , R.*
      , V.[CREATEDBY] AS VISIT_CREATED_BY
      , V.[UPDATEDBY] AS VISIT_UPDATEDBY
      , V.[CREATED]   AS VISIT_CREATED
      , V.[UPDATED]   AS VISIT_UPDATED
      
FROM    [AHOBPR].VIEW_REGISTRANT AS R
JOIN    [AHOBPR].[REGISTRANT_VISIT] V
  ON    V.REGISTRANT_ID = R.REGISTRANT_ID
LEFT
JOIN    dbo.STD_INSTITUTION I
  ON    I.ID = V.[STD_INSTITUTION_ID]
LEFT
JOIN    [dbo].[STD_FACILITYTYPE] FT
  ON    FT.[ID] = I.[STD_FACILITYTYPE_ID];

GO

PRINT 'CREATE VIEW AHOBPR.VIEW_REGISTRANT_EVALUATION...';
GO
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'AHOBPR.VIEW_REGISTRANT_EVALUATION'))
DROP VIEW AHOBPR.VIEW_REGISTRANT_EVALUATION;
GO

CREATE VIEW AHOBPR.VIEW_REGISTRANT_EVALUATION
AS SELECT *
  FROM VIEW_REGISTRANT_VISIT
  WHERE [EVALUATION_FLAG] = 'Y';

GO

PRINT 'ALTER VIEW [AHOBPR].[VIEW_REGISTRANT_STATUS]...';
GO
--enable rollback
if exists (select * from sys.views where name = 'VIEW_REGISTRANT_STATUS'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.views where name = 'VIEW_REGISTRANT_STATUS_OLD'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            )
    drop view AHOBPR.VIEW_REGISTRANT_STATUS
  else
    exec SP_RENAME 'AHOBPR.VIEW_REGISTRANT_STATUS', 'VIEW_REGISTRANT_STATUS_OLD';
end;
GO

IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'AHOBPR.VIEW_REGISTRANT_STATUS'))
DROP VIEW AHOBPR.VIEW_REGISTRANT_STATUS;
GO

CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_STATUS] AS
WITH deployments AS
(
   SELECT REGISTRANT_ID, COUNT(*) AS NUMBER_OF_DEPLOYMENTS 
     FROM AHOBPR.REGISTRANT_DEPLOYMENT 
    GROUP BY REGISTRANT_ID
)
, Logins AS
(
  SELECT MAX(CREATED) AS LAST_LOGIN_DATE
      ,  MIN(CREATED) AS FIRST_LOGIN_DATE
      ,  COUNT(*) AS NUMBER_OF_LOGINS
      , USER_ID 
  FROM  AHOBPR.DATA_ACCESS_LOG
  WHERE PAGE_NAME = 'Login'
  GROUP BY USER_ID
)
SELECT 
       reg.REGISTRANT_FULL_NAME              AS STATUS_FULL_NAME,
       info.EDIPI_MISMATCHED_FLAG,
       info.EDIPI_VERIFIED_DATE,
       info.EULA_ACCEPTED_DATE,
       info.CONTACT_INFO_VERIFIED_DATE,
       frs.[FORM_RESPONSE_STATUS_ID],
       frs.[LAST_SECTION_ID],
       sfs.TITLE as LAST_SECTION,
       frs.[LAST_SUB_SECTION_ID],
       ssfs.TITLE as LAST_SUB_SECTION,
       frs.[QUESTIONNAIRE_STARTED_DATE],
       frs.[QUESTIONNAIRE_COMPLETED_DATE],
       frs.[UPDATED] AS QUESIONNAIRE_LAST_UPDATED,
       deployments.NUMBER_OF_DEPLOYMENTS,
       Logins.*,
       reg.*
  FROM AHOBPR.[VIEW_REGISTRANT] reg
  LEFT JOIN Logins
    ON LOGINs.USER_ID = reg.REGISTRANT_USER_ID
   LEFT JOIN AHOBPR.[REGISTRANT_RECORD_INFO] info
          ON info.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.FORM_RESPONSE fr
          ON fr.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS frs
          ON frs.FORM_RESPONSE_ID = fr.FORM_RESPONSE_ID
   LEFT JOIN deployments
          ON deployments.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.STD_FORM_SECTION sfs
         ON sfs.STD_FORM_SECTION_ID = LAST_SECTION_ID
   LEFT JOIN AHOBPR.STD_FORM_SUB_SECTION ssfs
         ON ssfs.STD_FORM_SUB_SECTION_ID = LAST_SUB_SECTION_ID;
GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';
go
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.0.4.3
-------------------------------------------------------------

--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "4"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.4.3.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!',11
              ,1);
   SET NOCOUNT ON;
   SET NOEXEC ON;
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO
------------------------------------------------------
PRINT 'Script started...';
PRINT GETDATE();
GO
------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[SP_GetJsonQueueFollowupRow]') AND type in (N'P', N'PC'))
DROP PROCEDURE [AHOBPR].[SP_GetJsonQueueFollowupRow]
GO

CREATE PROCEDURE [AHOBPR].[SP_GetJsonQueueFollowupRow]
	@jsonQueueFollowupId	INT
AS
BEGIN
	SET NOCOUNT ON;

	SELECT JSON_QUEUE_FOLLOWUP_ID
		   , REGISTRANT_JSON_FOLLOWUP_ID
	 FROM AHOBPR.JSON_QUEUE_FOLLOWUP
	WHERE JSON_QUEUE_FOLLOWUP_ID = @jsonQueueFollowupId;

END;

GO

UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';

-------------------------------------------------------------
-------------------------------------------------------------
-- 2.0.8.1
-------------------------------------------------------------

--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "8"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.8.1.sql"


PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!',11
              ,1);
   SET NOCOUNT ON;
   SET NOEXEC ON;
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO

PRINT 'Rename [AHOBPR].[SP_DeleteOneRegistrant] to [SP_DeleteOneRegistrant_Pre_2_0_8_1]...';
GO
if exists (select * from sys.procedures where name = 'SP_DeleteOneRegistrant'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.procedures where name = 'SP_DeleteOneRegistrant_Pre_2_0_8_1'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR'))
    drop procedure AHOBPR.SP_DeleteOneRegistrant
  else
    exec sp_rename 'AHOBPR.SP_DeleteOneRegistrant', 'SP_DeleteOneRegistrant_Pre_2_0_8_1';
end
GO
PRINT 'CREATE PROCEDURE [AHOBPR].[SP_DeleteOneRegistrant]...';
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[SP_DeleteOneRegistrant]') AND type in (N'P', N'PC'))
DROP PROCEDURE [AHOBPR].[SP_DeleteOneRegistrant]
GO

CREATE PROCEDURE [AHOBPR].[SP_DeleteOneRegistrant]
	@firstName  VARCHAR(50),
	@lastName  VARCHAR(50)
AS

DECLARE @registrantId int, @userId varchar(256)
BEGIN
	SELECT @registrantId = REGISTRANT_ID, @userId = USER_ID FROM [AHOBPR].[REGISTRANT] WHERE FIRST_NAME = @firstName AND LAST_NAME = @lastName
	
	DELETE FROM [AHOBPR].[REGISTRANT_JSON] WHERE OBJECT_ID = @userId

	DELETE FROM [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] WHERE OBJECT_ID = @userId

	exec ahobpr.SP_DeleteRegistrantAndResponse @registrantId

END
GO
PRINT 'Rename [AHOBPR].[SP_DeleteRegistrantAndResponse] to SP_DeleteRegistrantAndResponse_Pre_2_0_8_1...';
GO 
if exists (select * from sys.procedures where name = 'SP_DeleteRegistrantAndResponse'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.procedures where name = 'SP_DeleteRegistrantAndResponse_Pre_2_0_8_1'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR'))
    drop procedure AHOBPR.SP_DeleteRegistrantAndResponse
  else
    exec sp_rename 'AHOBPR.SP_DeleteRegistrantAndResponse', 'SP_DeleteRegistrantAndResponse_Pre_2_0_8_1';
end;
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[SP_DeleteRegistrantAndResponse]') AND type in (N'P', N'PC'))
DROP PROCEDURE [AHOBPR].[SP_DeleteRegistrantAndResponse]
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 4/24/2015
-- Description:	Called after loading Response
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_DeleteRegistrantAndResponse]
       @registrantId INT = NULL 
AS
BEGIN

  DELETE FROM AHOBPR.FORM_RESPONSE_ANSWER
  WHERE FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FORM_RESPONSE_ANSWER_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
            JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE FROM AHOBPR.FORM_RESPONSE_QUESTION
  WHERE FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FORM_RESPONSE_QUESTION_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      
            
  DELETE FROM AHOBPR.FORM_RESPONSE_STATUS
  WHERE FORM_RESPONSE_STATUS_ID IN
         ( 
          SELECT a.FORM_RESPONSE_STATUS_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_STATUS a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      

  DELETE FROM AHOBPR.FORM_RESPONSE   
        WHERE REGISTRANT_ID  = @registrantId;
 
   DELETE FROM AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER
  WHERE FOLLOWUP_FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FOLLOWUP_FORM_RESPONSE_ANSWER_ID
            FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER c ON a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID = c.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE FROM AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION
  WHERE FOLLOWUP_FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
            FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      
            

  DELETE FROM AHOBPR.FOLLOWUP_FORM_RESPONSE   
        WHERE REGISTRANT_ID  = @registrantId;
      
  DELETE FROM AHOBPR.REGISTRANT_DEPLOYMENT   
        WHERE REGISTRANT_ID  = @registrantId;

  DELETE FROM AHOBPR.REGISTRANT_ADDRESS   
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_PHONE
        WHERE REGISTRANT_ID  = @registrantId;  
        
   DELETE FROM AHOBPR.REGISTRANT_EMAIL     
        WHERE REGISTRANT_ID  = @registrantId;  
        
      
  DELETE FROM AHOBPR.REGISTRANT_CONTACT_INFO
        WHERE REGISTRANT_ID  = @registrantId;  
     
  DELETE FROM AHOBPR.REGISTRANT_HEALTH_FACTOR
        WHERE REGISTRANT_VISIT_ID IN
              (SELECT REGISTRANT_VISIT_ID
                 FROM AHOBPR.REGISTRANT_VISIT
                WHERE REGISTRANT_ID = @registrantId);  
        
  DELETE FROM AHOBPR.REGISTRANT_VISIT
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_RECORD_INFO
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_REGISTRY_FLAG
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_SERVICE_EPISODE
        WHERE REGISTRANT_ID  = @registrantId;  
    
  DELETE FROM AHOBPR.PROCESS_METRICS
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.EMAIL_LOG
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT
        WHERE REGISTRANT_ID  = @registrantId;              
END;
-- EXECUTE [AHOBPR].[SP_DeleteRegistrantAndResponse]  140

GO

PRINT 'Rename [AHOBPR].[VIEW_LOOKUP] to [VIEW_LOOKUP_Pre_2_0_8_1]...';
GO
if exists (select * from sys.views where name = 'VIEW_LOOKUP'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.views where name = 'VIEW_LOOKUP_Pre_2_0_8_1'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR'))
    drop view AHOBPR.VIEW_LOOKUP
  else
    exec sp_rename 'AHOBPR.VIEW_LOOKUP', 'VIEW_LOOKUP_Pre_2_0_8_1';
end;
GO
PRINT 'CREATE VIEW [AHOBPR].[VIEW_LOOKUP]...'; 
GO


IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[AHOBPR].[VIEW_LOOKUP]'))
DROP VIEW [AHOBPR].[VIEW_LOOKUP]
GO

CREATE VIEW [AHOBPR].[VIEW_LOOKUP] WITH SCHEMABINDING AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
   OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME NOT LIKE 'Status Change: %'))
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_FAMILY
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DISCHARGE_CHARACTER
UNION ALL
SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True'
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Multiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
UNION ALL
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Multiple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
	   ,STD_FORM_ID AS ID
       ,NAME AS CODE
       ,NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM
  WHERE FOLLOWUP_FLAG = 1
  UNION ALL
SELECT DISTINCT 'CONTACT_PREFERENCE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[CONTACT_PREFERENCE] AS CODE
       ,[CONTACT_PREFERENCE] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
  WHERE CONTACT_PREFERENCE > ''

-- select * from  [AHOBPR].[VIEW_LOOKUP]

GO

UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';

go
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.0.9.1
---------------------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "9"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.9.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!',11
              ,1);
   SET NOCOUNT ON;
   SET NOEXEC ON;
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO
--DELETE FROM AHOBPR.EMAIL_LOG WHERE TEMPLATE_ID IN (SELECT TEMPLATE_ID FROM [AHOBPR].[EMAIL_TEMPLATES] WHERE SUBJECT = 'New Follow-up Questions')
--DELETE FROM [AHOBPR].[EMAIL_TEMPLATES] WHERE SUBJECT = 'New Follow-up Questions';
WITH 
  Src AS
  ( SELECT *
    FROM ( VALUES
           ('New Follow-up Questions', 'New Follow-up Questions'
           ,'Hello {REGISTRANTNAME},{NEWLINE}{NEWLINE}Thank you for participating in the Airborne Hazards and Open Burn Pit Registry. After reviewing your questionnaire, the Department of Veterans Affairs would like to ask some additional follow-up questions. Your responses will be used to further assist VA in carrying out valuable research related to the health effects of airborne hazards on Veterans and Servicemembers.   At your earliest convenience, please log into the registry portal and complete the additional questionnaire(s).{NEWLINE}{NEWLINE}1. Go to AHOBPR (https://veteran.mobilehealth.va.gov/AHBurnPitRegistry/){NEWLINE}2.  Click (4) Follow up Questions{NEWLINE}3.  Select Question group{NEWLINE}4.  Complete the questions{NEWLINE}5.  Click submit{NEWLINE}{NEWLINE}Repeat 3 thru 5 until all question groups are completed. {NEWLINE}{NEWLINE}If you have questions or concerns, please contact the Registry Help Desk at 1-877-470-5947.{NEWLINE}{NEWLINE}Thank you for participating in the Airborne Hazards and Open Burn Pit Regisrty.'
           ,0 ,'AHOBPR' ,'AHOBPR' ,GETDATE(),GETDATE(),1 ,1)) value([TITLE],[SUBJECT],[BODY],[ACTIVE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[EMAIL],[NOTIFICATION])
  )
MERGE
  INTO [AHOBPR].[EMAIL_TEMPLATES] Tgt
  USING Src
    ON  Src.SUBJECT = Tgt.SUBJECT
  WHEN  MATCHED
        AND ( Src.BODY != Tgt.BODY
         OR Src.[TITLE] != Tgt.[TITLE]
         OR Src.ACTIVE != Tgt.ACTIVE
            )
  THEN  UPDATE
        SET  [TITLE] = Src.[TITLE]
            ,[SUBJECT] = Src.[SUBJECT]
            ,[BODY] = Src.[BODY]
            ,[ACTIVE] = Src.[ACTIVE]
            ,[CREATEDBY] = Src.[CREATEDBY]
            ,[UPDATEDBY] = Src.[UPDATEDBY]
            ,[CREATED] = Src.[CREATED]
            ,[UPDATED] = Src.[UPDATED]
            ,[EMAIL] = Src.[EMAIL]
            ,[NOTIFICATION] = Src.[NOTIFICATION]
  WHEN NOT MATCHED BY TARGET
  THEN INSERT 
        ([TITLE],[SUBJECT],[BODY],[ACTIVE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[EMAIL],[NOTIFICATION])
        VALUES
        (Src.[TITLE],Src.[SUBJECT],Src.[BODY],Src.[ACTIVE],Src.[CREATEDBY],Src.[UPDATEDBY],Src.[CREATED],Src.[UPDATED]
        ,Src.[EMAIL],Src.[NOTIFICATION]);

IF @@ROWCOUNT > 0
  DELETE FROM AHOBPR.EMAIL_LOG WHERE TEMPLATE_ID IN (SELECT TEMPLATE_ID FROM [AHOBPR].[EMAIL_TEMPLATES] WHERE SUBJECT = 'New Follow-up Questions');

--GO
PRINT 'CREATE PROCEDURE [AHOBPR].[SP_GetFailedtoSendQuestions]...';
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[SP_GetFailedtoSendQuestions]') AND type in (N'P', N'PC'))
DROP PROCEDURE [AHOBPR].[SP_GetFailedtoSendQuestions]
GO
CREATE PROCEDURE [AHOBPR].[SP_GetFailedtoSendQuestions]
AS

BEGIN
	SELECT A.REGISTRANT_ID
      , (ISNULL(A.LAST_NAME,'{Last Name Not Found}') + ISNULL(', ' + A.FIRST_NAME,'')) AS REGISTRANT_NAME
      , C.NAME AS FOLLOW_UP_GROUP
      , B.CREATED AS DATE_FAILED
      , C.STD_FORM_ID
	FROM AHOBPR.REGISTRANT A
  JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE B
    ON A.REGISTRANT_ID = B.REGISTRANT_ID
  JOIN AHOBPR.STD_FORM C 
    ON B.STD_FORM_ID = C.STD_FORM_ID
	WHERE B.COMPLETED_DATE IS NULL 
		AND NOT EXISTS
		(
			SELECT 'X'
			FROM AHOBPR.REGISTRANT_JSON_FOLLOWUP D
			WHERE D.OBJECT_TYPE = 'user_form'
				AND D.OBJECT_ID = A.USER_ID
        AND D.INSTANCE_ID = C.BPR_FORM_ID
		)
	

END;

-- Test Cases
-- exec [AHOBPR].[SP_GetFailedtoSendQuestions]

GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';
go
-----------------------------------------------------
-----------------------------------------------------
-- 2.0.9.2
-----------------------------------------------------  
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "9"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.9.2.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!',11
              ,1);
   SET NOCOUNT ON;
   SET NOEXEC ON;
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO

PRINT N'Creating [AHOBPR].[REGISTRANT_JSON_SQL20]...';


GO
IF NOT EXISTS(select * from sys.tables where name = 'REGISTRANT_JSON_SQL20'
              AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
             )
CREATE TABLE [AHOBPR].[REGISTRANT_JSON_SQL20] (
    [REGISTRANT_JSON_SQL20_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_JSON_ID]       INT           NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    CONSTRAINT [REGISTRANT_JSON_SQL20_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_JSON_SQL20_ID] ASC) ON [AHOBPR]
);


GO
IF EXISTS (select * from sys.columns  c  join sys.objects o on o.object_id = c.object_id
            where c.name = 'PatientSID'
             AND o.name = 'STAGED_VISIT'
             AND system_type_id = 56
             AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR') --127 (56) bigint max_length=8 (4)
          )
  TRUNCATE TABLE [AHOBPR].[STAGED_VISIT];

PRINT N'Dropping on [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[ACTIVE_FLAG]...';


GO

IF exists (select * from sys.default_constraints where is_system_named = 1
              AND parent_object_id = (select object_id from sys.objects where name = 'REGISTRANT_HEALTH_FACTOR')
             AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
             and parent_column_id = (select column_id from sys.columns where name = 'ACTIVE_FLAG' 
                                    and object_id = (select object_id from sys.objects where name = 'REGISTRANT_HEALTH_FACTOR')
                                    )
          ) 
BEGIN
  DECLARE @Command nvarchar(1000);
  SET @Command = 'ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] DROP CONSTRAINT '  
                + (select name from sys.default_constraints 
                  where is_system_named = 1
                    AND parent_object_id = (select object_id from sys.objects where name = 'REGISTRANT_HEALTH_FACTOR')
                    AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
                    and parent_column_id = (select column_id from sys.columns where name = 'ACTIVE_FLAG' 
                                          and object_id = (select object_id from sys.objects where name = 'REGISTRANT_HEALTH_FACTOR')
                                          )
                  );
  EXEC (@Command);
END;        


GO
PRINT N'Starting rebuilding table [AHOBPR].[JSON_QUEUE_STATUS]...';


GO
BEGIN TRANSACTION;

SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;

SET XACT_ABORT ON;

CREATE TABLE [AHOBPR].[tmp_ms_xx_JSON_QUEUE_STATUS] (
    [JSON_QUEUE_STATUS_ID]  INT            IDENTITY (1, 1) NOT NULL,
    [JSON_QUEUE_ID]         INT            NOT NULL,
    [REGISTRANT_JSON_ID]    INT            NOT NULL,
    [PROCESS_START_DATE]    DATETIME2 (0)  NULL,
    [PROCESS_COMPLETE_DATE] DATETIME2 (0)  NULL,
    [PROCESS_STATUS]        VARCHAR (100)  NULL,
    [PROCESS_ERROR]         VARCHAR (4000) NULL,
    [ROW_VERSION]           ROWVERSION     NOT NULL,
    [CREATEDBY]             VARCHAR (30)   NOT NULL,
    [UPDATEDBY]             VARCHAR (30)   NOT NULL,
    [CREATED]               DATETIME2 (0)  NOT NULL,
    [UPDATED]               DATETIME2 (0)  NOT NULL,
    CONSTRAINT [tmp_ms_xx_constraint_JSON_QUEUE_STATUS_PK] PRIMARY KEY CLUSTERED ([JSON_QUEUE_STATUS_ID] ASC) ON [AHOBPR]
);

IF EXISTS (SELECT TOP 1 1 
           FROM   [AHOBPR].[JSON_QUEUE_STATUS])
    BEGIN
        SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_JSON_QUEUE_STATUS] ON;
        INSERT INTO [AHOBPR].[tmp_ms_xx_JSON_QUEUE_STATUS] ([JSON_QUEUE_STATUS_ID], [JSON_QUEUE_ID], [REGISTRANT_JSON_ID], [PROCESS_START_DATE], [PROCESS_COMPLETE_DATE], [PROCESS_STATUS], [PROCESS_ERROR], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED])
        SELECT   [JSON_QUEUE_STATUS_ID],
                 [JSON_QUEUE_ID],
                 [REGISTRANT_JSON_ID],
                 [PROCESS_START_DATE],
                 [PROCESS_COMPLETE_DATE],
                 [PROCESS_STATUS],
                 [PROCESS_ERROR],
                 [CREATEDBY],
                 [UPDATEDBY],
                 [CREATED],
                 [UPDATED]
        FROM     [AHOBPR].[JSON_QUEUE_STATUS]
        ORDER BY [JSON_QUEUE_STATUS_ID] ASC;
        SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_JSON_QUEUE_STATUS] OFF;

        DROP TABLE [AHOBPR].[JSON_QUEUE_STATUS];
    END

EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_JSON_QUEUE_STATUS]', N'JSON_QUEUE_STATUS';

EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_constraint_JSON_QUEUE_STATUS_PK]', N'JSON_QUEUE_STATUS_PK', N'OBJECT';

COMMIT TRANSACTION;

SET TRANSACTION ISOLATION LEVEL READ COMMITTED;


GO
PRINT N'Altering [AHOBPR].[STAGED_PATIENT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
ALTER TABLE [AHOBPR].[STAGED_PATIENT] ALTER COLUMN [ExtractBatchID] BIGINT NULL;

ALTER TABLE [AHOBPR].[STAGED_PATIENT] ALTER COLUMN [PatientSID] BIGINT NULL;


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Altering [AHOBPR].[STAGED_VISIT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
IF EXISTS (select * from sys.columns where name = 'STOP_CODE2'
                    AND object_id = (select object_id from sys.objects where name = 'STAGED_VISIT')
          )
  ALTER TABLE [AHOBPR].[STAGED_VISIT] DROP COLUMN [STOP_CODE2], COLUMN [STOP_CODE2_SID];


GO
ALTER TABLE [AHOBPR].[STAGED_VISIT] ALTER COLUMN [PatientICN] VARCHAR (50) NOT NULL;
GO
ALTER TABLE [AHOBPR].[STAGED_VISIT] ALTER COLUMN [PatientSID] BIGINT NOT NULL;


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STAGED_DOD_DEPLOYMENT_IMPORT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
IF NOT EXISTS (select * from sys.tables where name = 'STAGED_DOD_DEPLOYMENT_IMPORT' AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
              )
CREATE TABLE [AHOBPR].[STAGED_DOD_DEPLOYMENT_IMPORT] (
    [DEPLOYMENT_ID]  INT          IDENTITY (1, 1) NOT NULL,
    [EDIPI]          VARCHAR (10) NULL,
    [SVC]            VARCHAR (15) NULL,
    [COMPO]          VARCHAR (10) NULL,
    [LOCATION]       VARCHAR (2)  NULL,
    [DEP_BGN_CDT]    VARCHAR (10) NULL,
    [DEP_END_CDT]    VARCHAR (10) NULL,
    [LOC_BEGIN_DATE] VARCHAR (10) NULL,
    [LOC_END_DATE]   VARCHAR (10) NULL,
    [GRADE]          VARCHAR (4)  NULL,
    [PN_SEX_CD]      VARCHAR (50) NULL,
    [MRTL_STAT_CD]   VARCHAR (50) NULL,
    [EDU_LVL_CD]     VARCHAR (50) NULL,
    [RACE_CD]        VARCHAR (50) NULL,
    [ETH_AFF_CD]     VARCHAR (50) NULL,
    [DTY_DOD_OCC_CD] VARCHAR (50) NULL,
    [Service]        VARCHAR (50) NULL,
    [Component]      VARCHAR (50) NULL
) ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[IX_FORM_RESPONSE_QUESTION_DeploymentID]...';


GO
if not exists (select * from sys.indexes where name = 'IX_FORM_RESPONSE_QUESTION_DeploymentID')
CREATE NONCLUSTERED INDEX [IX_FORM_RESPONSE_QUESTION_DeploymentID]
    ON [AHOBPR].[FORM_RESPONSE_QUESTION]([REGISTRANT_DEPLOYMENT_ID] ASC)
    INCLUDE([FORM_RESPONSE_QUESTION_ID], [FORM_RESPONSE_ID], [STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[IX_FORM_RESPONSE_QUESTION_FormResponseId]...';


GO
if not exists (select * from sys.indexes where name = 'IX_FORM_RESPONSE_QUESTION_FormResponseId')
CREATE NONCLUSTERED INDEX [IX_FORM_RESPONSE_QUESTION_FormResponseId]
    ON [AHOBPR].[FORM_RESPONSE_QUESTION]([FORM_RESPONSE_ID] ASC)
    INCLUDE([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[IX_FORM_RESPONSE_QUESTION_StdFormQuestionId]...';


GO
if not exists (select * from sys.indexes where name = 'IX_FORM_RESPONSE_QUESTION_StdFormQuestionId')
CREATE NONCLUSTERED INDEX [IX_FORM_RESPONSE_QUESTION_StdFormQuestionId]
    ON [AHOBPR].[FORM_RESPONSE_QUESTION]([FORM_RESPONSE_ID] ASC, [STD_FORM_QUESTION_ID] ASC)
    INCLUDE([FORM_RESPONSE_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[IX_REGISTRANT_StdInstitutionId]...';


GO
if not exists (select * from sys.indexes where name = 'IX_REGISTRANT_StdInstitutionId')
CREATE NONCLUSTERED INDEX [IX_REGISTRANT_StdInstitutionId]
    ON [AHOBPR].[REGISTRANT]([STD_INSTITUTION_ID] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[STD_FORM_QUESTION].[IX_STD_FORM_QUESTION_UniqueId]...';


GO
if not exists (select * from sys.indexes where name = 'IX_STD_FORM_QUESTION_UniqueId')
CREATE NONCLUSTERED INDEX [IX_STD_FORM_QUESTION_UniqueId]
    ON [AHOBPR].[STD_FORM_QUESTION]([FORM_QUESTION_UNIQUE_ID] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[DF_EMAIL_TEMPLATES_Email]...';


GO
if not exists (select * from sys.default_constraints where is_system_named = 0
                AND parent_object_id = (select object_id from sys.objects where name = 'EMAIL_TEMPLATES')
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
                and parent_column_id = (select column_id from sys.columns where name = 'EMAIL' 
                                      and object_id = (select object_id from sys.objects where name = 'EMAIL_TEMPLATES')
                                      )
          )
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES]
    ADD CONSTRAINT [DF_EMAIL_TEMPLATES_Email] DEFAULT ((1)) FOR [EMAIL];


GO
PRINT N'Creating [AHOBPR].[DF_EMAIL_TEMPLATES_Notification]...';


GO
if not exists (select * from sys.default_constraints where is_system_named = 0
                AND parent_object_id = (select object_id from sys.objects where name = 'EMAIL_TEMPLATES')
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
                and parent_column_id = (select column_id from sys.columns where name = 'NOTIFICATION' 
                                      and object_id = (select object_id from sys.objects where name = 'EMAIL_TEMPLATES')
                                      )
          )
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES]
    ADD CONSTRAINT [DF_EMAIL_TEMPLATES_Notification] DEFAULT ((1)) FOR [NOTIFICATION];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantHealthFactor_Active]...';


GO
if not exists (select * from sys.default_constraints where is_system_named = 0
                AND parent_object_id = (select object_id from sys.objects where name = 'REGISTRANT_HEALTH_FACTOR')
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
                and parent_column_id = (select column_id from sys.columns where name = 'ACTIVE_FLAG' 
                                      and object_id = (select object_id from sys.objects where name = 'REGISTRANT_HEALTH_FACTOR')
                                      )
          )
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_RegistrantHealthFactor_Active] DEFAULT ((1)) FOR [ACTIVE_FLAG];


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_SEPARATION_REASON2]...';


GO
IF not exists (select * from sys.foreign_keys where name = 'FK_REGISTRANT_STD_SEPARATION_REASON2')
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_SEPARATION_REASON2] FOREIGN KEY ([STD_SEPARATION_REASON_ID_WHEN_ENROLLED]) REFERENCES [AHOBPR].[STD_SEPARATION_REASON] ([STD_SEPARATION_REASON_ID]);


GO
PRINT N'Altering [AHOBPR].[SP_ClearProcessMetrics]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: July, 13 2015
-- Description: Called from Mirgation routine to remove any Process Metrics records created, 
--              as they do not have vaild dates.
ALTER PROCEDURE [AHOBPR].[SP_ClearProcessMetrics] AS
BEGIN
	SET NOCOUNT ON;

	TRUNCATE TABLE [AHOBPR].[PROCESS_METRICS];

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Altering [AHOBPR].[SP_PostMigrationDataUpdates]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
ALTER PROCEDURE [AHOBPR].[SP_PostMigrationDataUpdates]
      
AS
BEGIN

  PRINT 'PostMigrationDataUpdates.sql started...';
  PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';

  PRINT 'Step 01 - Set display Question Number...'; 
   
  With GoodValues 
  AS (
  SELECT Q.STD_FORM_QUESTION_ID
        ,CONVERT(VARCHAR(10),sec.BRP_FORM_SECTION_ID) + '.'
        +CONVERT(VARCHAR(10),ss.[BRP_FORM_SUB_SECTION_ID])+ '.'
        +Q.BRP_FORM_QUESTION_ID AS CalculatedID
    FROM AHOBPR.STD_FORM_QUESTION Q 
    JOIN [AHOBPR].[STD_FORM_SUB_SECTION] ss  ON Q.STD_FORM_SUB_SECTION_ID = ss.STD_FORM_SUB_SECTION_ID
    JOIN AHOBPR.STD_FORM_SECTION sec         ON sec.STD_FORM_SECTION_ID = ss.STD_FORM_SECTION_ID 
    )
    MERGE INTO AHOBPR.STD_FORM_QUESTION as Tgt
    USING GoodValues AS Src
       ON tgt.STD_FORM_QUESTION_ID = Src.STD_FORM_QUESTION_ID
     WHEN MATCHED
     THEN  UPDATE
              SET Tgt.FORM_QUESTION_UNIQUE_ID = Src.CalculatedID;
 
  PRINT 'Step 02 - Clear all Clinical Relevant Flag...)';
  
  UPDATE AHOBPR.STD_FORM_ANSWER
    SET CLINICAL_RELEVANT_FLAG = 0;
  
  PRINT 'Step 03 - Setting Clinical Relevant Flag...)';
  
  WITH  MasterData
    AS ( 
          SELECT *
          FROM   ( VALUES
          ('1.2.A','Yes'),
          ('1.2.F','Yes'),
          ('1.2.G',''),
          ('1.3.B',''),
          ('1.4.C',''),
          ('1.4.D','Yes'),
          ('1.4.E',''),
          ('1.4.F','Yes'),
          ('2.1.D','can''t do it at all'),
          ('2.1.D','somewhat difficult'),
          ('2.1.D','very difficult'),
          ('2.1.E','can''t do it at all'),
          ('2.1.E','somewhat difficult'),
          ('2.1.E','very difficult'),
          ('2.1.F','Arthritis/rheumatism'),
          ('2.1.F','Back or neck problem'),
          ('2.1.F','Benign Tumors, Cysts'),
          ('2.1.F','Birth defect'),
          ('2.1.F','Brain injury, (for example, Traumatic Brain Injury/TBI, Intellectual disability)'),
          ('2.1.F','Cancer'),
          ('2.1.F','Circulation problems (including blood clots)'),
          ('2.1.F','Depression/anxiety/emotional problem'),
          ('2.1.F','Diabetes'),
          ('2.1.F','Epilepsy, seizures'),
          ('2.1.F','Fibromyalgia, lupus'),
          ('2.1.F','Fracture, bone/joint injury'),
          ('2.1.F','Hearing problem'),
          ('2.1.F','Heart problem'),
          ('2.1.F','Hernia'),
          ('2.1.F','Hypertension/high blood pressure'),
          ('2.1.F','Kidney, bladder or renal problems'),
          ('2.1.F','Knee problems (not arthritis, not joint injury)'),
          ('2.1.F','Lung/breathing problem (for example, asthma and emphysema)'),
          ('2.1.F','Migraine headaches (not just headaches)'),
          ('2.1.F','Missing limbs (fingers, toes or digits), amputee'),
          ('2.1.F','Multiple Sclerosis (MS), Muscular Dystrophy (MD)'),
          ('2.1.F','Osteoporosis, tendinitis'),
          ('2.1.F','Other developmental problem (for example, cerebral palsy)'),
          ('2.1.F','Other injury'),
          ('2.1.F','Other nerve damage, including carpal tunnel syndrome'),
          ('2.1.F','Parkinson''s disease, other tremors'),
          ('2.1.F','Polio (myelitis), paralysis, para/quadriplegia'),
          ('2.1.F','Senility'),
          ('2.1.F','Stroke problem'),
          ('2.1.F','Thyroid problems, Grave''s disease, gout'),
          ('2.1.F','Ulcer'),
          ('2.1.F','Varicose veins, hemorrhoids'),
          ('2.1.F','Vision/problem seeing'),
          ('2.1.F','Weight problem'),
          ('2.2.1.B','Yes'),
          ('2.2.1.C','Yes'),
          ('2.2.1.D','Yes'),
          ('2.2.1.E','Yes'),
          ('2.2.1.F','Yes'),
          ('2.2.1.G','Yes'),
          ('2.2.1.H','Yes'),
          ('2.2.1.I','After deployment'),
          ('2.2.1.I','Before deployment'),
          ('2.2.1.I','During deployment'),
          ('2.2.1.J','About the same'),
          ('2.2.1.J','Better'),
          ('2.2.1.J','Worse'),
          ('2.2.1.M','Stopping for breath after walking about 100 yards or after a few minutes on level ground'),
          ('2.2.1.M','Too breathless to leave the house, or breathless when dressing or undressing'),
          ('2.2.1.M','Walking slower than most people on level ground, stop after one mile, or stop after 15 minutes walking at my own pace'),
          ('2.4.A','Yes'),
          ('2.4.B','Bladder'),
          ('2.4.B','Blood'),
          ('2.4.B','Bone'),
          ('2.4.B','Brain'),
          ('2.4.B','Breast'),
          ('2.4.B','Cervix'),
          ('2.4.B','Colon'),
          ('2.4.B','Esophagus'),
          ('2.4.B','Gallbladder'),
          ('2.4.B','Kidney'),
          ('2.4.B','Larynx-windpipe'),
          ('2.4.B','Leukemia'),
          ('2.4.B','Liver'),
          ('2.4.B','Lung'),
          ('2.4.B','Lymphoma'),
          ('2.4.B','Melanoma'),
          ('2.4.B','Mouth/tongue/lip'),
          ('2.4.B','Other'),
          ('2.4.B','Ovary'),
          ('2.4.B','Pancreas'),
          ('2.4.B','Prostate'),
          ('2.4.B','Rectum'),
          ('2.4.B','Skin (Don''t Know what kind)'),
          ('2.4.B','Skin (non-melanoma)'),
          ('2.4.B','Soft tissue (muscle or fat)'),
          ('2.4.B','Stomach'),
          ('2.4.B','Testis'),
          ('2.4.B','Throat-pharynx'),
          ('2.4.B','Thyroid'),
          ('2.4.B','Uterus'),
          ('2.5.A','No'),
          ('2.5.A','Yes'),
          ('2.5.C','Don''t know'),
          ('2.5.C','Everyday'),
          ('2.5.C','I do not wish to answer'),
          ('2.5.C','Not at all'),
          ('2.5.C','Some days'),
          ('3.1.A','About the same'),
          ('3.1.A','Better'),
          ('3.1.A','Worse'),
          ('3.1.E','A little concerned'),
          ('3.1.E','Very concerned'),
          ('3.1.F','Cancer'),
          ('3.1.F','Effect on children or ability to have children'),
          ('3.1.F','Eye problem'),
          ('3.1.F','Gastrointestinal (GI) problem'),
          ('3.1.F','Heart problem'),
          ('3.1.F','Immune problem'),
          ('3.1.F','Lung/Respiratory/Breathing problem'),
          ('3.1.F','Neurological problem'),
          ('3.1.F','Other problem'),
          ('3.1.F','Skin problem'),
          ('3.1.H','Yes'),
          ('3.1.J','Cancer'),
          ('3.1.J','Effect on children or ability to have children'),
          ('3.1.J','Eyes'),
          ('3.1.J','Heart'),
          ('3.1.J','Lung/Respiratory/Breathing'),
          ('3.1.J','Other'),
          ('3.1.J','Skin'),
          ('5.4.A','Yes'),
          ('5.4.B.4','Yes'),
          ('5.5.D','Yes')
          )
           AS MasterRecord(QuestionID, AnswerText)
         )
         UPDATE AHOBPR.STD_FORM_ANSWER
         SET CLINICAL_RELEVANT_FLAG = 1
         WHERE STD_FORM_ANSWER_ID IN 
              (       
                SELECT A.STD_FORM_ANSWER_ID           
                  FROM AHOBPR.STD_FORM_ANSWER A
                  JOIN AHOBPR.STD_FORM_QUESTION B 
                    ON A.STD_FORM_QUESTION_ID = B.STD_FORM_QUESTION_ID 
                 WHERE EXISTS(SELECT * FROM MasterData 
                               WHERE B.FORM_QUESTION_UNIQUE_ID = MasterData.QuestionID
                                 AND ISNULL(A.[TEXT],'') = MasterData.AnswerText)
               );  
            
  PRINT 'Step 04 - Loading Tool Tips for Sections...';

  WITH  MasterData
  AS    ( 
          SELECT *
          FROM    ( VALUES       
        (1,'To view questionnaire responses for Deployment History select from the sub sections below.'),
        (2,'To view questionnaire responses to Symptoms & Medical History select from the sub sections below.'),
        (3,'Select to view registrant responses to Health Concerns.'),
        (4,'Select to view registrant responses to Places You''ve Lived.'),
        (5,'To view questionnaire responses to Work History select from the sub sections below.'),
        (6,'Select to view registrant responses to Home Environment & Hobbies.'),
        (7,'Select to view registrant responses to Health Care Utilization.'),
        (8,'Select to view registrant responses to Contact Preferences.')
        )
         AS MasterRecord(id, TextValue)
         )       
  MERGE
    INTO  AHOBPR.STD_FORM_SECTION   AS Tgt
    USING MasterData AS Src
    ON    Tgt.BRP_FORM_SECTION_ID = Src.id
   WHEN MATCHED 
   THEN UPDATE SET Tgt.TOOL_TIP = Src.TextValue;   
 
  PRINT 'Step 05 - Loading Tool Tips for Sub Sections...';
       
  WITH  MasterData
  AS    ( 
          SELECT *
          FROM    ( VALUES       
                    (1,1,'Select to view registrant deployment history received from deployment interfaces.'),
                    (1,2,'Select to view registrant responses for deployment specific questions.'),
                    (1,3,'Select to view registrant responses to Military Occupational Exposures.'),
                    (1,4,'Select to view registrant responses to Environment Exposures & Air Pollution.'),
                    (2,1,'Select to view registrant responses to Functional Limitations & Reported Causes.'),
                    (2,2,'Select to view registrant responses to Health Conditions.'),
                    (2,3,'Select to view registrant responses to Height & Weight.'),
                    (2,4,'Select to view registrant responses to Cancer History.'),
                    (2,5,'Select to view registrant responses to Tobacco Exposure.'),
                    (2,6,'Select to view registrant responses to Deployment Smoking History.'),
                    (2,7,'Select to view registrant responses to Month Alcohol Use.'),
                    (3,1,'Select to view registrant responses to Health Concerns.'),
                    (4,1,'Select to view registrant responses to Places You''ve Lived.'),
                    (5,1,'Select to view registrant responses to Current Occupational Status.'),
                    (5,2,'Select to view registrant responses to Main Occupation.'),
                    (5,3,'Select to view registrant responses to Dust Exposures.'),
                    (5,4,'Select to view registrant responses to Gas, Smoke, Vapors or Fumes Exposure.'),
                    (5,5,'Select to view registrant responses to Asbestos Exposure.'),
                    (6,1,'Select to view registrant responses to Home Environment & Hobbies.'),
                    (7,1,'Select to view registrant responses to Health Care Utilization.'),
                    (8,1,'Select to view registrant responses to Contact Preferences.')
        )
         AS MasterRecord(SectionId, SubSectionId, TextValue)
   )
   ,Src
   AS(     
     SELECT STD_FORM_SUB_SECTION_ID AS ssId, TextValue
       FROM [AHOBPR].[STD_FORM_SUB_SECTION]
       JOIN AHOBPR.STD_FORM_SECTION 
         ON STD_FORM_SECTION.STD_FORM_SECTION_ID = STD_FORM_SUB_SECTION.STD_FORM_SECTION_ID
       JOIN MasterData 
            ON MasterData.SectionId = STD_FORM_SECTION.BRP_FORM_SECTION_ID
            AND MasterData.SubSectionId = STD_FORM_SUB_SECTION.BRP_FORM_SUB_SECTION_ID
   )
  MERGE
    INTO  AHOBPR.STD_FORM_SUB_SECTION   AS Tgt
    USING  Src
    ON    Tgt.STD_FORM_SUB_SECTION_ID = Src.ssId
   WHEN MATCHED 
   THEN UPDATE SET Tgt.TOOL_TIP = Src.TextValue;
       
  PRINT 'Step 06 - Update STD_FORM_SECTION...';
 
  WITH  MasterData
    AS ( 
          SELECT *
          FROM   ( VALUES
					  (1,'Deployment History'),
					  (2,'Symptoms & Medical History'),
					  (3,'Health Concerns'),
					  (4,'Places You''ve Lived'),
					  (5,'Work History'),
					  (6,'Home Environment & Hobbies'),
					  (7,'Health Care Utilization'),
					  (8,'Contact Preferences')			   )
           AS MasterRecord([BRP_FORM_SECTION_ID], [MENU_ITEM_NAME]) 
         )
   , Src 
   AS (
       SELECT sec.STD_FORM_SECTION_ID, 
            MasterData.[BRP_FORM_SECTION_ID], MasterData.[MENU_ITEM_NAME]
       FROM MasterData 
       JOIN AHOBPR.STD_FORM_SECTION sec ON sec.[BRP_FORM_SECTION_ID] = MasterData.[BRP_FORM_SECTION_ID]
       )
       MERGE
    INTO  [AHOBPR].[STD_FORM_SECTION] AS Tgt
    USING  Src
    ON    Tgt.[STD_FORM_SECTION_ID] = Src.[STD_FORM_SECTION_ID]
    WHEN MATCHED 
   THEN UPDATE SET Tgt.[MENU_ITEM_NAME] = Src.[MENU_ITEM_NAME]; 
   
  PRINT 'Step 07 Update [STD_FORM_SUBSECTION]...';  

  WITH  MasterData
    AS ( 
          SELECT *
          FROM   ( VALUES
				  (1,1,'Deployments'),
				  (1,2,'Deployment Exposures'),
				  (1,3,'Military Occupational Exposures'),
				  (1,4,'Environmental Exposures & Air Pollution'),
				  (2,1,'Functional Limitation & Reported Cause'),
				  (2,2,'Health Conditions'),
				  (2,3,'Height & Weight'),
				  (2,4,'Cancer History'),
				  (2,5,'Tobacco Exposure'),
				  (2,6,'Deployment Smoking History'),
				  (2,7,'12 Month Alcohol Use'),
				  (5,1,'Current Occupational Status'),
				  (5,2,'Main Occupation'),
				  (5,3,'Dust Exposures'),
				  (5,4,'Gas, Smoke, Vapors or Fumes Exposure?'),
				  (5,5,'Asbestos Exposure')
			     )
           AS MasterRecord ( [SECTION_ID], [SUB_SECTION_ID], [MENU_ITEM]) 
         ),
  Src AS (
         SELECT ss.STD_FORM_SUB_SECTION_ID, -- [SECTION_ID], [SUB_SECTION_ID], 
                  [MENU_ITEM]
         FROM MasterData
         JOIN AHOBPR.[STD_FORM_SUB_SECTION] ss ON ss.[BRP_FORM_SUB_SECTION_ID] = MasterData.[SUB_SECTION_ID]
         JOIN AHOBPR.[STD_FORM_SECTION] sec ON ss.[STD_FORM_SECTION_ID] = sec.[STD_FORM_SECTION_ID]
         WHERE MasterData.[SECTION_ID] = sec.BRP_FORM_SECTION_ID
       )
    MERGE
    INTO  [AHOBPR].[STD_FORM_SUB_SECTION] AS Tgt
    USING  Src
    ON    Tgt.[STD_FORM_SUB_SECTION_ID] = Src.[STD_FORM_SUB_SECTION_ID]
    WHEN MATCHED 
    THEN UPDATE 
            SET Tgt.[MENU_ITEM_NAME] = Src.[MENU_ITEM];

  PRINT 'Step 08 - Set Short Text = Text with HTML removed.';       
       
  UPDATE [AHOBPR].[STD_FORM_QUESTION]
       SET SHORT_TEXT = REPLACE(REPLACE(REPLACE([TEXT],'<strong>',''),'</strong>',''),'</br>','');

 PRINT 'Step 09 - Update Question Unique ID to short form for sections 1,3,6,7 & 8 - Should be 33 ';       
 
  With ShortValues 
  AS (
  SELECT Q.STD_FORM_QUESTION_ID
        ,CONVERT(VARCHAR(10),sec.BRP_FORM_SECTION_ID) + '.'
        +Q.BRP_FORM_QUESTION_ID AS CalculatedID
   FROM AHOBPR.STD_FORM_QUESTION Q 
    JOIN [AHOBPR].[STD_FORM_SUB_SECTION] ss  ON Q.STD_FORM_SUB_SECTION_ID = ss.STD_FORM_SUB_SECTION_ID
    JOIN AHOBPR.STD_FORM_SECTION sec         ON sec.STD_FORM_SECTION_ID = ss.STD_FORM_SECTION_ID 
    WHERE sec.BRP_FORM_SECTION_ID IN (1,3,6,7,8)
      AND ss.BRP_FORM_SUB_SECTION_ID = 1
    )
    MERGE INTO AHOBPR.STD_FORM_QUESTION as Tgt
    USING ShortValues AS Src
       ON tgt.STD_FORM_QUESTION_ID = Src.STD_FORM_QUESTION_ID
     WHEN MATCHED
     THEN  UPDATE
              SET Tgt.FORM_QUESTION_UNIQUE_ID = Src.CalculatedID;  
              
  PRINT 'ENABLE TRIGGER TRG_REGISTRANT_JSON_INSERT';               
              
  ENABLE TRIGGER TRG_REGISTRANT_JSON_INSERT ON AHOBPR.REGISTRANT_JSON;
  
  PRINT 'DROP INDEX [IX_REGISTRANT_JSON_Object] If it exists..';    
  
  IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_JSON]') AND name = N'IX_REGISTRANT_JSON_Object')
      DROP INDEX [IX_REGISTRANT_JSON_Object] ON [AHOBPR].[REGISTRANT_JSON] WITH ( ONLINE = OFF );

  PRINT 'CREATE INDEX [IX_REGISTRANT_JSON_Object] ....';    

  CREATE NONCLUSTERED INDEX [IX_REGISTRANT_JSON_Object] ON [AHOBPR].[REGISTRANT_JSON] 
  (
	  [OBJECT_TYPE] ASC,
	  [OBJECT_ID] ASC,
	  [REGISTRANT_JSON_ID] ASC
  )WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [AHOBPR];

              

  PRINT '';
  PRINT 'PostMigrationDataUpdates.sql Script End.';
  PRINT '';
  PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';

END;

-- EXECUTE [AHOBPR].[SP_PostMigrationDataUpdates]
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Altering [AHOBPR].[SP_ReportContactHistory]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Object:      StoredProcedure [AHOBPR].[SP_ReportContactHistory]
-- Author:		  Bruce Clegg
-- Create date: 21 May 2015
-- Description:	Make 4 tables look like one
--
-- Modification Log:
-- 2015.05.21 Bruce Clegg - Create Procedure
-- 2015.07.14 CleggB - changed UpdatedDate and output from Date to DateTime2(0)
ALTER PROCEDURE [AHOBPR].[SP_ReportContactHistory]
	@RegistrantId INT = NULL 
WITH EXECUTE AS OWNER
AS
BEGIN

  DECLARE @RowCount SMALLINT = 0;

  DECLARE @Results TABLE(UpdatedDate        DATETIME2(0)
                         ,[STREET1]         VARCHAR(256)
                         ,[STREET2]         VARCHAR(256)
                         ,[CITY]            VARCHAR(100)
                         ,[STATE]           VARCHAR(100)
                         ,[ZIP]             VARCHAR(15)
                         ,[COUNTRY]         VARCHAR(100) 
                         ,PhoneNumber       VARCHAR(50)
                         ,MobileNumber      VARCHAR(50)
                         ,EMAIL             VARCHAR(256)  );  
                             
  DECLARE  @UpdatedDate    DATETIME2(0)
          ,@MyOrder        INT
          ,@Street1        VARCHAR(256)
          ,@Street2        VARCHAR(256)
          ,@City           VARCHAR(100)
          ,@State          VARCHAR(100)
          ,@Zip            VARCHAR(15)
          ,@Country        VARCHAR(100) 
          ,@PhoneNumber    VARCHAR(50)
          ,@MobileNumber   VARCHAR(50)
          ,@Email          VARCHAR(256);     

  DECLARE  @UpdatedDateOut    DATETIME2(0)
          ,@Street1Out        VARCHAR(256)
          ,@Street2Out        VARCHAR(256)
          ,@CityOut           VARCHAR(100)
          ,@StateOut          VARCHAR(100)
          ,@ZipOut            VARCHAR(15)
          ,@CountryOut        VARCHAR(100) 
          ,@PhoneNumberOut    VARCHAR(50)
          ,@MobileNumberOut   VARCHAR(50)
          ,@EmailOut          VARCHAR(256);                                        

  DECLARE MyCursor CURSOR LOCAL
  FOR
  WITH Addr
  AS (
      SELECT DISTINCT
             [REGISTRANT_ID]
            ,[STREET1]
            ,[STREET2]
            ,[CITY]
            ,[STATE]
            ,[ZIP]
            ,[COUNTRY]
            ,[Audit_Date] AS UpdatedDate
            ,CONVERT(INT,'1') AS MyOrder
        FROM [AHOBPR].[REGISTRANT_ADDRESS_H]
       WHERE [Audit_Type] != 'DELETE'
         AND [REGISTRANT_ID] = @RegistrantId
     )
    ,Phone
    AS (
        SELECT DISTINCT
               [REGISTRANT_ID]
              ,[PHONE_NUMBER] as PhoneNumber
              ,[Audit_Date] AS UpdatedDate
              ,CONVERT(INT,'2') AS MyOrder          
          FROM [AHOBPR].[REGISTRANT_PHONE_H]
         WHERE ISNULL([TYPE],'') != 'Mobile'
           AND [Audit_Type] != 'DELETE'
           AND [REGISTRANT_ID] = @RegistrantId      
        )
    ,Mobile
    AS (
        SELECT DISTINCT
               [REGISTRANT_ID]
              ,[PHONE_NUMBER] AS MobileNumber
              ,[Audit_Date] AS UpdatedDate
              ,CONVERT(INT,'3') AS MyOrder
          FROM [AHOBPR].[REGISTRANT_PHONE_H]
         WHERE [TYPE] = 'Mobile'
           AND [Audit_Type] != 'DELETE'
           AND [REGISTRANT_ID] = @RegistrantId          
        )  
   ,Email
   AS (
       SELECT DISTINCT 
              [REGISTRANT_ID]
             ,[EMAIL]
             ,[Audit_Date] AS UpdatedDate
             ,CONVERT(INT,'4') AS MyOrder          
         FROM [AHOBPR].[REGISTRANT_EMAIL_H]
        WHERE [Audit_Type] != 'DELETE'
          AND [REGISTRANT_ID] = @RegistrantId          
       )
        SELECT Addr.UpdatedDate
              ,Addr.Myorder
              ,[STREET1]
              ,[STREET2]
              ,[CITY]
              ,[STATE]
              ,[ZIP]
              ,[COUNTRY]
              ,NULL AS PhoneNumber
              ,NULL as MobileNumber
              ,NULL as EMAIL
          FROM Addr
       UNION
       SELECT Phone.UpdatedDate
              ,Phone.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,PhoneNumber
              ,NULL as MobileNumber
              ,NULL as EMAIL
          FROM Phone
       UNION
       SELECT Mobile.UpdatedDate
              ,Mobile.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL AS PhoneNumber
              ,MobileNumber
              ,NULL as EMAIL
          FROM Mobile        
        UNION
        SELECT Email.UpdatedDate
              ,Email.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL AS PhoneNumber
              ,NULL AS MobileNumber
              ,Email.EMAIL
          FROM Email          
          ORDER BY UpdatedDate DESC, MyOrder ASC;
          
          
    OPEN MyCursor;
    
    FETCH NEXT FROM MyCursor  -- priming read
     INTO @UpdatedDate
          ,@MyOrder   
          ,@Street1   
          ,@Street2   
          ,@City      
          ,@State     
          ,@Zip       
          ,@Country   
          ,@PhoneNumber
          ,@MobileNumber
          ,@Email;       
    
    SET @UpdatedDateOut = @UpdatedDate;          
     
    WHILE @@FETCH_STATUS = 0 -- Not End of file
      BEGIN
        -- If new date, or nowhere to put data value, Insert into temp and clear Output variables
        IF (@UpdatedDate != @UpdatedDateOut AND @RowCount > 0)
        OR (@MyOrder = 1 AND @Street1Out IS NOT NULL)
        OR (@MyOrder = 2 AND @PhoneNumberOut IS NOT NULL)
        OR (@MyOrder = 3 AND @MobileNumberOut IS NOT NULL)
        OR (@MyOrder = 4 AND @EmailOut IS NOT NULL)
        BEGIN
         INSERT INTO @Results (UpdatedDate
                             ,[STREET1]
                             ,[STREET2]
                             ,[CITY]        
                             ,[STATE]         
                             ,[ZIP]          
                             ,[COUNTRY]        
                             ,PhoneNumber     
                             ,MobileNumber    
                             ,EMAIL  )
                      VALUES(@UpdatedDateOut
                            ,@Street1Out
                            ,@Street2Out
                            ,@CityOut
                            ,@StateOut
                            ,@ZipOut
                            ,@CountryOut
                            ,@PhoneNumberOut
                            ,@MobileNumberOut
                            ,@EmailOut);
                            
         SET @UpdatedDateOut = @UpdatedDate;
         SET @Street1Out = NULL;
         SET @Street2Out = NULL;
         SET @CityOut = NULL;
         SET @StateOut = NULL;
         SET @ZipOut = NULL;
         SET @CountryOut = NULL;
         SET @PhoneNumberOut = NULL;
         SET @MobileNumberOut = NULL;
         SET @EmailOut = NULL;                           
        END
        
        SET @RowCount = @RowCount + 1;
        
        -- Set Address Fields
        IF @MyOrder = 1
           BEGIN
             SET @Street1Out = @Street1;
             SET @Street2Out = @Street2;
             SET @CityOut = @City;
             SET @StateOut = @State;
             SET @ZipOut = @Zip;
             SET @CountryOut = @Country;
           END;
                      
        -- Set Phone Number
        IF @MyOrder = 2   
           SET @PhoneNumberOut = @PhoneNumber;
           
        IF @MyOrder = 3
           SET @MobileNumberOut = @MobileNumber;
           
        IF @MyOrder = 4
           SET @EmailOut = @Email;        
      
        FETCH NEXT FROM MyCursor
         INTO @UpdatedDate
              ,@MyOrder   
              ,@Street1   
              ,@Street2   
              ,@City      
              ,@State     
              ,@Zip       
              ,@Country   
              ,@PhoneNumber
              ,@MobileNumber
              ,@Email;       
          
      END;  -- End of loop   
      
      --write last record
     INSERT INTO @Results (UpdatedDate
                   ,[STREET1]
                   ,[STREET2]
                   ,[CITY]        
                   ,[STATE]         
                   ,[ZIP]          
                   ,[COUNTRY]        
                   ,PhoneNumber     
                   ,MobileNumber    
                   ,EMAIL  )
            VALUES(@UpdatedDateOut
                  ,@Street1Out
                  ,@Street2Out
                  ,@CityOut
                  ,@StateOut
                  ,@ZipOut
                  ,@CountryOut
                  ,@PhoneNumberOut
                  ,@MobileNumberOut
                  ,@EmailOut);
    CLOSE MyCursor;
    
    SELECT UpdatedDate
          ,ISNULL(STREET1,'') AS Street1 
          ,ISNULL(STREET2,'') AS Street2
          ,ISNULL(CITY,'') AS City
          ,ISNULL(STATE,'') AS State
          ,ISNULL(ZIP,'') AS Zip
          ,ISNULL(COUNTRY,'') AS Country
          ,ISNULL(PhoneNumber,'') AS PhoneNumber
          ,ISNULL(MobileNumber,'') AS MobileNumber
          ,ISNULL(EMAIL,'') AS Email        
      FROM @Results
  ORDER BY UpdatedDate DESC;    
  
  END 
  
  -- EXECUTE [AHOBPR].[SP_ReportContactHistory] 5
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_LoadDodDeploymentInsert]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
IF EXISTS (select * from sys.procedures where name = 'SP_LoadDodDeploymentInsert'
                AND schema_id = (SELECT schema_id FROM sys.schemas WHERE name = 'AHOBPR')
           )
  DROP PROCEDURE [AHOBPR].[SP_LoadDodDeploymentInsert];
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 2015-08-07
-- Description:	Move data from Staged table, creating orphans and massaging data

-- Modification log
CREATE PROCEDURE [AHOBPR].[SP_LoadDodDeploymentInsert]
AS
BEGIN

  PRINT 'Truncate DoD Depoyment...';
  
  TRUNCATE TABLE [AHOBPR].[DOD_DEPLOYMENT_IMPORT];

  PRINT 'Add Orphan Country codes if needed...';

  WITH Staged
  AS( 
      SELECT DISTINCT LOCATION
        FROM AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT
     )
     INSERT INTO [AHOBPR].[STD_COUNTRY]
             ([CODE]
             ,[DESCRIPTION])
     SELECT LOCATION,
            LOCATION + ' - Orphan'
       FROM Staged
  WHERE NOT EXISTS(SELECT [CODE]
                     FROM [AHOBPR].[STD_COUNTRY]
                     WHERE [CODE] = LOCATION);
                     
  PRINT 'Add Orphan Pay Grade codes if needed...';

  WITH Staged
  AS( 
      SELECT DISTINCT GRADE
        FROM AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT
     )
     INSERT INTO AHOBPR.STD_PAY_PLAN_GRADE
             ([CODE]
             ,[DESCRIPTION])
     SELECT GRADE,
            GRADE + ' - Orphan'
       FROM Staged
  WHERE NOT EXISTS(SELECT [CODE]
                     FROM AHOBPR.STD_PAY_PLAN_GRADE
                     WHERE [CODE] = GRADE);

  PRINT 'Set Service Name values...';

  WITH MasterData
  AS (
      SELECT *
        FROM ( VALUES
        ('A','Army'),
        ('C','Coast Guard'),
        ('F','Air Force'),
        ('M','Marine Corps'),
        ('N','Navy')
              ) Record(Code, ServiceName)
       )
  ,Src 
  AS (
  SELECT Staged.DEPLOYMENT_ID, ServiceName
    FROM MasterData
    JOIN AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Staged
      ON Staged.SVC = MasterData.Code
      )
  MERGE INTO AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Tgt
  USING Src
     ON Tgt.DEPLOYMENT_ID = Src.DEPLOYMENT_ID
  WHEN MATCHED
  THEN UPDATE
          SET Tgt.[Service] = Src.ServiceName;

  PRINT 'Set Component Name values...';

  WITH MasterData
  AS (
      SELECT *
        FROM ( VALUES
        ('R','Regular'),
        ('V','Reserve'),
        ('G','Guard')
              ) Record(Code, CompoName)
       )
  ,Src 
  AS (
  SELECT Staged.DEPLOYMENT_ID, CompoName
    FROM MasterData
    JOIN AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Staged
      ON Staged.COMPO = MasterData.Code
      )
  MERGE INTO AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Tgt
  USING Src
     ON Tgt.DEPLOYMENT_ID = Src.DEPLOYMENT_ID
  WHEN MATCHED
  THEN UPDATE
          SET Tgt.[Component] = Src.CompoName;

  PRINT 'Load from Statged into DOD Deployment..';
                     
  DECLARE @Now DATETIME2(0) = GETDATE();
  DECLARE @DefaultStart DATETIME2(0) = '20010101';

  INSERT INTO [AHOBPR].[DOD_DEPLOYMENT_IMPORT]
             ([EDIPI]
             ,[SERVICE]
             ,[COMPO]
             ,[LOCATION]
             ,[DEPLOYMENT_START_DATE]
             ,[DEPLOYMENT_END_DATE]
             ,[LOCATION_START_DATE]
             ,[LOCATION_END_DATE]
             ,[PAY_PLAN_GRADE]
             ,[IMPORT_DATE])
  SELECT [EDIPI]
        ,ISNULL(SUBSTRING([Service],1,15),SVC)
        ,ISNULL(SUBSTRING([Component],1,10),COMPO)
        ,[LOCATION]
        ,ISNULL([DEP_BGN_CDT], @DefaultStart)
        ,ISNULL([DEP_END_CDT], @Now)
        ,ISNULL([LOC_BEGIN_DATE], @DefaultStart)
        ,ISNULL([LOC_END_DATE], @Now)
        ,[GRADE]
        ,@Now
        --,[PN_SEX_CD] -- New fields to be added next release
        --,[MRTL_STAT_CD]
        --,[EDU_LVL_CD]
        --,[RACE_CD]
        --,[ETH_AFF_CD]
        --,[DTY_DOD_OCC_CD]
    FROM [AHOBPR].[STAGED_DOD_DEPLOYMENT_IMPORT];
    
END;
    -- EXECUTE  [AHOBPR].[SP_LoadDodDeploymentInsert]    -- about 8 minutes
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Refreshing [AHOBPR].[SP_GetJsonQueue]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
EXECUTE sp_refreshsqlmodule N'[AHOBPR].[SP_GetJsonQueue]';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Refreshing [AHOBPR].[SP_InsertJsonQueue]...';


GO
EXECUTE sp_refreshsqlmodule N'[AHOBPR].[SP_InsertJsonQueue]';


GO
PRINT N'Refreshing [AHOBPR].[SP_UpdateFromCDW]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
EXECUTE sp_refreshsqlmodule N'[AHOBPR].[SP_UpdateFromCDW]';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Checking existing data against newly created constraints';


GO
USE [$(DatabaseName)];


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_STD_SEPARATION_REASON2];


GO
PRINT N'Update complete.';

GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';
go
------------------------------------------------------------
------------------------------------------------------------
-- 2.0.11.1
------------------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "11"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.11.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!',11
              ,1);
   SET NOCOUNT ON;
   SET NOEXEC ON;
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO
SET NOCOUNT ON;
GO

DECLARE  @RegistryId int = (SELECT ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR');
DECLARE  @Today Datetime = GETDATE();

DELETE FROM [dbo].[STD_GUI_CONTROLS] WHERE [STD_REGISTRY_ID] = @RegistryId;

INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_SEARCH', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name', '1', @Today, @Today, 'DBA', 'DBA', NULL, '100', NULL, 'False', 'True', 'Last Name:<br />', NULL, NULL, NULL, '50', 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_SEARCH', 'Last Four Digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant Last Four Digists of SSN', '2', @Today, @Today, 'DBA', 'DBA', NULL, '50', NULL, 'False', 'True', 'Last Four Digits of SSN:<br />', NULL, NULL, NULL, '4', 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_SEARCH', 'Registry Status', '4', 'BaseControlDropdownListRegistryStatus', NULL, NULL, 'Registrant Registry Status', '4', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', NULL, NULL, 'False', 'True', 'Registry Status:<br />', NULL, NULL, NULL, NULL, 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_SEARCH', 'Registry Flags', '4', 'BaseControlDropdownListRegistryFlag', NULL, NULL, 'Registrant Registry Flags', '5', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_FLAG', NULL, NULL, 'False', 'True', 'Registry Flags:<br />', NULL, NULL, NULL, NULL, 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_STATUSBYLOCATION', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_STATUSBYLOCATION', 'Report Sate Parameters', '5', 'BaseControlListBoxState', NULL, NULL, 'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_STATE', '170', '170', 'False', 'True', 'State:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Full Name', '1', 'BaseControlLabelName', NULL, NULL, 'Registrant Full Name', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Name: &nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Date of Birth', '1', 'BaseControlLabelDob', NULL, NULL, 'Registrant Date of Birth', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Date of Birth (mm/dd/yyyy):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Gender', '1', 'BaseControlLabelGender', NULL, NULL, 'Registrant Gender', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Gender:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Duty Status', '1', 'BaseControlLabelDutyStatus', NULL, NULL, 'Registrant Duty Status', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Duty Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Last 4 SSN', '1', 'BaseControlLabelLast4ssn', NULL, NULL, 'Registrant Last 4 Digists of SSN', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Last 4 SSN:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Edipi', '1', 'BaseControlLabelEdipi', NULL, NULL, 'Registrant Edipi', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'EDIPI:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Status', '1', 'BaseControlLabelRegistryStatus', NULL, NULL, 'Registrant Status', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Email', '1', 'BaseControlLabelEmail', NULL, NULL, 'Registrant Email', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Email:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Phone', '1', 'BaseControlLabelPhone', NULL, NULL, 'Registrant Phone', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Phone:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Questionnaire Completion Date', '1', 'BaseControlLabelQuestionnaireCompletionDate', NULL, NULL, 'Registrant Questionnaire Completion Date', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Questionnaire Completion Date:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Address', '1', 'BaseControlLabelAddress', NULL, NULL, 'Registrant Address', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Address:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Report Health Concerns', '1', 'BaseControlLabelHealthConcern', NULL, NULL, 'Report Health Concerns?', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Report Health Concerns?&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Request to be Seen', '1', 'BaseControlLabelRequestToBeSeen', NULL, NULL, 'Request to be Seen?', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Request to be Seen?&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Subpopulation Flags', '1', 'BaseControlLabelSubpopulationFlags', NULL, NULL, 'Subpopulation Flags for a Registrant', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Subpopulation Flags:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Last Admin Flag Set', '1', 'BaseControlLabelLastOutreach', NULL, NULL, 'Last Admin Flag Set for a Registrant', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Last Admin Flag Set:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Duty Status', '5', 'BaseControlListBoxDutyStatus', NULL, NULL, 'Duty Status is the military standing of the registrant: Veteran, Retiree, or Active Duty. The Selection Criteria allows the user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_SERVICE_STATUS', NULL, NULL, 'False', 'True', 'Duty Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Question Number', '4', 'BaseControlDropdownListQuestions', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_FORM_QUESTION', NULL, NULL, 'False', 'True', 'Questions:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Question Response', '4', 'BaseControlDropdownListQuestionReponse', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '150', '150', 'False', 'True', 'Answers:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Radio Button Health Concersn', '3', 'BaseControlRadioButtonListHealthConcerns', NULL, NULL, 'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CHANGE_STATUS_REGISTRANT_SEARCH', 'Change Status Registrant Search Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Registrant Registry Status', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS_INELIGIBLE', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CHANGE_STATUS', 'Change Status for a Registrant', '3', 'BaseControlRadioButtonListStatus', NULL, NULL, 'Registrant Registry Status', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS_REVIEWED', NULL, NULL, 'False', 'True', 'Change Status To:&nbsp&nbsp&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelChangeStatus')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Answer', '5', 'BaseControlListBoxAnswer', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '200', '200', 'False', 'True', 'Answer:<br />', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Search Criteria Name', '2', 'BaseControlTextBoxSearchCriteriaName', 'Search Criteria Name is required.', NULL, 'Search Criteria Name', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'True', 'True', 'Search Criteria Name: ', NULL, NULL, 'OnSaveSearchCriteria', '256', 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with Registrant status=Participant', '1', 'BaseControlLabelParticipantStatus', NULL, NULL, 'Number of respondents with Registrant status=Participant', '1', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with Registrant status=Participant', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with reported health concerns', '1', 'BaseControlLabelHealthConcern', NULL, NULL, 'Number of respondents with reported health concerns', '2', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with reported health concerns', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with no reported health concerns', '1', 'BaseControlLabelNoHealthConcern', NULL, NULL, 'Number of respondents with no reported health concerns', '3', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with no reported health concerns', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with beneficiary status=Current Veteran', '1', 'BaseControlLabelVeteran', NULL, NULL, 'Number of respondents with beneficiary status=Current Veteran', '4', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with beneficiary status=Current Veteran', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with beneficiary status=Active Duty', '1', 'BaseControlLabelActiveDuty', NULL, NULL, 'Number of respondents with beneficiary status=Active Duty', '5', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with beneficiary status=Active Duty', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with beneficiary status=Retiree', '1', 'BaseControlLabelRetiree', NULL, NULL, 'Number of respondents with beneficiary status=Retiree', '6', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with beneficiary status=Retiree', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Iraq on or after Sept 11, 2001', '1', 'BaseControlLabelIrapAfter911', NULL, NULL, 'Number of respondents Deployed to Iraq on or after Sept 11, 2001', '7', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Iraq on or after Sept 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Afghanistan on or after Sept 11, 2001', '1', 'BaseControlLabelAfghanistanAfter911', NULL, NULL, 'Number of respondents Deployed to Afghanistan on or after Sept 11, 2001', '8', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Afghanistan on or after Sept 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Southwest Asia theater of operations after August 2nd, 1990 and prior to September 11, 2001', '1', 'BaseControlLabelAsiaBefore911', NULL, NULL, 'Number of respondents Deployed to Southwest Asia theater of operations after August 2nd, 1990 and prior to September 11, 2001', '9', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Southwest Asia theater of operations after August 2nd, 1990 and prior to September 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Southwest Asia (w/o Iraq) on or after Sept 11, 2001', '1', 'BaseControlLabelSouthwestAsiaAfter911', NULL, NULL, 'Number of respondents Deployed to Southwest Asia (w/o Iraq) on or after Sept 11, 2001', '10', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Southwest Asia (w/o Iraq) on or after Sept 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents that wish to discuss health concerns (Answer to Q7.B=Yes)', '1', 'BaseControlLabelDiscussHealthConcern', NULL, NULL, 'Number of respondents that wish to discuss health concerns (Answer to Q7.B=Yes)', '11', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents that wish to discuss health concerns (Answer to Q7.B=Yes)', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents that do not wish to discuss health concerns (Answer to Q7.B=No)', '1', 'BaseControlLabelNoDiscussHealthConcern', NULL, NULL, 'Number of respondents that do not wish to discuss health concerns (Answer to Q7.B=No)', '12', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents that do not wish to discuss health concerns (Answer to Q7.B=No)', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents that dont know if they wish to discuss health concerns (Answer to Q7.B=Dont know)', '1', 'BaseControlLabelUnknownDiscussHealthConcern', NULL, NULL, 'Number of respondents that dont know if they wish to discuss health concerns (Answer to Q7.B=Dont know)', '13', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents that dont know if they wish to discuss health concerns (Answer to Q7.B=Dont know)', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Median number of days from change of Registrant Record status=Eligible to Registrant Record status=Participant', '1', 'BaseControlLabelMedianTimeCompleteForm', NULL, NULL, 'Median number of days from change of Registrant Record status=Eligible to Registrant Record status=Participant', '14', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Median number of days from change of Registrant Record status=Eligible to Registrant Record status=Participant', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFORMATION', 'Report Duty Status', '5', 'BaseControlListBoxDutyStatus', NULL, NULL, 'Duty Status is the military standing of the registrant: Veteran, Retiree, or Active Duty. The Selection Criteria allows the user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_SERVICE_STATUS', NULL, NULL, 'False', 'True', 'Duty Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFORMATION', 'Report  Registrant Status', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFORMATION', 'Report Subpopulation Flag', '4', 'BaseControlDropDownListSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', @Today, @Today, 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', NULL, NULL, 'False', 'True', 'Subpopulation Flag:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Subpopulation Flag', '4', 'BaseControlDropDownListSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', @Today, @Today, 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', NULL, NULL, 'False', 'True', 'Subpopulation Flag:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Health Factor', '5', 'BaseControlListBoxHealthFactor', NULL, NULL, 'Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation.  This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation.  The Selection Criteria allows the user to filter with one or more health factors.', '0', @Today, @Today, 'DBA', 'DBA', 'HEALTH_FACTOR', '350', '350', 'False', 'True', 'Health Factor:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Deployment Country All', '4', 'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments.  ', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY', NULL, NULL, 'False', 'True', 'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Deployment Country With Exposure Response', '4', 'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 'False', 'True', 'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ELIGIBILITY_REVIEW', 'Report  Registrant Status', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CHANGE_STATUS_REGISTRANT_SEARCH', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name', '1', @Today, @Today, 'DBA', 'DBA', NULL, '100', NULL, 'False', 'True', 'Last Name:<br />', NULL, NULL, NULL, '50', 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CHANGE_STATUS_REGISTRANT_SEARCH', 'Last Four Digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant Last Four Digists of SSN', '2', @Today, @Today, 'DBA', 'DBA', NULL, '50', NULL, 'False', 'True', 'Last Four Digits of SSN:<br />', NULL, NULL, NULL, '4', 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Djibouti on or after Sept 11, 2001', '1', 'BaseControlLabelDjiboutiAfter911', NULL, NULL, 'Number of respondents Deployed to Djibouti on or after Sept 11, 2001', '15', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Djibouti on or after Sept 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_HEALTH_FACTOR', 'Reported History of Asthma as Recorded by the Provider', '1', 'BaseControlLabelAsthma', NULL, NULL, 'Reported History of Asthma as Recorded by the Provider', '1', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Reported History of Asthma as Recorded by the Provider', NULL, NULL, NULL, NULL, 'PanelHealthFactor')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_HEALTH_FACTOR', 'Reported Initiation or Increase in Tobacco Smoking During Deployment', '1', 'BaseControlLabelSmokingDeployment', NULL, NULL, 'Reported Initiation or Increase in Tobacco Smoking During Deployment', '2', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Reported Initiation or Increase in Tobacco Smoking During Deployment', NULL, NULL, NULL, NULL, 'PanelHealthFactor')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_HEALTH_FACTOR', 'Reported Tobacco Smoking History', '1', 'BaseControlLabelTobacco', NULL, NULL, 'Reported Tobacco Smoking History', '3', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Reported Tobacco Smoking History', NULL, NULL, NULL, NULL, 'PanelHealthFactor')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_HEALTH_FACTOR', 'Presence of Birth Defects in Children', '1', 'BaseControlLabelBirthDefects', NULL, NULL, 'Presence of Birth Defects in Children', '4', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Presence of Birth Defects in Children', NULL, NULL, NULL, NULL, 'PanelHealthFactor')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Full Name', '1', 'BaseControlTextboxFullName', 'Full Name is required.', NULL, 'Full Name', '0', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Full Name:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'First Name', '1', 'BaseControlTextboxFirstName', 'First Name is required.', NULL, 'First Name', '1', '2015-05-07 00:00:00.000', '2015-05-07 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'First Name:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Middle Name', '1', 'BaseControlTextBoxMiddleName', NULL, NULL, 'Middle Name', '2', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Middle Name:', NULL, NULL, NULL, NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Last Name', '1', 'BaseControlTextBoxLastName', 'Last Name is required.', NULL, 'Last Name', '3', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Last Name:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Maiden Name', '1', 'BaseControlTextBoxMaidenName', NULL, NULL, 'Maiden Name', '4', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Maiden Name:', NULL, NULL, NULL, NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Employee Number', '1', 'BaseControlTextBoxEmployeeNumber', NULL, NULL, 'Employee Number', '5', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Employee Number:', NULL, NULL, NULL, NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Job Title', '1', 'BaseControlTextBoxJobTitle', 'Job Title is required.', NULL, 'Job Title', '6', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Job Title:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Email Address', '1', 'BaseControlTextBoxEmail', 'Email Address is required.', NULL, 'Email Address', '7', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Email Address:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Phone Number', '1', 'BaseControlTextBoxTelephone', 'Telephone Number is required.', NULL, 'Telephone Number', '8', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Telephone Number:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Fax', '1', 'BaseControlTextBoxFax', NULL, NULL, 'Fax Number', '9', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Fax Number:', NULL, NULL, NULL, NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Race', '1', 'BaseControlLabelRace', NULL, NULL, 'Registrant''s Race', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Race:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInformation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Ethnicity', '1', 'BaseControlLabelEthnicity', NULL, NULL, 'Ethnicity', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Ethnicity:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Marital Status', '1', 'BaseControlLabelMaritalStatus', NULL, NULL, 'MaritalSttus', '0', '2015-05-19 13:22:24.530', '2015-05-09 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Marital Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'VitalStatus', '1', 'BaseControlLabelVitalStatus', NULL, NULL, 'Vital Status', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Vital Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Education Level', '1', 'BaseControlLabelEducationLevel', NULL, NULL, 'Eduaction Level', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Education Level:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Current Branch of Service', '1', 'BaseControlLabelCurrentBranchOfSvc', NULL, NULL, 'Current Branch of Service', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Current Branch Of Service:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Branch of Service at First Login', '1', 'BaseControlLabelBranchSvcFirstLogin', NULL, NULL, 'Branch of Service at First Login', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Branch of Service at First Login:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Current Component', '1', 'BaseControlLabelCurrentComponent', NULL, NULL, 'Current Component', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Current Component:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Component at FirstLogin', '1', 'BaseControlLabelComponentFirstLogin', NULL, NULL, 'Component at First Login', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Component at First Login:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Most recent Separation Type', '1', 'BaseControlLabelMostRecentSepType', NULL, NULL, 'Most recent Separation Type', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Most recent Separation Type:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelSeparationInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Separation Type at First Login', '1', 'BaseControlLabelSepTypeFirstLogin', NULL, NULL, 'Separation Type at First Login', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Separation Type at First Login:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelSeparationInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Most recent Separation Date', '1', 'BaseControlLabelMostRecentSepDate', NULL, NULL, 'Most recent Separation Date', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Most recent Separation Date:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelSeparationInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Separation Date at First Login', '1', 'BaseControlLabelSepDateFirstLogin', NULL, NULL, 'Separation Date at First Login', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Separation Date at First Login:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelSeparationInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Contact Preference', '1', 'BaseControlLabelContactPreferance', NULL, NULL, 'Contact Preference', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Contact Preference:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Phone', '1', 'BaseControlLabelPhone', NULL, NULL, 'Phone', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Phone:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Mobile', '1', 'BaseControlLabelMobile', NULL, NULL, 'Mobile', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Mobile:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Email', '1', 'BaseControlLabelEmail', NULL, NULL, 'Email', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Email:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Address', '1', 'BaseControlLabelAddress', NULL, NULL, 'Address', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Address:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFORMATION', 'Report Parmater State', '5', 'BaseControlListBoxState', NULL, NULL, 'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', '0', '2015-05-26 12:00:00.000', '2015-05-26 12:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_STATE', '170', '170', 'False', 'True', 'State:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Race', '4', 'BaseControlDropDownListRace', NULL, NULL, 'Race is the hereditary group to which the registrant identifies with. The Selection Criteria allows the user to filter by one Race.', '0', '2015-06-03 13:22:24.530', '2015-06-03 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_RACE', NULL, NULL, 'False', 'True', 'Race:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Gender', '4', 'BaseControlDropDownListGender', NULL, NULL, 'Gender is the sex of the registrant. The Selection Criteria allows the user to filter by one Gender.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_GENDER', NULL, NULL, 'False', 'True', 'Gender:  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Separation Type', '4', 'BaseControlDropDownListSeparationType', NULL, NULL, 'Separation Type is reason for the Registrants most recent separation.  The Selection Criteria allows the user to filter by one Separation Type.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_SEPARATIONREASON', NULL, NULL, 'False', 'True', 'Separation Type:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Ethnicity', '4', 'BaseControlDropDownListEthnicity', NULL, NULL, 'Ethnicity is the ethnic affiliation of the Registrant. The Selection Criteria allows the user to filter by one Ethnicity.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ETHNICITY', NULL, NULL, 'False', 'True', 'Ethnicity:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Enrollment Status', '4', 'BaseControlDropDownListEnrollmentStatus', NULL, NULL, 'Health Care Enrollment Status is the Registrants status in VA Care. The Selection Criteria allows the user to filter by one Health Care Enrollment Status.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ELIGIBLITYSTATUS', NULL, NULL, 'False', 'True', ' Health Care (VA Care) Enrollment Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Duty Status', '1', 'BaseControlLabelDutyStatus', NULL, NULL, NULL, '0', '2015-06-04 00:00:00.000', '2015-06-17 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Current Duty Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Duty Status at First Login', '1', 'BaseControlLabelDutyStatusFirstLogin', NULL, NULL, NULL, '0', '2015-06-18 00:00:00.000', '2015-06-18 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Duty Status At First Login:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Report Character of Service', '1', 'BaseControlLabelCharOfService', NULL, NULL, NULL, '0', '2015-06-25 00:00:00.000', '2015-06-25 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_CHARACTEROFSERVICE', NULL, NULL, 'False', 'True', 'Character of Service:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Question Text', 2, N'BaseControlTextboxQuestionText', N'Question Text is required.', NULL, N'Question Text', 1, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, 300, 1, 0, N'Question Text: **&nbsp&nbsp', NULL, NULL, N'SaveQuestion', 4000, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Question Type', 7, N'BaseControlRadioButtonListTextValueQuestionType', N'Question Type is required.', NULL, N'Question Type', 2, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', N'TOOL_QUESTION_TYPE', NULL, NULL, 1, 0, N'Question Type: **&nbsp', NULL, NULL, N'SaveQuestion', NULL, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Question Key Words', 2, N'BaseControlTextboxQuestionKeyWords', NULL, NULL, N'Question Key Words', 3, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, 200, 0, 0, N'Key Words:&nbsp&nbsp&nbsp&nbsp', NULL, NULL, NULL, 2000, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Minimum Value', 2, N'BaseControlTextBoxMinValue', N'Minimum Value is numeric only.', N'^[0-9]+$', N'Minimum Value for Free Text Number Field', 4, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, NULL, 0, 0, N'Minimum Value:&nbsp&nbsp', NULL, NULL, N'SaveQuestion', 256, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Max Value', 2, N'BaseControlTextBoxMaxValue', N'Max Value is numeric only.', N'^[0-9]+$', N'Max Value for Free Text Number Field', 5, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, NULL, 0, 0, N'Max Value:&nbsp&nbsp', NULL, NULL, N'SaveQuestion', 256, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION_GROUP', N'Question Group Name', 2, N'BaseControlTextboxFormName', N'Question Group Name is required.', NULL, N'Question Group Name', 1, CAST(0x0000A54600000000 AS DateTime), CAST(0x0000A54600000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, 200, 1, 0, N'Question Group Name: **&nbsp&nbsp', NULL, NULL, N'SaveQuestionGroup', 256, N'PanelEditQuestionGroup')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION_GROUP', N'Question Group Title', 2, N'BaseControlTextboxFormTitle', N'Question Group Title is required.', NULL, N'Question Group Title', 1, CAST(0x0000A54600000000 AS DateTime), CAST(0x0000A54600000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, 300, 1, 0, N'Question Group Notes: **&nbsp&nbsp', NULL, NULL, N'SaveQuestionGroup', 500, N'PanelEditQuestionGroup')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Duty Status', '5', 'BaseControlListBoxDutyStatus', NULL, NULL, 'Duty Status is the military standing of the registrant: Veteran, Retiree, or Active Duty. The Selection Criteria allows the user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_SERVICE_STATUS', NULL, NULL, 'False', 'True', 'Duty Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Question Number', '4', 'BaseControlDropdownListQuestions', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_FORM_QUESTION', NULL, NULL, 'False', 'True', 'Questions:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Question Response', '4', 'BaseControlDropdownListQuestionReponse', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '150', '150', 'False', 'True', 'Answers:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Radio Button Health Concersn', '3', 'BaseControlRadioButtonListHealthConcerns', NULL, NULL, 'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Answer', '5', 'BaseControlListBoxAnswer', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '200', '200', 'False', 'True', 'Answer:<br />', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Search Criteria Name', '2', 'BaseControlTextBoxSearchCriteriaName', 'Search Criteria Name is required.', NULL, 'Search Criteria Name', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'True', 'True', 'Search Criteria Name: ', NULL, NULL, 'OnSaveSearchCriteria', '256', 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Subpopulation Flag', '5', 'BaseControlListBoxSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', '2015-11-11 16:26:06.280', '2015-11-11 16:26:06.280', 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', '300', '300', 'False', 'True', 'Subpopulation Flag:<br>', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Health Factor', '5', 'BaseControlListBoxHealthFactor', NULL, NULL, 'Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation.  This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation.  The Selection Criteria allows the user to filter with one or more health factors.', '0', @Today, @Today, 'DBA', 'DBA', 'HEALTH_FACTOR', '350', '350', 'False', 'True', 'Health Factor:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Deployment Country All', '4', 'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments.  ', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY', NULL, NULL, 'False', 'True', 'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Deployment Country With Exposure Response', '4', 'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 'False', 'True', 'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Race', '4', 'BaseControlDropDownListRace', NULL, NULL, 'Race is the hereditary group to which the registrant identifies with. The Selection Criteria allows the user to filter by one Race.', '0', '2015-06-03 13:22:24.530', '2015-06-03 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_RACE', NULL, NULL, 'False', 'True', 'Race:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Gender', '4', 'BaseControlDropDownListGender', NULL, NULL, 'Gender is the sex of the registrant. The Selection Criteria allows the user to filter by one Gender.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_GENDER', NULL, NULL, 'False', 'True', 'Gender:  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Separation Type', '4', 'BaseControlDropDownListSeparationType', NULL, NULL, 'Separation Type is reason for the Registrants most recent separation.  The Selection Criteria allows the user to filter by one Separation Type.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_SEPARATIONREASON', NULL, NULL, 'False', 'True', 'Separation Type:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Ethnicity', '4', 'BaseControlDropDownListEthnicity', NULL, NULL, 'Ethnicity is the ethnic affiliation of the Registrant. The Selection Criteria allows the user to filter by one Ethnicity.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ETHNICITY', NULL, NULL, 'False', 'True', 'Ethnicity:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Enrollment Status', '4', 'BaseControlDropDownListEnrollmentStatus', NULL, NULL, 'Health Care Enrollment Status is the Registrants status in VA Care. The Selection Criteria allows the user to filter by one Health Care Enrollment Status.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ELIGIBLITYSTATUS', NULL, NULL, 'False', 'True', ' Health Care (VA Care) Enrollment Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Template Title', '4', 'BaseControlDropDownListTemplate', 'Email/Notification is required.', NULL, NULL, '0', '2015-11-04 00:00:00.000', '2015-11-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'TEMPLATE_MESSAGE_TITLE', NULL, NULL, 'True', 'True', 'Email/Notification:&nbsp&nbsp', NULL, NULL,'sendEmailMessage', NULL, 'PanelSend')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Question Response', 4, N'BaseControlDropdownListQuestionReponse', NULL, NULL, N'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with one question and one or more responses.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', NULL, 150, 150, 0, 1, N'Answers:&nbsp&nbsp', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Radio Button Health Concersn', 3, N'BaseControlRadioButtonListHealthConcerns', NULL, NULL, N'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', NULL, NULL, NULL, 0, 0, N'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Status Parameters', 5, N'BaseControlListBoxStatus', NULL, NULL, N'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant. The Selection Criteria allows a user to filter with one or more statuses.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'REGISTRY_STATUS', 150, 150, 0, 1, N'Status:<br />', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Answer', 5, N'BaseControlListBoxAnswer', NULL, NULL, N'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with one question and one or more responses.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', NULL, 200, 200, 0, 1, N'Answer:<br />', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', 'Subpopulation Flag', '5', 'BaseControlListBoxSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user. The Selection Criteria allows the user to filter with one subpopulation flag.', '0', '2015-11-07 00:00:00.000', '2015-11-07 00:00:00.000', 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', '300', '300', 'False', 'True', 'Subpopulation Flag:<br>', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Health Factor', 5, N'BaseControlListBoxHealthFactor', NULL, NULL, N'Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation. This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation. The Selection Criteria allows the user to filter with one or more health factors.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'HEALTH_FACTOR', 350, 350, 0, 1, N'Health Factor:<br />', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Deployment Country All', 4, N'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, N'Deployment Country received from deployment data interfaces. The Selection Criteria allows the user to filter with one country and by all deployments. ', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'DEPLOYMENT_COUNTRY', NULL, NULL, 0, 1, N'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Deployment Country With Exposure Response', 4, N'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, N'Deployment Country received from deployment data interfaces. The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses. The data for deployments that have exposure responses will only be available for registrants in Participant status.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 0, 1, N'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'List of Follow-up Question Group', 4, N'BaseControlDropDownListFollowupQuestionGroup', N'Question Group is required.', NULL, N'Select a follow-up question group from the list', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'FOLLOWUP_QUESTION_GROUP_LIST', NULL, NULL, 1, 1, N'Question Group:&nbsp&nbsp', NULL, NULL, N'SendQuestions', NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Contact Preference', '4', 'BaseControlDropDownListContactPreference', NULL, NULL, 'Contact Preference is for the preferred method of being contacted.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'CONTACT_PREFERENCE', NULL, NULL, 'False', 'True', 'Contact Preference:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Last Name:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Last Four Digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant Last Four Digists of SSN.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Last Four Digits of SSN:&nbsp&nbsp', NULL, NULL, NULL, '4', 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'AHOBPR Evaluation', '3', 'BaseControlRadioButtonListEvaluation', NULL, NULL, 'Radio button for Registrant AHOBPR Evaluation status.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'AHOBPR Evaluation:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Email', '3', 'BaseControlRadioButtonListEmail', NULL, NULL, 'Radio button for Registrants with and without emails.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Emai:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'State', '5', 'BaseControlListBoxState', NULL, NULL, 'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'DBA', 'DBA', 'STD_STATE', '170', '170', 'False', 'True', 'State:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name', '0', '2015-11-20 00:00:00.000', '2015-11-20 00:00:00.000', 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'True', 'Last Name:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', 'Last 4 digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant last Four Digist of SSN', '0', '2015-11-20 00:00:00.000', '2015-11-20 00:00:00.000', 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'True', 'Last Four Digits of SSN:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Report Radio Button Health Concersn', '3', 'BaseControlRadioButtonListHealthConcerns', NULL, NULL, 'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Report Subpopulation Flag', '5', 'BaseControlListBoxSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', '2015-11-11 16:26:06.280', '2015-11-11 16:26:06.280', 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', '300', '300', 'False', 'True', 'Subpopulation Flag:<br>', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Deployment Country All', '4', 'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments.  ', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY', NULL, NULL, 'False', 'True', 'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Deployment Country With Exposure Response', '4', 'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 'False', 'True', 'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Admin Tracking Flag', '4', 'BaseControlDropDownListAdminFlag', NULL, NULL, 'Select Admin Tracking Flag.  ', '0', @Today, @Today, 'DBA', 'DBA', 'ADMINTRACKING_FLAG_ACTIVE', NULL, NULL, 'False', 'True', 'Admin Flag Name:<br>', NULL, NULL, NULL, NULL, 'PanelSubmitFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Subpopulation Flag', '4', 'BaseControlDropDownListSubpopFlag', NULL, NULL, 'Select Subpopulation Flag.', '0', @Today, @Today, 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ACTIVE', NULL, NULL, 'False', 'True', 'Subpopulation Flag Name:<br>', NULL, NULL, NULL, NULL, 'PanelSubmitFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Registry Flag Type', '4', 'BaseControlDropDownListFlagType', NULL, NULL, 'Select Registry Flag Type.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_FLAG_TYPE', NULL, NULL, 'False', 'True', 'RegistryFlag Type:<br>', NULL, NULL, NULL, NULL, 'PanelSubmitFlag')

GO
SET NOCOUNT OFF;
GO
ALTER TABLE [AHOBPR].[TOOL_ANSWER]
	ADD [STANDARD_FLAG] [bit] NOT NULL CONSTRAINT DF_ToolAnswer_StandardFlag DEFAULT 0;
GO

PRINT N'Update complete.';

GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';
go
------------------------------------------------------------
------------------------------------------------------------
-- 2.0.12.1
------------------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "12"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.12.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO

IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[AHOBPR].[SP_GetRegistrantAddFlag]'))
DROP VIEW [AHOBPR].[SP_GetRegistrantAddFlag]
GO
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------

-- =============================================
-- Create date: December 1, 2015
-- Description:	Used to create the list of registrant to add mass Admin & Sub-population flags.  

-- Modification log
-- Added in Script 2.0.12.1
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantAddFlag]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @excludeAdminFlag varchar(1) = 'N',
       @deploymentStartFromDateText varchar(100) = NULL,
       @deploymentStartToDateText varchar(100) = NULL,
       @deploymentCompletionFromDateText varchar(100) = NULL,
       @deploymentCompletionToDateText varchar(100) = NULL
       
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @deploymentStartFromDate DATETIME2(0) = NULL,
          @deploymentStartToDate DATETIME2(0) = NULL,
          @deploymentCompletionFromDate DATETIME2(0) = NULL,
          @deploymentCompletionToDate DATETIME2(0) = NULL
          
  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
  
   --Temp table concatnate flags for Registrants with multiple flags
  CREATE TABLE #state
  (
     [Registrant_Id] INT,
     [state] VARCHAR(8000)
  ) 

  SET @state = REPLACE(@state, 'Foreign Country/Other', 'FM,MH,PW,UM,US,CANAD,MX,EU,PI,FG,OT,UN')

  INSERT INTO #state ([Registrant_Id], [state])
  -- Load Table
  SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
                 FROM AHOBPR.REGISTRANT_ADDRESS b 
                WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                FOR XML PATH('')), 1, 1, '')  [STATE]
    FROM AHOBPR.REGISTRANT a
   GROUP BY a.REGISTRANT_ID;
   
                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
  SET @deploymentStartFromDate = dbo.CleanDate(@deploymentStartFromDateText);
  SET @deploymentStartToDate = dbo.AddMaxTime(dbo.CleanDate(@deploymentStartToDateText));
  SET @deploymentCompletionFromDate = dbo.CleanDate(@deploymentCompletionFromDateText);
  SET @deploymentCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@deploymentCompletionToDateText)); 
  
     

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',s.STATE AS State ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
         
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                             ',RIGHT(a.SSN, 4) AS SSN ' +
		                    'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                'LEFT JOIN #state s ' +  'ON a.REGISTRANT_ID = s.Registrant_Id ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT rd ON a.REGISTRANT_ID =  rd.REGISTRANT_ID ';

  
    
--used to get all registrant without the selected adminflag
IF ISNULL(@excludeAdminFlag, 'N') = 'Y'
    SET @MainQuery = @MainQuery + ' Left JOIN (SELECT REGISTRANT_ID, STD_REGISTRY_FLAG_ID FROM AHOBPR.REGISTRANT_REGISTRY_FLAG  ' +
								  '	WHERE STD_REGISTRY_FLAG_ID IN (' + @adminFlag + '))  AS af on af.REGISTRANT_ID = a.REGISTRANT_ID ';  
     
								  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
    
	
IF ISNULL(@excludeAdminFlag, 'N') = 'Y'	
	SET @MainQuery = @MainQuery + ' AND STD_REGISTRY_FLAG_ID is NULL ';
                                                

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @deploymentStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_START_DATE >= ''' + CONVERT(VARCHAR(20),@deploymentStartFromDate,121) + '''';
     
  IF @deploymentStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_START_DATE <= ''' + CONVERT(VARCHAR(20),@deploymentStartToDate,121) + '''';
    
  IF @deploymentCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_END_DATE >= ''' + CONVERT(VARCHAR(20),@deploymentCompletionFromDate,121) + '''';

  IF @deploymentCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_END_DATE <= ''' + CONVERT(VARCHAR(20),@deploymentCompletionToDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '' AND ISNULL(@excludeAdminFlag,'N') = 'N') 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                                  
                     
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ; 
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
               

                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
  IF ISNULL(@state,'') > ''
    BEGIN
      SET @state = REPLACE(@State,',',''',''');
      SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT DISTINCT addr.REGISTRANT_ID ' + 
                                          'FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                         'WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                           'AND addr.STATE  IN ( ''' + @state + ''') ) ';
    END;  
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
      
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentStartFromDateText  = '20120101' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentAll = 'Iraq,djibouti'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag]
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'
 
GO

---------------------------------------------------------------------------------------------------------
PRINT N'Update complete.';
PRINT 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';  
go
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.13.1
-------------------------------------------------------------  
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "13"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.13.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!',11
              ,1);
   SET NOCOUNT ON;
   SET NOEXEC ON;
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
PRINT 'ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES]...';

ALTER 
  TABLE [AHOBPR].[EMAIL_TEMPLATES]
	ADD   [SALUTATION] [varchar](255)           NOT NULL CONSTRAINT DF_EmailTemplates_Salutation                DEFAULT '',
	      [CONTACT_INFO] [varchar](1000)        NOT NULL CONSTRAINT DF_EmailTemplates_ContactInfo               DEFAULT '',
	      [ADVANCED_USER_FLAG] [bit]            NOT NULL CONSTRAINT DF_EmailTemplates_AdvancedUserFlag          DEFAULT 0;
if not exists (select * from sys.columns where name = 'CREATEDBY_ADVANCED_USER_FLAG'
                and object_id = (select object_id from sys.tables where name = 'EMAIL_TEMPLATES'
                                  and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR'))
              )
  alter 
    table [AHOBPR].[EMAIL_TEMPLATES]
	  add   [CREATEDBY_ADVANCED_USER_FLAG] [bit]  not null constraint DF_EmailTemplates_CreatedbyAdvanceduserFlag default 0;
GO

PRINT 'ALTER VIEW [AHOBPR].[VIEW_LOOKUP]...';
GO
if exists (select * from sys.views where name = 'VIEW_LOOKUP'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists (select * from sys.views where name = 'view_lookup_pre_2_0_13_1'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            )
    drop view AHOBPR.VIEW_LOOKUP
  else
    exec sp_rename 'AHOBPR.VIEW_LOOKUP', 'view_lookup_pre_2_0_13_1';
end;
go
CREATE VIEW [AHOBPR].[VIEW_LOOKUP] 
WITH SCHEMABINDING AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
		OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME = 'Eligibility Review - More Documentation Needed'))
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_FAMILY
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DISCHARGE_CHARACTER
UNION ALL
SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 0
  AND TITLE NOT IN ('Eligible for Burn Pit Registry', 'Not Eligible for Burn Pit Registry', 'New Follow-up Questions') 
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Multiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
UNION ALL
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Multiple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
	   ,STD_FORM_ID AS ID
       ,NAME AS CODE
       ,NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM
  WHERE FOLLOWUP_FLAG = 1
UNION ALL
SELECT DISTINCT 'CONTACT_PREFERENCE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[CONTACT_PREFERENCE] AS CODE
       ,[CONTACT_PREFERENCE] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
  WHERE CONTACT_PREFERENCE > ''
UNION ALL
SELECT 'MY_TEMPLATES_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,CREATEDBY AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 1

-- select * from  [AHOBPR].[VIEW_LOOKUP]
GO

---------------------------------------------------------------------------------------------------------
PRINT N'Update complete.';
PRINT 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';
go
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.14.1
-------------------------------------------------------------  
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "14"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.14.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
PRINT 'RENAME ahobpr.SP_DeleteOneRegistrant to sp_DeleteOneRegistrant_PriorTo2_0_14...';
GO
if exists (select * from sys.procedures where name = 'SP_DeleteOneRegistrant'
            and schema_id = (select SCHEMA_ID from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists ( select * from sys.procedures where name = 'sp_DeleteOneRegistrant_PriorTo2_0_14'
              and schema_id = (select SCHEMA_ID from sys.schemas where name = 'AHOBPR')
            )
    drop procedure ahobpr.SP_DeleteOneRegistrant
  else
    exec sp_rename 'ahobpr.SP_DeleteOneRegistrant', 'sp_DeleteOneRegistrant_PriorTo2_0_14';
end;
GO

PRINT 'CREATE PROCEDURE [AHOBPR].[SP_DeleteOneRegistrant]...';
GO
CREATE PROCEDURE [AHOBPR].[SP_DeleteOneRegistrant]
	@firstName  VARCHAR(50),
	@lastName  VARCHAR(50)
AS

DECLARE @registrantId int, @userId varchar(256)
BEGIN
	SELECT @registrantId = REGISTRANT_ID, @userId = USER_ID FROM [AHOBPR].[REGISTRANT] WHERE FIRST_NAME = @firstName AND LAST_NAME = @lastName
	
	DELETE FROM [AHOBPR].[REGISTRANT_JSON] WHERE OBJECT_ID = @userId

	DELETE FROM [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] WHERE OBJECT_ID = @userId

	DELETE FROM [AHOBPR].[REGISTRANT_FILE] WHERE FILE_ID = @userId

	exec ahobpr.SP_DeleteRegistrantAndResponse @registrantId

END
GO
PRINT 'RENAME ahobpr.SP_DeleteRegistrantAndResponse to SP_DeleteRegistrantAndResponse_PriorTo2_0_14...';
GO
if exists (select * from sys.procedures where name = 'SP_DeleteRegistrantAndResponse'
            and schema_id = (select SCHEMA_ID from sys.schemas where name = 'AHOBPR')
          )
begin
  if exists ( select * from sys.procedures where name = 'SP_DeleteRegistrantAndResponse_PriorTo2_0_14'
              and schema_id = (select SCHEMA_ID from sys.schemas where name = 'AHOBPR')
            )
    drop procedure ahobpr.SP_DeleteRegistrantAndResponse
  else
    exec sp_rename 'ahobpr.SP_DeleteRegistrantAndResponse', 'SP_DeleteRegistrantAndResponse_PriorTo2_0_14';
end;

GO

PRINT 'CREATE PROCEDURE [AHOBPR].[SP_DeleteRegistrantAndResponse]...';
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 4/24/2015
-- Description:	Called after loading Response
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_DeleteRegistrantAndResponse]
       @registrantId INT = NULL 
AS
BEGIN

  DELETE FROM AHOBPR.FORM_RESPONSE_ANSWER
  WHERE FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FORM_RESPONSE_ANSWER_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
            JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE FROM AHOBPR.FORM_RESPONSE_QUESTION
  WHERE FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FORM_RESPONSE_QUESTION_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      
            
  DELETE FROM AHOBPR.FORM_RESPONSE_STATUS
  WHERE FORM_RESPONSE_STATUS_ID IN
         ( 
          SELECT a.FORM_RESPONSE_STATUS_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_STATUS a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      

  DELETE FROM AHOBPR.FORM_RESPONSE   
        WHERE REGISTRANT_ID  = @registrantId;
 
   DELETE FROM AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER
  WHERE FOLLOWUP_FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FOLLOWUP_FORM_RESPONSE_ANSWER_ID
            FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER c ON a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID = c.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE FROM AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION
  WHERE FOLLOWUP_FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
            FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      
            

  DELETE FROM AHOBPR.FOLLOWUP_FORM_RESPONSE   
        WHERE REGISTRANT_ID  = @registrantId;
      
  DELETE FROM AHOBPR.REGISTRANT_DEPLOYMENT   
        WHERE REGISTRANT_ID  = @registrantId;

  DELETE FROM AHOBPR.REGISTRANT_ADDRESS   
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_PHONE
        WHERE REGISTRANT_ID  = @registrantId;  
        
   DELETE FROM AHOBPR.REGISTRANT_EMAIL     
        WHERE REGISTRANT_ID  = @registrantId;  
        
      
  DELETE FROM AHOBPR.REGISTRANT_CONTACT_INFO
        WHERE REGISTRANT_ID  = @registrantId;  
     
  DELETE FROM AHOBPR.REGISTRANT_HEALTH_FACTOR
        WHERE REGISTRANT_VISIT_ID IN
              (SELECT REGISTRANT_VISIT_ID
                 FROM AHOBPR.REGISTRANT_VISIT
                WHERE REGISTRANT_ID = @registrantId);  
        
  DELETE FROM AHOBPR.REGISTRANT_VISIT
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_RECORD_INFO
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_REGISTRY_FLAG
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_SERVICE_EPISODE
        WHERE REGISTRANT_ID  = @registrantId;  
    
  DELETE FROM AHOBPR.PROCESS_METRICS
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.EMAIL_LOG
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT
        WHERE REGISTRANT_ID  = @registrantId;              
END;
-- EXECUTE [AHOBPR].[SP_DeleteRegistrantAndResponse]  140
GO

---------------------------------------------------------------------------------------------------------
PRINT N'Update complete.';
PRINT 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';
go
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.0.15.1
-------------------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "15"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.15.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES]
 ALTER COLUMN [BODY] [varchar](4000) NOT NULL;
GO
 
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES]
 ALTER COLUMN [CONTACT_INFO] [varchar](2000) NOT NULL
GO
 
ALTER TABLE [AHOBPR].[EMAIL_LOG]
 ALTER COLUMN [BODY] [varchar](7000) NULL;
GO

---------------------------------------------------------------------------------------------------------
PRINT N'Update complete.';
PRINT 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';  
go
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.0.16.1
-------------------------------------------------------------  
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "16"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.16.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
PRINT 'rename ahobpr.SP_ReportAdHocByIndividual to SP_ReportAdHocByIndividual_Pre2_0_16_1...';
GO
if exists (select * from sys.procedures where name = 'SP_ReportAdHocByIndividual'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
begin
  if exists (select * from sys.procedures where name = 'SP_ReportAdHocByIndividual_Pre2_0_16_1'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            )
    drop procedure ahobpr.SP_ReportAdHocByIndividual
  else
    exec sp_rename 'ahobpr.SP_ReportAdHocByIndividual', 'SP_ReportAdHocByIndividual_Pre2_0_16_1';
end;
GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters and remove NULLs from display where possible
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-03-30 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 2015-04-27 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce CLegg - Rewrote as Dynamic SQL for performance
-- Deborah Barr Script 2.0.16.1
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByIndividual]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText)); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';

  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    SET @MainQuery = @MainQuery +  ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
                                    ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
                                  ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                                                    

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                              
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;     
                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @RegCriteria = @RegCriteria + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
    
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]  @ethnicity = 'JEWISH'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

GO
PRINT 'CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantContact]...';
GO
if exists (select * from sys.procedures where name = 'SP_ReportRegistrantContact'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
begin
  if exists (select * from sys.procedures where name = 'SP_ReportRegistrantContact_Pre2_0_16_1'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            )
    drop procedure ahobpr.SP_ReportRegistrantContact
  else
    exec sp_rename 'ahobpr.SP_ReportRegistrantContact', 'SP_ReportRegistrantContact_Pre2_0_16_1';
end;

GO

-- =============================================
-- Create date: October 28, 2015
-- Description:	Used to create the list of registrant to send email/notifications to.  

-- Modification log
-- Deborah Barr Script 2.0.16.1
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantContact]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @contactPreference varchar(100) = '',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @formBirthDateText varchar(100) = NULL,
       @email varchar(100) = 'All',
       @evaluation varchar(100) = 'All',
       @excludeAdminFlag varchar(1) = 'N'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
  
 --registrant contact numbers
  CREATE TABLE #phone
  (
     [Registrant_Id] INT,
     [Phone] VARCHAR(50),
  ) 
  
   CREATE TABLE #mobile
  (
     [Registrant_Id] INT,
     [PhoneMobile] VARCHAR(50),
  )  
   INSERT INTO #phone ([Registrant_Id], [Phone])
  -- Load Table
  SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') 
      FROM AHOBPR.REGISTRANT_PHONE	
     WHERE ISNULL(TYPE,'') != 'Mobile'
     
          
 INSERT INTO #mobile ([Registrant_Id], [PhoneMobile])
  -- Load Table
  SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') 
      FROM AHOBPR.REGISTRANT_PHONE	
    WHERE TYPE = 'Mobile'
     
  
     
     
   
  CREATE TABLE #state
  (
     [Registrant_Id] INT,
     [state] VARCHAR(8000)
  ) 

  SET @state = REPLACE(@state, 'Foreign Country/Other', 'FM,MH,PW,UM,US,CANAD,MX,EU,PI,FG,OT,UN')

  INSERT INTO #state ([Registrant_Id], [state])
  -- Load Table
  SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
                 FROM AHOBPR.REGISTRANT_ADDRESS b 
                WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                FOR XML PATH('')), 1, 1, '')  [STATE]
    FROM AHOBPR.REGISTRANT a
   GROUP BY a.REGISTRANT_ID;
   
                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
   SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',a.LAST_NAME AS LAST_NAME ' +
                            ',a.FIRST_NAME AS FIRST_NAME ' +
                            ',a.CONTACT_PREFERENCE AS ContactPreference ' +
                            ',regADDR.STREET1 AS STREET1 ' +
                            ',regADDR.STREET2 AS STREET2 ' +
                            ',regADDR.CITY AS CITY ' +
                            ',regADDR.STATE AS STATE ' +
                            ',regADDR.COUNTRY AS COUNTRY ' +
                            ',regADDR.ZIP AS ZIP ' +
                            ',regPhone.Phone AS  PHONE_NUMBER_Main' +
							',regMobile.PhoneMobile AS  PHONE_NUMBER_Mobile' +
                            ',regEmail.EMAIL AS EMAIL ';
                            
            
    
  SET @MainQuery = @MainQuery + 
		                            
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                'LEFT JOIN #state s ' +  'ON a.REGISTRANT_ID = s.Registrant_Id ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_ADDRESS regAddr ON a.REGISTRANT_ID = regAddr.REGISTRANT_ID ' +
		                            ' LEFT JOIN #phone regPhone ON a.REGISTRANT_ID = regPhone.REGISTRANT_ID ' +
		                            ' LEFT JOIN #mobile regMobile ON a.REGISTRANT_ID = regMobile.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_EMAIL regEmail ON a.REGISTRANT_ID = regEmail.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';
                                
								  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  
	
  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    SET @MainQuery = @MainQuery +  ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
                                    ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
                                  ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                                                    

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';                                         
   IF (@email = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') '
   ELSE IF (@email = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') ' ;  
                          
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ; 
                     
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
               

                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
  IF ISNULL(@state,'') > ''
    BEGIN
      SET @state = REPLACE(@State,',',''',''');
      SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT DISTINCT addr.REGISTRANT_ID ' + 
                                          'FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                         'WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                           'AND addr.STATE  IN ( ''' + @state + ''') ) ';
    END;  
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@contactPreference,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + ''''; 
    
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] 
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @evaluation = 'N', @status = '7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @contactPreference = 'Email from the VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage_changes] @formBirthDateText  = '19770707'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]  @ssn = '1125'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

GO

GO
PRINT 'RENAME PROCEDURE [AHOBPR].[SP_GetRegistrantSendMessage] to SP_GetRegistrantSendMessage_Pre2_0_16_1...';
GO
if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
begin
  if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage_Pre2_0_16_1'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') 
            )
    drop procedure ahobpr.SP_GetRegistrantSendMessage
  else
    exec sp_rename 'ahobpr.SP_GetRegistrantSendMessage', 'SP_GetRegistrantSendMessage_Pre2_0_16_1';
end;

GO
PRINT 'CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendMessage]...';
GO
-- =============================================
-- Create date: October 28, 2015
-- Description:	Used to create the list of registrant to send email/notifications to.  

-- Modification log
-- Deborah Barr Script 2.0.16.1
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendMessage]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @contactPreference varchar(100) = '',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @formBirthDateText varchar(100) = NULL,
       @email varchar(100) = 'All',
       @evaluation varchar(100) = 'All',
       @excludeAdminFlag varchar(1) = 'N'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
    
  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
   SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
                            --',RIGHT(a.SSN, 4) AS SSN ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                            ',RIGHT(a.SSN, 4) AS SSN ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';
  							  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
    

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    SET @MainQuery = @MainQuery +  ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
                                    ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
                                  ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                                                    

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';                                         
   IF (@email = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') '
   ELSE IF (@email = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') ' ;  
                          
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;                        
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                       
  IF ISNULL(@state,'') != '' 
	BEGIN
		SET @state = REPLACE(@State,',',''','''); 
		SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_ADDRESS addr ' +
                        ' WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          'AND addr.STATE  IN ( ''' + @state + ''') ) ';              
	END;
                                                  
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
           
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@contactPreference,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + ''''; 
    
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @evaluation = 'N', @status = '7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @contactPreference = 'Email from the VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage_changes] @formBirthDateText  = '19770707'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]  @ssn = '1125'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

GO

if exists (select * from sys.procedures where name = 'SP_ReportAdHocByLocation'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
begin
  if exists (select * from sys.procedures where name = 'SP_ReportAdHocByLocation_Pre2_0_16_1'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') 
            )
    drop procedure ahobpr.SP_ReportAdHocByLocation
  else
    exec sp_rename 'ahobpr.SP_ReportAdHocByLocation', 'SP_ReportAdHocByLocation_Pre2_0_16_1';
end;
GO

PRINT 'CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByLocation]...';
GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters, Add distinct and outer query to group counts.
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-05-07 - Bruce Clegg - Change Facility name from "Other" to "No Facitilty Assigned" when not found
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce Clegg - Rewrote as Dynamic SQL for performance
-- 2015-08-05 - Bruce Clegg - Fix bug with AdminFlag - Set From and To date defaults
-- 2015-12-11 - D Barr      - added evaluation parameter
-- Deborah Barr - Script 2.0.16.1
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByLocation]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(10) = 'All', 
       @requestToBeSeen varchar(10) = 'All',
       @groupBy VARCHAR(50) = '',                 -- 'VISN' or 'Facility'   
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All'
AS

BEGIN

  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL;
          
  DECLARE @Query VARCHAR(8000);      

  -- Convert date parameters      

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));   

  -- Build Src TDE
  SET @Query = ' WITH Src 
    AS( SELECT a.REGISTRANT_ID, a.STD_INSTITUTION_ID FROM AHOBPR.REGISTRANT a ';
  
  
  SET @Query = @Query + ' WHERE 1 = 1 ';
  
 
                                   
  IF @status IS NOT NULL
    SET @Query = @Query + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @Query = @Query + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @Query = @Query + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @Query = @Query + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
    
  IF @formStartFromDate IS NOT NULL OR @formStartToDate IS NOT NULL 
  OR @formCompletionFromDate IS NOT NULL OR @formCompletionToDate IS NOT NULL
    BEGIN
      SET @Query = @Query + ' AND EXISTS( SELECT d.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE d 
		                        JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID	
		                       WHERE a.REGISTRANT_ID = d.REGISTRANT_ID ';
		  IF @formStartFromDate IS NOT NULL                     
		     SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
		  IF @formStartToDate IS NOT NULL                     
		     SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
		  IF @formCompletionFromDate IS NOT NULL                     
		     SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';
		  IF @formCompletionToDate IS NOT NULL                     
		     SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
		   SET @Query = @Query + ' ) ' -- Close Exisits statement
    END    
    
  IF ISNULL(@answer,'') != '' 
    --SET @Query = @Query + ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' +
    --                      'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID ' +
    --                      'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID ' +
    --                    ' WHERE ra.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';
                        
  SET @Query = @Query + ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
                        'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
                        'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
                        'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
                        'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
                        'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
                        'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
                        ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
                      ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                         
                        
  
  IF ISNULL(@subpopulationFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                            
  IF ISNULL(@healthFactor,'') != ''
    SET @Query = @Query + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

  IF ISNULL(@deploymentAll,'') != '' 
    SET @Query = @Query + ' AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                       ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                           AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;

  IF ISNULL(@deploymentExposure,'') != '' 
    SET @Query = @Query + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID = ''1.2.A'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
IF (@evaluation = 'Yes') 
		 SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @Query = @Query + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;                                    
                                      
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @Query = @Query + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @Query = @Query + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @Query = @Query + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @Query = @Query + ' AND ''' + @separationType + ''' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @Query = @Query + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @Query = @Query + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @Query = @Query + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @Query = @Query + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  -- Add Summary TDE                   
  SET @Query = @Query + '  )	,Summary  AS( ' + 
                        ' SELECT Src.STD_INSTITUTION_ID, COUNT(*) AS TotalRegistrants FROM Src ' +
                        ' GROUP BY STD_INSTITUTION_ID ) ';
-- By Facility 
	IF @groupBy = 'Facility'
	  SET @Query = @Query + ' SELECT inst.Name AS Location, ' +
	                                ' ISNULL(CONVERT(VARCHAR(10),Summary.STD_INSTITUTION_ID),''-1'') AS LocationId, ' +
                                   '  SUM(TotalRegistrants) AS TotalRegistrants FROM Summary ' +		       
	                         '  JOIN AHOBPR.VIEW_INSTITUTION_NAME inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1) ' +
	                         ' GROUP BY inst.Name,STD_INSTITUTION_ID ' +
  		                     ' OPTION (OPTIMIZE FOR UNKNOWN);';
  
-- By VISN
	IF @groupBy = 'VISN'
	   SET @Query = @Query + ' ,VisnSummary AS ( ' +
                 ' SELECT ISNULL(inst.VisnID,''NLA'') AS Location, ' +
                       '  ISNULL(inst.VisnID, ''-1'') AS LocationId, ' +
                       '  SUM(TotalRegistrants) AS TotalRegistrants ' +		       
                 '   FROM Summary ' +   
                 '   LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1) ' +  
                 '   GROUP BY inst.VisnID  ) ' +
                 ' SELECT REPLACE(Location,''NLA'',''No Facitilty Assigned'') AS Location, ' +
                 '        CONVERT(VARCHAR(10),LocationId) AS LocationId, TotalRegistrants ' +
                 '   FROM VisnSummary  ' +
                 '  ORDER BY Location ' + 
                 '  OPTION (OPTIMIZE FOR UNKNOWN); ' ;
	
  PRINT @Query;		
  		                     
  EXECUTE (@Query);  		                     		
END
-- Parameters
  --@status, @dutyStatus ,@questionnaireStartDate, @questionnaireCompleteDate, 
  --@questionNumber, @answer, @healthConcerns= 'All', @requestToBeSeen = 'All',
  --@registryFlag,@InstitutionId = 0, @VisnId = '' 
-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @evaluation = 'No'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthConcerns = 'Yes' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @requestToBeSeen = 'Yes'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentAll = 'Iraq'    -- 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @answer = '2221'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy =  'Facility' , @status = '6,7' ,@answer = '2346,1571,17'   -- '20,795,1570' 

GO


---------------------------------------------------------------------------------------------------------
PRINT N'Update complete.';
PRINT 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';

go
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.0.17.1
-------------------------------------------------------------  
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "17"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.17.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name = 'SP_GetRegistrantAddFlag'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
begin
  if exists (select * from sys.procedures where name = 'SP_GetRegistrantAddFlag_Pre2_0_17'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') 
            )
    drop procedure ahobpr.SP_GetRegistrantAddFlag
  else
    exec sp_rename 'ahobpr.SP_GetRegistrantAddFlag', 'SP_GetRegistrantAddFlag_Pre2_0_17';
end;
GO
-- =============================================
-- Create date: December 1, 2015
-- Description:	Used to create the list of registrant to add mass Admin & Sub-population flags.  

-- Modification log
-- Part of script 2.0.17.1
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantAddFlag]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @excludeAdminFlag varchar(1) = 'N',
       @deploymentStartFromDateText varchar(100) = NULL,
       @deploymentStartToDateText varchar(100) = NULL,
       @deploymentCompletionFromDateText varchar(100) = NULL,
       @deploymentCompletionToDateText varchar(100) = NULL
       
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @deploymentStartFromDate DATETIME2(0) = NULL,
          @deploymentStartToDate DATETIME2(0) = NULL,
          @deploymentCompletionFromDate DATETIME2(0) = NULL,
          @deploymentCompletionToDate DATETIME2(0) = NULL
          
  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
  
   
  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
  SET @deploymentStartFromDate = dbo.CleanDate(@deploymentStartFromDateText);
  SET @deploymentStartToDate = dbo.AddMaxTime(dbo.CleanDate(@deploymentStartToDateText));
  SET @deploymentCompletionFromDate = dbo.CleanDate(@deploymentCompletionFromDateText);
  SET @deploymentCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@deploymentCompletionToDateText)); 
  
     

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
         
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                             ',RIGHT(a.SSN, 4) AS SSN ' +
		                    'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT rd ON a.REGISTRANT_ID =  rd.REGISTRANT_ID ';


								  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
    
                                                

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @deploymentStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_START_DATE >= ''' + CONVERT(VARCHAR(20),@deploymentStartFromDate,121) + '''';
     
  IF @deploymentStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_START_DATE <= ''' + CONVERT(VARCHAR(20),@deploymentStartToDate,121) + '''';
    
  IF @deploymentCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_END_DATE >= ''' + CONVERT(VARCHAR(20),@deploymentCompletionFromDate,121) + '''';

  IF @deploymentCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_END_DATE <= ''' + CONVERT(VARCHAR(20),@deploymentCompletionToDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';   
                                                  
                     
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ; 
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
               
 IF ISNULL(@state,'') != '' 
	BEGIN
		SET @state = REPLACE(@State,',',''','''); 
		SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_ADDRESS addr ' +
                        ' WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          'AND addr.STATE  IN ( ''' + @state + ''') ) ';              
	END;
                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
              
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
      
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_VISIT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentStartFromDateText  = '20120101' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentAll = 'Iraq,djibouti'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag]
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

GO
if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendQuestions'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') )
begin
  if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendQuestions_Pre2_0_17'
              and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') 
            )
    drop procedure ahobpr.SP_GetRegistrantSendQuestions
  else
    exec sp_rename 'ahobpr.SP_GetRegistrantSendQuestions', 'SP_GetRegistrantSendQuestions_Pre2_0_17';
end;

go

-- =============================================
-- Create date: October 28, 2015
-- Description:	Used to create the list of registrant to send follow-up questions to.  

-- Modification log
-- Part of script 2.0.17.1
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendQuestions]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'Y',
       @excludeAdminFlag varchar(1) = 'N',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @formBirthDateText varchar(100) = NULL
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE()));
  SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, a.SSN,'+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',a.SSN, (a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                            ',RIGHT(a.SSN, 4) AS Last4SSN ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';
 
  
  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    SET @MainQuery = @MainQuery +  ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
                                    ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
                                  ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                                                    

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';   
                                              
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
   IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';  
  
  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
    
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + '''';    
  
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID, a.SSN ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID, a.SSN ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID, a.SSN ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions]
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @status = '6,7'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formStartFromDateText  = '20010101'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formStartToDateText = '20141231'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formCompletionFromDateText  = '20010101'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formCompletionToDateText  = '20141231'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @healthConcerns = 'Yes'     , 
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @subpopulationFlag = '64,65,66,67'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @deploymentAll = 'Egypt'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @deploymentExposure  = 'Iraq'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @lastName = 'horton'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formBirthDateText = '05/05/1975'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @ssn = '1125'
go
if exists (select * from sys.views where name='view_lookup'
           and schema_id = (select schema_id from sys.schemas where name = 'ahobpr')
          )
begin
  if exists (select * from sys.views where name='VIEW_LOOKUP_Pre2_0_17_1'
           and schema_id = (select schema_id from sys.schemas where name = 'ahobpr')
          )
    drop view AHOBPR.VIEW_LOOKUP
  else
    exec sp_rename 'AHOBPR.VIEW_LOOKUP', 'VIEW_LOOKUP_Pre2_0_17_1';
end;
print 'CREATE VIEW [AHOBPR].[VIEW_LOOKUP]...';
GO
CREATE VIEW [AHOBPR].[VIEW_LOOKUP] 
--last updated in 2.0.17.1 script
WITH SCHEMABINDING 
AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
		OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME = 'Eligibility Review - More Documentation Needed'))--2.0.13.1 changed this line
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_FAMILY
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DISCHARGE_CHARACTER
UNION ALL
SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 0
  AND TITLE NOT IN ('Eligible for Burn Pit Registry', 'Not Eligible for Burn Pit Registry', 'New Follow-up Questions', 'Need More Documentation') 
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Multiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
UNION ALL
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Multiple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
	   ,STD_FORM_ID AS ID
       ,NAME AS CODE
       ,NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM
  WHERE FOLLOWUP_FLAG = 1
UNION ALL
SELECT DISTINCT 'CONTACT_PREFERENCE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[CONTACT_PREFERENCE] AS CODE
       ,[CONTACT_PREFERENCE] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
  WHERE CONTACT_PREFERENCE > ''
UNION ALL
SELECT 'MY_TEMPLATES_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,CREATEDBY AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 1

-- select * from  [AHOBPR].[VIEW_LOOKUP]
GO

---------------------------------------------------------------------------------------------------------
PRINT N'Update complete.';
PRINT 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';
go
  
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.0.20.1
-------------------------------------------------------------  
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "20"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.20.1.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO

USE [$(DatabaseName)]
GO
IF EXISTS (SELECT * FROM [dbo].[DatabaseChangeLog]
          WHERE [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            AND [PointReleaseNumber] = '$(PointReleaseNumber)'
            AND [ScriptName]         = '$(ScriptName)')
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

GO
---------------------------------------------------------------------------------------------------------
PRINT 'Script started...';
PRINT GETDATE();
GO
---------------------------------------------------------------------------------------------------------

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[SP_GetRegistrantFile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [AHOBPR].[SP_GetRegistrantFile]
GO

CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantFile]
 @fileType VARCHAR(100),
 @fileId VARCHAR(256)
AS

BEGIN

      SELECT FILE_CONTENT
        FROM 
            AHOBPR.REGISTRANT_FILE
        WHERE FILE_ID = @fileId AND FILE_TYPE = @fileType 
END
-- EXECUTE AHOBPR.SP_JsonGetCurrent 5187
GO

---------------------------------------------------------------------------------------------------------
PRINT N'Update complete.';
PRINT 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


GO
UPDATE  [dbo].[DatabaseChangeLog]
  SET   ScriptDescription = 'Script Completed Successfully.'
  WHERE [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    AND [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    AND [PointReleaseNumber]  = '$(PointReleaseNumber)'
    AND [ScriptName]          = '$(ScriptName)'
    AND TargetRegistry        = 'AHOBPR';
   
GO
SELECT * FROM [dbo].[DatabaseChangeLog]
WHERE TargetRegistry        = 'AHOBPR'
  AND [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  AND [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  AND [PointReleaseNumber] = '$(PointReleaseNumber)'
  AND [ScriptName] = '$(ScriptName)';
go
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.0.20.2 (H Tables)
-------------------------------------------------------------
--:setvar DatabaseName "Registry"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "20"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.20.2.sql"

print ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
set nocount off;
go
if N'$(__IsSqlCmdEnabled)' not like N'True'
begin
    print N'SQLCMD mode must be enabled to successfully execute this script.';
    set nocount on;
    set noexec on; --When set NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
end

go

use [$(DatabaseName)]
go
if exists (select * from [dbo].[DatabaseChangeLog]
          where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
            and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
            and [PointReleaseNumber] = '$(PointReleaseNumber)'
            and [ScriptName]         = '$(ScriptName)')
begin
   raiserror('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
end
else
  insert 
    into [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       values
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE());

go
---------------------------------------------------------------------------------------------------------
print 'Script started...';
print getdate();
---------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[AHOBPR_USER_H]') AND type in (N'U'))
DROP TABLE [AHOBPR].[AHOBPR_USER_H]
GO
create 
  table [AHOBPR].[AHOBPR_USER_H]
        (
          [Audit_AHOBPR_USER_H_ID] [int] identity(1,1) not null
        , [Audit_Date] [datetime] not null
        , [Audit_Type] [varchar](20) not null
        , [Audit_ApplicationUser] [varchar](128)
        , [Audit_SQLUser] [varchar](100)
        , [USER_ID] [int]
        , [LAST_LOGIN] [datetime]
        , [LAST_VISTA_LOGIN] [datetime]
        , [ACTIVE_FLAG] [bit]
        , [CREATED] [datetime]
        , [CREATEDBY] [varchar](30)
        , [UPDATED] [datetime]
        , [UPDATEDBY] [varchar](30)
        , [PENDING_FLAG] [bit]
        , constraint [AHOBPR_USER_H_PK] 
          primary key clustered ([Audit_AHOBPR_USER_H_ID] asc)
          with  ( pad_index = off, statistics_norecompute = off, ignore_dup_key = off, allow_row_locks = on, allow_page_locks = on ) 
          on [PRIMARY]
        ) 
  on [PRIMARY]
go
create 
  trigger [AHOBPR].[TRG_AHOBPR_USER_H] on [AHOBPR].[AHOBPR_USER]
  after update, insert
as 
begin
  declare @lv_change varchar(15)
        , @cdeleted int
        , @cinserted int
        , @cSftDelete int;
  select @cdeleted =count(*) from deleted;
  select @cinserted =count(*) from inserted;

  insert 
    into  [AHOBPR].[AHOBPR_USER_H]
          ( [Audit_Date]
          , [Audit_Type]
          , [Audit_ApplicationUser]
          , [Audit_SQLUser] 
          , [USER_ID]
          , [LAST_LOGIN]
          , [LAST_VISTA_LOGIN]
          , [ACTIVE_FLAG]
          , [CREATED]
          , [CREATEDBY]
          , [UPDATED]
          , [UPDATEDBY]
          , [PENDING_FLAG]
          )
    select getdate()
        , lv_Change= case 
                          when @cdeleted=0 and @cinserted>0 then 'insert'
                          when @cdeleted>0 and @cinserted>0 then 'update'
                          else null
                      end
        , HCB = case 
                      when @cdeleted=0 and @cinserted>0 then CreatedBy
                      when @cdeleted>0 and @cinserted>0 then UpdatedBy
                      else null
                end
        , suser_sname()
        , [USER_ID]
        , [LAST_LOGIN]
        , [LAST_VISTA_LOGIN]
        , [ACTIVE_FLAG]
        , [CREATED]
        , [CREATEDBY]
        , [UPDATED]
        , [UPDATEDBY]
        , [PENDING_FLAG]

  from inserted
end
go

create 
  trigger  [AHOBPR].[TRG_AHOBPR_USER_DEL_H]
  on  [AHOBPR].[AHOBPR_USER] after delete
as
begin 
  declare @pos int, @vchar varchar(128)
  set @pos = 1
  set @vchar = cast(CONTEXT_INFO()as varchar(128))
  
  --Remove all 0x0 (keep only text)
  while not ascii(substring(@vchar,@pos,1))=0 
  begin
    set @pos = @pos + 1
  end
  
  set @vchar = SUBSTRING(@vchar, 1, @pos - 1)
  insert 
    into  [AHOBPR].[AHOBPR_USER_H]
          ( [Audit_Date]
          , [Audit_Type]
          , [Audit_ApplicationUser]
          , [Audit_SQLUser] 
          , [USER_ID]
          , [LAST_LOGIN]
          , [LAST_VISTA_LOGIN]
          , [ACTIVE_FLAG]
          , [CREATED]
          , [CREATEDBY]
          , [UPDATED]
          , [UPDATEDBY]
          , [PENDING_FLAG]
          )
    select  getdate()
          , lv_Change=  'delete'
          , HCB= @vchar
          , suser_sname()
          , [USER_ID]
          , [LAST_LOGIN]
          , [LAST_VISTA_LOGIN]
          , [ACTIVE_FLAG]
          , [CREATED]
          , [CREATEDBY]
          , [UPDATED]
          , [UPDATEDBY]
          , [PENDING_FLAG]

    from deleted;
end
go

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[EMAIL_TEMPLATES_H]') AND type in (N'U'))
DROP TABLE [AHOBPR].[EMAIL_TEMPLATES_H]
GO
create 
  table [AHOBPR].[EMAIL_TEMPLATES_H]
        (
            [Audit_EMAIL_TEMPLATES_H_ID] [int] identity(1,1) not null
          , [Audit_Date] [datetime] not null
          , [Audit_Type] [varchar](20) not null
          , [Audit_ApplicationUser] [varchar](128)
          , [Audit_SQLUser] [varchar](100)
          , [TEMPLATE_ID] [int]
          , [TITLE] [varchar](255)
          , [SUBJECT] [varchar](255)
          , [BODY] [varchar](4000)
          , [ACTIVE] [bit]
          , [CREATEDBY] [varchar](30)
          , [UPDATEDBY] [varchar](30)
          , [CREATED] [datetime2]
          , [UPDATED] [datetime2]
          , [EMAIL] [bit]
          , [NOTIFICATION] [bit]
          , [SALUTATION] [varchar](255)
          , [CONTACT_INFO] [varchar](2000)
          , [ADVANCED_USER_FLAG] [bit]
          , [CREATEDBY_ADVANCED_USER_FLAG] [bit]
          , constraint [EMAIL_TEMPLATES_H_PK] primary key clustered 
                        ([Audit_EMAIL_TEMPLATES_H_ID] ASC)
                        with (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = on, ALLOW_PAGE_LOCKS = on) 
                        on [PRIMARY]
          ) on [PRIMARY]
go
create 
  trigger [AHOBPR].[TRG_EMAIL_TEMPLATES_H] on [AHOBPR].[EMAIL_TEMPLATES]
  after update, insert
as 
begin
  declare @lv_change varchar(15)
        , @cdeleted int
        , @cinserted int
        , @cSftDelete int;
  select @cdeleted =count(*) from deleted;
  select @cinserted =count(*) from inserted;
  insert 
    into  [AHOBPR].[EMAIL_TEMPLATES_H]
          ( [Audit_Date]
          , [Audit_Type]
          , [Audit_ApplicationUser]
          , [Audit_SQLUser] 
          , [TEMPLATE_ID]
          , [TITLE]
          , [SUBJECT]
          , [BODY]
          , [ACTIVE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
          , [EMAIL]
          , [NOTIFICATION]
          , [SALUTATION]
          , [CONTACT_INFO]
          , [ADVANCED_USER_FLAG]
          , [CREATEDBY_ADVANCED_USER_FLAG]
          )
  select getdate()
        , lv_Change= case 
                        when @cdeleted=0 and @cinserted>0 then 'insert'
                        when @cdeleted>0 and @cinserted>0 then 'update'
                        else null
                      end
        , HCB = case 
                  when @cdeleted=0 and @cinserted>0 then CreatedBy
                  when @cdeleted>0 and @cinserted>0 then UpdatedBy
                  else null
                end
        , suser_sname()
        , [TEMPLATE_ID]
        , [TITLE]
        , [SUBJECT]
        , [BODY]
        , [ACTIVE]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        , [EMAIL]
        , [NOTIFICATION]
        , [SALUTATION]
        , [CONTACT_INFO]
        , [ADVANCED_USER_FLAG]
        , [CREATEDBY_ADVANCED_USER_FLAG]

  from inserted
end
go
create 
  trigger  [AHOBPR].[TRG_EMAIL_TEMPLATES_DEL_H]
  on  [AHOBPR].[EMAIL_TEMPLATES] after delete
as
begin 
  declare @pos int, @vchar varchar(128)
  set @pos = 1
  set @vchar = cast(CONTEXT_INFO()as varchar(128))
  
  --Remove all 0x0 (keep only text)
  while not ascii(substring(@vchar,@pos,1))=0 
  begin
       set @pos = @pos + 1
  end
  
  set @vchar = SUBSTRING(@vchar, 1, @pos - 1)
  insert 
    into [AHOBPR].[EMAIL_TEMPLATES_H]
          ( [Audit_Date]
          , [Audit_Type]
          , [Audit_ApplicationUser]
          , [Audit_SQLUser] 
          , [TEMPLATE_ID]
          , [TITLE]
          , [SUBJECT]
          , [BODY]
          , [ACTIVE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
          , [EMAIL]
          , [NOTIFICATION]
          , [SALUTATION]
          , [CONTACT_INFO]
          , [ADVANCED_USER_FLAG]
          , [CREATEDBY_ADVANCED_USER_FLAG]
          )
     select getdate()
          , lv_Change=  'delete'
          , HCB= @vchar
          , suser_sname()
          , [TEMPLATE_ID]
          , [TITLE]
          , [SUBJECT]
          , [BODY]
          , [ACTIVE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
          , [EMAIL]
          , [NOTIFICATION]
          , [SALUTATION]
          , [CONTACT_INFO]
          , [ADVANCED_USER_FLAG]
          , [CREATEDBY_ADVANCED_USER_FLAG]

  from deleted
end;
go
print 'create table [AHOBPR].[FOLLOWUP_FORM_RESPONSE_H]';
go

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[FOLLOWUP_FORM_RESPONSE_H]') AND type in (N'U'))
DROP TABLE [AHOBPR].[FOLLOWUP_FORM_RESPONSE_H]
GO
create 
  table [AHOBPR].[FOLLOWUP_FORM_RESPONSE_H]
  (
    [Audit_FOLLOWUP_FORM_RESPONSE_H_ID] [int] identity(1,1) not null
  , [Audit_Date] [datetime] not null
  , [Audit_Type] [varchar](20) not null
  , [Audit_ApplicationUser] [varchar](128)
  , [Audit_SQLUser] [varchar](100)
  , [FOLLOWUP_FORM_RESPONSE_ID] [int]
  , [REGISTRANT_ID] [int]
  , [STD_FORM_ID] [int]
  , [COMPLETED_DATE] [datetime2]
  , [CREATEDBY] [varchar](30)
  , [UPDATEDBY] [varchar](30)
  , [CREATED] [datetime2]
  , [UPDATED] [datetime2]
  , constraint [FOLLOWUP_FORM_RESPONSE_H_PK] primary key clustered 
    ( [Audit_FOLLOWUP_FORM_RESPONSE_H_ID] ASC)
      with (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = on, ALLOW_PAGE_LOCKS = on) 
      on [PRIMARY]
    ) 
  on [PRIMARY]
go

create 
  trigger [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_H] on [AHOBPR].[FOLLOWUP_FORM_RESPONSE]
  after update, insert
as 
begin
  declare @lv_change varchar(15)
        , @cdeleted int
        , @cinserted int
        , @cSftDelete int;
  select @cdeleted =count(*) from deleted;
  select @cinserted =count(*) from inserted;
  insert 
    into [AHOBPR].[FOLLOWUP_FORM_RESPONSE_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [FOLLOWUP_FORM_RESPONSE_ID]
        , [REGISTRANT_ID]
        , [STD_FORM_ID]
        , [COMPLETED_DATE]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        )
    select getdate()
          , lv_Change= case 
                        when @cdeleted=0 and @cinserted>0 then 'insert'
                        when @cdeleted>0 and @cinserted>0 then 'update'
                        else null
                       end
          , HCB= case 
                    when @cdeleted=0 and @cinserted>0 then CreatedBy
                    when @cdeleted>0 and @cinserted>0 then UpdatedBy
                    else null
                  end
          , suser_sname()
          , [FOLLOWUP_FORM_RESPONSE_ID]
          , [REGISTRANT_ID]
          , [STD_FORM_ID]
          , [COMPLETED_DATE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

  from inserted;
end
go
create 
  trigger  [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_DEL_H]
  on  [AHOBPR].[FOLLOWUP_FORM_RESPONSE] after delete
as
begin 
  declare @pos int, @vchar varchar(128)
  set @pos = 1
  set @vchar = cast(CONTEXT_INFO()as varchar(128))
  
  --Remove all 0x0 (keep only text)
  while not ascii(substring(@vchar,@pos,1))=0 
  begin
       set @pos = @pos + 1
  end
  
  set @vchar = SUBSTRING(@vchar, 1, @pos - 1)
  insert 
    into [AHOBPR].[FOLLOWUP_FORM_RESPONSE_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [FOLLOWUP_FORM_RESPONSE_ID]
        , [REGISTRANT_ID]
        , [STD_FORM_ID]
        , [COMPLETED_DATE]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        )
    select  getdate()
          , lv_Change=  'delete'
          , HCB= @vchar
          , suser_sname()
          , [FOLLOWUP_FORM_RESPONSE_ID]
          , [REGISTRANT_ID]
          , [STD_FORM_ID]
          , [COMPLETED_DATE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

    from deleted;
end
go
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[FOLLOWUP_FORM_RESPONSE_ANSWER_H]') AND type in (N'U'))
DROP TABLE [AHOBPR].[FOLLOWUP_FORM_RESPONSE_ANSWER_H]
GO
create 
  table [AHOBPR].[FOLLOWUP_FORM_RESPONSE_ANSWER_H]
        (
          [Audit_FOLLOWUP_FORM_RESPONSE_ANSWER_H_ID] [int] identity(1,1) not null
          , [Audit_Date] [datetime] not null
          , [Audit_Type] [varchar](20) not null
          , [Audit_ApplicationUser] [varchar](128)
          , [Audit_SQLUser] [varchar](100)
          , [FOLLOWUP_FORM_RESPONSE_ANSWER_ID] [int]
          , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID] [int]
          , [STD_FORM_ANSWER_ID] [int]
          , [ANSWER_VALUE] [varchar](4000)
          , [CREATEDBY] [varchar](30)
          , [UPDATEDBY] [varchar](30)
          , [CREATED] [datetime2]
          , [UPDATED] [datetime2]
          , constraint [FOLLOWUP_FORM_RESPONSE_ANSWER_H_PK] 
              primary key clustered ([Audit_FOLLOWUP_FORM_RESPONSE_ANSWER_H_ID] ASC)
              with (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = on, ALLOW_PAGE_LOCKS = on) 
              on [PRIMARY]
          ) 
          on [PRIMARY]  
go
create 
  trigger [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_ANSWER_H] on [AHOBPR].[FOLLOWUP_FORM_RESPONSE_ANSWER]
  after update, insert
as 
begin
  declare @lv_change varchar(15)
        , @cdeleted int
        , @cinserted int
        , @cSftDelete int;
  select @cdeleted =count(*) from deleted;
  select @cinserted =count(*) from inserted;
  insert 
    into  [AHOBPR].[FOLLOWUP_FORM_RESPONSE_ANSWER_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [FOLLOWUP_FORM_RESPONSE_ANSWER_ID]
        , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID]
        , [STD_FORM_ANSWER_ID]
        , [ANSWER_VALUE]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        )
    select getdate()
          , lv_Change= case 
                        when @cdeleted=0 and @cinserted>0 then 'insert'
                        when @cdeleted>0 and @cinserted>0 then 'update'
                        else null
                       end
          , HCB= case 
                  when @cdeleted=0 and @cinserted>0 then CreatedBy
                  when @cdeleted>0 and @cinserted>0 then UpdatedBy
                  else null
                 end
          , suser_sname()
          , [FOLLOWUP_FORM_RESPONSE_ANSWER_ID]
          , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID]
          , [STD_FORM_ANSWER_ID]
          , [ANSWER_VALUE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

    from inserted;
end
go
create 
  trigger  [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_ANSWER_DEL_H]
  on  [AHOBPR].[FOLLOWUP_FORM_RESPONSE_ANSWER] 
  after delete
as
begin 
  declare @pos int, @vchar varchar(128)
  set @pos = 1
  set @vchar = cast(CONTEXT_INFO()as varchar(128))
  
  --Remove all 0x0 (keep only text)
  while not ascii(substring(@vchar,@pos,1))=0 
  begin
       set @pos = @pos + 1
  end
  
  set @vchar = SUBSTRING(@vchar, 1, @pos - 1)
  insert 
    into [AHOBPR].[FOLLOWUP_FORM_RESPONSE_ANSWER_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [FOLLOWUP_FORM_RESPONSE_ANSWER_ID]
        , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID]
        , [STD_FORM_ANSWER_ID]
        , [ANSWER_VALUE]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        )
    select getdate()
          , lv_Change=  'delete'
          , HCB= @vchar
          , suser_sname()
          , [FOLLOWUP_FORM_RESPONSE_ANSWER_ID]
          , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID]
          , [STD_FORM_ANSWER_ID]
          , [ANSWER_VALUE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

    from deleted;
end
go
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[FOLLOWUP_FORM_RESPONSE_QUESTION_H]') AND type in (N'U'))
DROP TABLE [AHOBPR].[FOLLOWUP_FORM_RESPONSE_QUESTION_H]
GO
create 
  table [AHOBPR].[FOLLOWUP_FORM_RESPONSE_QUESTION_H]
        (
          [Audit_FOLLOWUP_FORM_RESPONSE_QUESTION_H_ID] [int] identity(1,1) not null
          , [Audit_Date] [datetime] not null
          , [Audit_Type] [varchar](20) not null
          , [Audit_ApplicationUser] [varchar](128)
          , [Audit_SQLUser] [varchar](100)
          , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID] [int]
          , [FOLLOWUP_FORM_RESPONSE_ID] [int]
          , [STD_FORM_QUESTION_ID] [int]
          , [STARTED_DATE] [datetime2]
          , [COMPLETED_DATE] [datetime2]
          , [CREATEDBY] [varchar](30)
          , [UPDATEDBY] [varchar](30)
          , [CREATED] [datetime2]
          , [UPDATED] [datetime2]
          , constraint [FOLLOWUP_FORM_RESPONSE_QUESTION_H_PK] 
            primary key clustered ([Audit_FOLLOWUP_FORM_RESPONSE_QUESTION_H_ID] ASC)
            with (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = on, ALLOW_PAGE_LOCKS = on) 
            on [PRIMARY]
          ) 
    on    [PRIMARY];
go
create 
  trigger [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_QUESTION_H] on [AHOBPR].[FOLLOWUP_FORM_RESPONSE_QUESTION]
  after update, insert
as 
begin
    declare @lv_change varchar(15)
    , @cdeleted int
    , @cinserted int
    , @cSftDelete int
    select @cdeleted =count(*) from deleted
    select @cinserted =count(*) from inserted
    insert 
      into [AHOBPR].[FOLLOWUP_FORM_RESPONSE_QUESTION_H]
          ( [Audit_Date]
          , [Audit_Type]
          , [Audit_ApplicationUser]
          , [Audit_SQLUser] 
          , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID]
          , [FOLLOWUP_FORM_RESPONSE_ID]
          , [STD_FORM_QUESTION_ID]
          , [STARTED_DATE]
          , [COMPLETED_DATE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
          )
    select getdate()
          , lv_Change= case 
                        when @cdeleted=0 and @cinserted>0 then 'insert'
                        when @cdeleted>0 and @cinserted>0 then 'update'
                        else null
                       end
          , HCB= case 
                  when @cdeleted=0 and @cinserted>0 then CreatedBy
                  when @cdeleted>0 and @cinserted>0 then UpdatedBy
                  else null
                 end
          , suser_sname()
          , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID]
          , [FOLLOWUP_FORM_RESPONSE_ID]
          , [STD_FORM_QUESTION_ID]
          , [STARTED_DATE]
          , [COMPLETED_DATE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

    from inserted;
end
go
create 
  trigger  [AHOBPR].[TRG_FOLLOWUP_FORM_RESPONSE_QUESTION_DEL_H]
  on  [AHOBPR].[FOLLOWUP_FORM_RESPONSE_QUESTION] 
  after delete
as
begin 
  declare @pos int, @vchar varchar(128)
  set @pos = 1
  set @vchar = cast(CONTEXT_INFO()as varchar(128))
  
  --Remove all 0x0 (keep only text)
  while not ascii(substring(@vchar,@pos,1))=0 
  begin
    set @pos = @pos + 1
  end
  
  set @vchar = SUBSTRING(@vchar, 1, @pos - 1)
  insert 
    into [AHOBPR].[FOLLOWUP_FORM_RESPONSE_QUESTION_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID]
        , [FOLLOWUP_FORM_RESPONSE_ID]
        , [STD_FORM_QUESTION_ID]
        , [STARTED_DATE]
        , [COMPLETED_DATE]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        )
    select  getdate()
          , lv_Change=  'delete'
          , HCB= @vchar
          , suser_sname()
          , [FOLLOWUP_FORM_RESPONSE_QUESTION_ID]
          , [FOLLOWUP_FORM_RESPONSE_ID]
          , [STD_FORM_QUESTION_ID]
          , [STARTED_DATE]
          , [COMPLETED_DATE]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

from deleted;
end;
go
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[TOOL_ANSWER_H]') AND type in (N'U'))
DROP TABLE [AHOBPR].[TOOL_ANSWER_H]
GO
create 
  table [AHOBPR].[TOOL_ANSWER_H]
        (
          [Audit_TOOL_ANSWER_H_ID] [int] identity(1,1) not null
        , [Audit_Date] [datetime] not null
        , [Audit_Type] [varchar](20) not null
        , [Audit_ApplicationUser] [varchar](128)
        , [Audit_SQLUser] [varchar](100)
        , [TOOL_ANSWER_ID] [int]
        , [TOOL_QUESTION_ID] [int]
        , [ORDER] [int]
        , [TEXT] [varchar](4000)
        , [EDITABLE] [bit]
        , [HELP] [varchar](1000)
        , [CLINICAL_RELEVANT_FLAG] [bit]
        , [CREATEDBY] [varchar](30)
        , [UPDATEDBY] [varchar](30)
        , [CREATED] [datetime2]
        , [UPDATED] [datetime2]
        , [STANDARD_FLAG] [bit]
        , constraint [TOOL_ANSWER_H_PK] 
          primary key clustered ([Audit_TOOL_ANSWER_H_ID] ASC)
          with (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = on, ALLOW_PAGE_LOCKS = on) 
          on [PRIMARY]
        ) 
  on [PRIMARY];
go
create 
  trigger [AHOBPR].[TRG_TOOL_ANSWER_H] 
  on [AHOBPR].[TOOL_ANSWER]
  after update, insert
as 
begin
  declare @lv_change varchar(15)
        , @cdeleted int
        , @cinserted int
        , @cSftDelete int;
  select @cdeleted =count(*) from deleted;
  select @cinserted =count(*) from inserted;
  insert 
    into [AHOBPR].[TOOL_ANSWER_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [TOOL_ANSWER_ID]
        , [TOOL_QUESTION_ID]
        , [ORDER]
        , [TEXT]
        , [EDITABLE]
        , [HELP]
        , [CLINICAL_RELEVANT_FLAG]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        , [STANDARD_FLAG]
        )
    select  getdate()
          , lv_Change= case 
                        when @cdeleted=0 and @cinserted>0 then 'insert'
                        when @cdeleted>0 and @cinserted>0 then 'update'
                        else null
                       end
          , HCB= case 
                  when @cdeleted=0 and @cinserted>0 then CreatedBy
                  when @cdeleted>0 and @cinserted>0 then UpdatedBy
                  else null
                 end
          , suser_sname()
          , [TOOL_ANSWER_ID]
          , [TOOL_QUESTION_ID]
          , [ORDER]
          , [TEXT]
          , [EDITABLE]
          , [HELP]
          , [CLINICAL_RELEVANT_FLAG]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
          , [STANDARD_FLAG]

    from inserted;
end
go
create 
  trigger  [AHOBPR].[TRG_TOOL_ANSWER_DEL_H]
  on  [AHOBPR].[TOOL_ANSWER] 
  after delete
as
begin 
  declare @pos int, @vchar varchar(128)
  set @pos = 1
  set @vchar = cast(CONTEXT_INFO()as varchar(128))
  
  --Remove all 0x0 (keep only text)
  while not ascii(substring(@vchar,@pos,1))=0 
  begin
       set @pos = @pos + 1
  end
  
  set @vchar = SUBSTRING(@vchar, 1, @pos - 1)
  insert 
    into  [AHOBPR].[TOOL_ANSWER_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [TOOL_ANSWER_ID]
        , [TOOL_QUESTION_ID]
        , [ORDER]
        , [TEXT]
        , [EDITABLE]
        , [HELP]
        , [CLINICAL_RELEVANT_FLAG]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        , [STANDARD_FLAG]
        )
    select  getdate()
          , lv_Change=  'delete'
          , HCB= @vchar
          , suser_sname()
          , [TOOL_ANSWER_ID]
          , [TOOL_QUESTION_ID]
          , [ORDER]
          , [TEXT]
          , [EDITABLE]
          , [HELP]
          , [CLINICAL_RELEVANT_FLAG]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
          , [STANDARD_FLAG]
    from deleted;
end;
go

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[TOOL_FORM_H]') AND type in (N'U'))
DROP TABLE [AHOBPR].[TOOL_FORM_H]
GO
create 
  table [AHOBPR].[TOOL_FORM_H]
        (
          [Audit_TOOL_FORM_H_ID] [int] identity(1,1) not null
        , [Audit_Date] [datetime] not null
        , [Audit_Type] [varchar](20) not null
        , [Audit_ApplicationUser] [varchar](128)
        , [Audit_SQLUser] [varchar](100)
        , [TOOL_FORM_ID] [int]
        , [NAME] [varchar](256)
        , [TITLE] [varchar](500)
        , [ACTIVE_FLAG] [bit]
        , [EDITABLE_FLAG] [bit]
        , [CREATEDBY] [varchar](30)
        , [UPDATEDBY] [varchar](30)
        , [CREATED] [datetime2]
        , [UPDATED] [datetime2]
        , constraint [TOOL_FORM_H_PK] 
          primary key clustered (Audit_TOOL_FORM_H_ID ASC)
          with (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = on, ALLOW_PAGE_LOCKS = on) 
          on [PRIMARY]
        ) 
  on  [PRIMARY];
go
create 
  trigger [AHOBPR].[TRG_TOOL_FORM_H] 
  on [AHOBPR].[TOOL_FORM]
  after update, insert
as 
  begin
  declare @lv_change varchar(15)
        , @cdeleted int
        , @cinserted int
        , @cSftDelete int;
  select @cdeleted =count(*) from deleted;
  select @cinserted =count(*) from inserted;
  
  insert 
    into  [AHOBPR].[TOOL_FORM_H]
          ( [Audit_Date]
          , [Audit_Type]
          , [Audit_ApplicationUser]
          , [Audit_SQLUser] 
          , [TOOL_FORM_ID]
          , [NAME]
          , [TITLE]
          , [ACTIVE_FLAG]
          , [EDITABLE_FLAG]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
          )
    select  getdate()
          , lv_Change= case 
                        when @cdeleted=0 and @cinserted>0 then 'insert'
                        when @cdeleted>0 and @cinserted>0 then 'update'
                        else null
                       end
          , HCB = case 
                    when @cdeleted=0 and @cinserted>0 then CreatedBy
                    when @cdeleted>0 and @cinserted>0 then UpdatedBy
                    else null
                   end
          , suser_sname()
          , [TOOL_FORM_ID]
          , [NAME]
          , [TITLE]
          , [ACTIVE_FLAG]
          , [EDITABLE_FLAG]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
from inserted;
end
go
create 
  trigger  [AHOBPR].[TRG_TOOL_FORM_DEL_H]
  on  [AHOBPR].[TOOL_FORM] 
  after delete
as
begin 
  declare @pos int, @vchar varchar(128)
  set @pos = 1
  set @vchar = cast(CONTEXT_INFO()as varchar(128))
  
  --Remove all 0x0 (keep only text)
  while not ascii(substring(@vchar,@pos,1))=0 
  begin
       set @pos = @pos + 1
  end
  
  set @vchar = SUBSTRING(@vchar, 1, @pos - 1)
  insert 
    into  [AHOBPR].[TOOL_FORM_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [TOOL_FORM_ID]
        , [NAME]
        , [TITLE]
        , [ACTIVE_FLAG]
        , [EDITABLE_FLAG]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        )
    select  getdate()
          , lv_Change=  'delete'
          , HCB= @vchar
          , suser_sname()
          , [TOOL_FORM_ID]
          , [NAME]
          , [TITLE]
          , [ACTIVE_FLAG]
          , [EDITABLE_FLAG]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

    from deleted;
end
go
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[TOOL_FORM_QUESTION_H]') AND type in (N'U'))
DROP TABLE [AHOBPR].[TOOL_FORM_QUESTION_H]
GO
create 
  table [AHOBPR].[TOOL_FORM_QUESTION_H]
        (
          [Audit_TOOL_FORM_QUESTION_H_ID] [int] identity(1,1) not null
        , [Audit_Date] [datetime] not null
        , [Audit_Type] [varchar](20) not null
        , [Audit_ApplicationUser] [varchar](128)
        , [Audit_SQLUser] [varchar](100)
        , [TOOL_FORM_QUESTION_ID] [int]
        , [TOOL_FORM_ID] [int]
        , [TOOL_QUESTION_ID] [int]
        , [CREATEDBY] [varchar](30)
        , [UPDATEDBY] [varchar](30)
        , [CREATED] [datetime2]
        , [UPDATED] [datetime2]
        , constraint [TOOL_FORM_QUESTION_H_PK] 
          primary key clustered ([Audit_TOOL_FORM_QUESTION_H_ID] ASC)
          with (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = on, ALLOW_PAGE_LOCKS = on) 
          on [PRIMARY]
        ) 
  on [PRIMARY];
go
create 
  trigger [AHOBPR].[TRG_TOOL_FORM_QUESTION_H] on [AHOBPR].[TOOL_FORM_QUESTION]
  after update, insert
as 
begin
  declare @lv_change varchar(15)
        , @cdeleted int
        , @cinserted int
        , @cSftDelete int
  select @cdeleted =count(*) from deleted;
  select @cinserted =count(*) from inserted;
  insert 
    into [AHOBPR].[TOOL_FORM_QUESTION_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [TOOL_FORM_QUESTION_ID]
        , [TOOL_FORM_ID]
        , [TOOL_QUESTION_ID]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        )
    select  getdate()
          , lv_Change = case 
                          when @cdeleted=0 and @cinserted>0 then 'insert'
                          when @cdeleted>0 and @cinserted>0 then 'update'
                          else null
                        end
          , HCB = case 
                    when @cdeleted=0 and @cinserted>0 then CreatedBy
                    when @cdeleted>0 and @cinserted>0 then UpdatedBy
                    else null
                  end
          , suser_sname()
          , [TOOL_FORM_QUESTION_ID]
          , [TOOL_FORM_ID]
          , [TOOL_QUESTION_ID]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

    from inserted;
end
go
create 
  trigger  [AHOBPR].[TRG_TOOL_FORM_QUESTION_DEL_H]
  on  [AHOBPR].[TOOL_FORM_QUESTION] 
  after delete
as
begin 
  declare @pos int, @vchar varchar(128)
  set @pos = 1
  set @vchar = cast(CONTEXT_INFO()as varchar(128))
  
  --Remove all 0x0 (keep only text)
  while not ascii(substring(@vchar,@pos,1))=0 
  begin
       set @pos = @pos + 1
  end
  
  set @vchar = SUBSTRING(@vchar, 1, @pos - 1)
  insert 
    into [AHOBPR].[TOOL_FORM_QUESTION_H]
        ( [Audit_Date]
        , [Audit_Type]
        , [Audit_ApplicationUser]
        , [Audit_SQLUser] 
        , [TOOL_FORM_QUESTION_ID]
        , [TOOL_FORM_ID]
        , [TOOL_QUESTION_ID]
        , [CREATEDBY]
        , [UPDATEDBY]
        , [CREATED]
        , [UPDATED]
        )
    select  getdate()
          , lv_Change=  'delete'
          , HCB= @vchar
          , suser_sname()
          , [TOOL_FORM_QUESTION_ID]
          , [TOOL_FORM_ID]
          , [TOOL_QUESTION_ID]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
  from deleted;
end
go
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[TOOL_QUESTION_H]') AND type in (N'U'))
DROP TABLE [AHOBPR].[TOOL_QUESTION_H]
GO
create 
  table [AHOBPR].[TOOL_QUESTION_H]
        (
          [Audit_TOOL_QUESTION_H_ID] [int] identity(1,1) not null
        , [Audit_Date] [datetime] not null
        , [Audit_Type] [varchar](20) not null
        , [Audit_ApplicationUser] [varchar](128)
        , [Audit_SQLUser] [varchar](100)
        , [TOOL_QUESTION_ID] [int]
        , [TEXT] [varchar](4000)
        , [TYPE] [varchar](100)
        , [MIN] [varchar](256)
        , [MAX] [varchar](256)
        , [MAX_CHOICES] [int]
        , [MAX_LENGTH] [int]
        , [MIN_LENGTH] [int]
        , [KEY_WORDS] [varchar](2000)
        , [ACTIVE_FLAG] [bit]
        , [EDITABLE_FLAG] [bit]
        , [SOURCE_ID] [varchar](100)
        , [CREATEDBY] [varchar](30)
        , [UPDATEDBY] [varchar](30)
        , [CREATED] [datetime2]
        , [UPDATED] [datetime2]
        , constraint [TOOL_QUESTION_H_PK] 
          primary key clustered ([Audit_TOOL_QUESTION_H_ID] ASC)
          with (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = on, ALLOW_PAGE_LOCKS = on) 
          on [PRIMARY]
        ) 
  on [PRIMARY];
go
create 
  trigger [AHOBPR].[TRG_TOOL_QUESTION_H] 
  on [AHOBPR].[TOOL_QUESTION]
  after update, insert
as 
begin
  declare @lv_change varchar(15)
        , @cdeleted int
        , @cinserted int
        , @cSftDelete int
  select @cdeleted =count(*) from deleted;
  select @cinserted =count(*) from inserted;
  
  insert 
    into [AHOBPR].[TOOL_QUESTION_H]
          ( [Audit_Date]
          , [Audit_Type]
          , [Audit_ApplicationUser]
          , [Audit_SQLUser] 
          , [TOOL_QUESTION_ID]
          , [TEXT]
          , [TYPE]
          , [MIN]
          , [MAX]
          , [MAX_CHOICES]
          , [MAX_LENGTH]
          , [MIN_LENGTH]
          , [KEY_WORDS]
          , [ACTIVE_FLAG]
          , [EDITABLE_FLAG]
          , [SOURCE_ID]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
          )
    select  getdate()
          , lv_Change=  case 
                          when @cdeleted=0 and @cinserted>0 then 'insert'
                          when @cdeleted>0 and @cinserted>0 then 'update'
                          else null
                        end
          , HCB = case 
                    when @cdeleted=0 and @cinserted>0 then CreatedBy
                    when @cdeleted>0 and @cinserted>0 then UpdatedBy
                    else null
                  end
          , suser_sname()
          , [TOOL_QUESTION_ID]
          , [TEXT]
          , [TYPE]
          , [MIN]
          , [MAX]
          , [MAX_CHOICES]
          , [MAX_LENGTH]
          , [MIN_LENGTH]
          , [KEY_WORDS]
          , [ACTIVE_FLAG]
          , [EDITABLE_FLAG]
          , [SOURCE_ID]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

   from inserted;
end
go
create 
  trigger  [AHOBPR].[TRG_TOOL_QUESTION_DEL_H]
  on  [AHOBPR].[TOOL_QUESTION] 
  after delete
as
begin 
  declare @pos int, @vchar varchar(128)
  set @pos = 1
  set @vchar = cast(CONTEXT_INFO()as varchar(128))
  
  --Remove all 0x0 (keep only text)
  while not ascii(substring(@vchar,@pos,1))=0 
  begin
       set @pos = @pos + 1
  end
  
  set @vchar = SUBSTRING(@vchar, 1, @pos - 1)
  insert 
    into  [AHOBPR].[TOOL_QUESTION_H]
          ( [Audit_Date]
          , [Audit_Type]
          , [Audit_ApplicationUser]
          , [Audit_SQLUser] 
          , [TOOL_QUESTION_ID]
          , [TEXT]
          , [TYPE]
          , [MIN]
          , [MAX]
          , [MAX_CHOICES]
          , [MAX_LENGTH]
          , [MIN_LENGTH]
          , [KEY_WORDS]
          , [ACTIVE_FLAG]
          , [EDITABLE_FLAG]
          , [SOURCE_ID]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]
          )
    select  getdate()
          , lv_Change=  'delete'
          , HCB= @vchar
          , suser_sname()
          , [TOOL_QUESTION_ID]
          , [TEXT]
          , [TYPE]
          , [MIN]
          , [MAX]
          , [MAX_CHOICES]
          , [MAX_LENGTH]
          , [MIN_LENGTH]
          , [KEY_WORDS]
          , [ACTIVE_FLAG]
          , [EDITABLE_FLAG]
          , [SOURCE_ID]
          , [CREATEDBY]
          , [UPDATEDBY]
          , [CREATED]
          , [UPDATED]

    from deleted;
end
go


---------------------------------------------------------------------------------------------------------
print N'Update complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


go
update  [dbo].[DatabaseChangeLog]
  set   ScriptDescription = 'Script Completed Successfully.'
  where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    and [PointReleaseNumber]  = '$(PointReleaseNumber)'
    and [ScriptName]          = '$(ScriptName)'
    and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)'
  and [ScriptName] = '$(ScriptName)';
go
-------------------------------------------------------------
-------------------------------------------------------------
-- 2.0.23.1
-------------------------------------------------------------  
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "23"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.23.1.sql"

print ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
set nocount off;
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    begin
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
go
if EXISTS ( select * from [dbo].[DatabaseChangeLog]
            where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
              and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
              and [PointReleaseNumber] = '$(PointReleaseNumber)'
              and [ScriptName]         = '$(ScriptName)'
          )
begin
   raiserror('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
end
else
  insert 
    into [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       values
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE()
            );

go
---------------------------------------------------------------------------------------------------------
print 'Script started...';
print GETDATE();
go
---------------------------------------------------------------------------------------------------------
  update [AHOBPR].[STD_REGISTRY_FLAG_TYPE]
  set REGISTRY_FLAG_TYPE = replace(REGISTRY_FLAG_TYPE, 'SubPopulation', 'Subpopulation'),
	  REGISTRY_FLAG_TYPE_DESCRIPTION = replace(REGISTRY_FLAG_TYPE_DESCRIPTION, 'SubPopulation', 'Subpopulation');
---------------------------------------------------------------------------------------------------------
print N'Update complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


go
update  [dbo].[DatabaseChangeLog]
  set   ScriptDescription = 'Script Completed Successfully.'
  where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    and [PointReleaseNumber]  = '$(PointReleaseNumber)'
    and [ScriptName]          = '$(ScriptName)'
    and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)'
  and [ScriptName] = '$(ScriptName)';
go
-------------------------------------------------
-------------------------------------------------
-- 2.0.24.1
-------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "24"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.24.1.sql"


print ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
set nocount off;
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    begin
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
go
if EXISTS ( select * from [dbo].[DatabaseChangeLog]
            where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
              and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
              and [PointReleaseNumber] = '$(PointReleaseNumber)'
              and [ScriptName]         = '$(ScriptName)'
          )
begin
   raiserror('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
end
else
  insert 
    into [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       values
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE()
            );

go
---------------------------------------------------------------------------------------------------------
print 'Script started...';
print GETDATE();
go
---------------------------------------------------------------------------------------------------------
if exists (select * from sys.views where name='view_lookup'
           and schema_id = (select schema_id from sys.schemas where name = 'ahobpr')
          )
begin
  if exists (select * from sys.views where name='view_lookup_pre2_0_24_1'
           and schema_id = (select schema_id from sys.schemas where name = 'ahobpr')
          )
    drop view AHOBPR.VIEW_LOOKUP
  else
    exec sp_rename 'AHOBPR.VIEW_LOOKUP', 'view_lookup_pre2_0_24_1';
end;
go
--last updated in 2.0.24.1 script
CREATE VIEW [AHOBPR].[VIEW_LOOKUP] 
WITH SCHEMABINDING 
AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
		OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME = 'Eligibility Review - More Documentation Needed'))--2.0.13.1 changed this line
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_FAMILY
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DISCHARGE_CHARACTER
UNION ALL
SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 0
  AND TITLE NOT IN ('Eligible for Burn Pit Registry', 'Not Eligible for Burn Pit Registry', 'New Follow-up Questions', 'Need More Documentation') 
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Multiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
UNION ALL
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Multiple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
	   ,STD_FORM_ID AS ID
       ,NAME AS CODE
       ,NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM
  WHERE FOLLOWUP_FLAG = 1
UNION ALL
SELECT DISTINCT 'CONTACT_PREFERENCE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[CONTACT_PREFERENCE] AS CODE
       ,[CONTACT_PREFERENCE] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
  WHERE CONTACT_PREFERENCE > ''
UNION ALL
SELECT 'MY_TEMPLATES_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,CREATEDBY AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 1
UNION ALL
SELECT DISTINCT 'ENROLLMENT_STATUS' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[ENROLLMENT_STATUS] AS CODE
       ,[ENROLLMENT_STATUS] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
   WHERE ENROLLMENT_STATUS > '';

-- select * from  [AHOBPR].[VIEW_LOOKUP]

GO
SET NOCOUNT ON;

DECLARE  @RegistryId int = (SELECT ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR');
DECLARE  @Today Datetime = GETDATE();

select * into ahobpr.std_gui_controls_pre2_0_24_1 from [dbo].[STD_GUI_CONTROLS] where [STD_REGISTRY_ID] = @RegistryId;

DELETE FROM [dbo].[STD_GUI_CONTROLS] WHERE [STD_REGISTRY_ID] = @RegistryId;

INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_SEARCH', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name', '1', @Today, @Today, 'DBA', 'DBA', NULL, '100', NULL, 'False', 'True', 'Last Name:<br />', NULL, NULL, NULL, '50', 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_SEARCH', 'Last Four Digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant Last Four Digists of SSN', '2', @Today, @Today, 'DBA', 'DBA', NULL, '50', NULL, 'False', 'True', 'Last Four Digits of SSN:<br />', NULL, NULL, NULL, '4', 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_SEARCH', 'Registry Status', '4', 'BaseControlDropdownListRegistryStatus', NULL, NULL, 'Registrant Registry Status', '4', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', NULL, NULL, 'False', 'True', 'Registry Status:<br />', NULL, NULL, NULL, NULL, 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_SEARCH', 'Registry Flags', '4', 'BaseControlDropdownListRegistryFlag', NULL, NULL, 'Registrant Registry Flags', '5', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_FLAG', NULL, NULL, 'False', 'True', 'Registry Flags:<br />', NULL, NULL, NULL, NULL, 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_STATUSBYLOCATION', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_STATUSBYLOCATION', 'Report Sate Parameters', '5', 'BaseControlListBoxState', NULL, NULL, 'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_STATE', '170', '170', 'False', 'True', 'State:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Full Name', '1', 'BaseControlLabelName', NULL, NULL, 'Registrant Full Name', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Name: &nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Date of Birth', '1', 'BaseControlLabelDob', NULL, NULL, 'Registrant Date of Birth', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Date of Birth (mm/dd/yyyy):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Gender', '1', 'BaseControlLabelGender', NULL, NULL, 'Registrant Gender', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Gender:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Duty Status', '1', 'BaseControlLabelDutyStatus', NULL, NULL, 'Registrant Duty Status', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Duty Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Last 4 SSN', '1', 'BaseControlLabelLast4ssn', NULL, NULL, 'Registrant Last 4 Digists of SSN', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Last 4 SSN:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Edipi', '1', 'BaseControlLabelEdipi', NULL, NULL, 'Registrant Edipi', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'EDIPI:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Status', '1', 'BaseControlLabelRegistryStatus', NULL, NULL, 'Registrant Status', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Email', '1', 'BaseControlLabelEmail', NULL, NULL, 'Registrant Email', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Email:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Phone', '1', 'BaseControlLabelPhone', NULL, NULL, 'Registrant Phone', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Phone:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Questionnaire Completion Date', '1', 'BaseControlLabelQuestionnaireCompletionDate', NULL, NULL, 'Registrant Questionnaire Completion Date', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Questionnaire Completion Date:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Registrant Address', '1', 'BaseControlLabelAddress', NULL, NULL, 'Registrant Address', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Address:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Report Health Concerns', '1', 'BaseControlLabelHealthConcern', NULL, NULL, 'Report Health Concerns?', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Report Health Concerns?&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Request to be Seen', '1', 'BaseControlLabelRequestToBeSeen', NULL, NULL, 'Request to be Seen?', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Request to be Seen?&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Subpopulation Flags', '1', 'BaseControlLabelSubpopulationFlags', NULL, NULL, 'Subpopulation Flags for a Registrant', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Subpopulation Flags:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_USER_CONTROL', 'Last Admin Flag Set', '1', 'BaseControlLabelLastOutreach', NULL, NULL, 'Last Admin Flag Set for a Registrant', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Last Admin Flag Set:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Duty Status', '5', 'BaseControlListBoxDutyStatus', NULL, NULL, 'Duty Status is the military standing of the registrant: Veteran, Retiree, or Active Duty. The Selection Criteria allows the user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_SERVICE_STATUS', NULL, NULL, 'False', 'True', 'Duty Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Question Number', '4', 'BaseControlDropdownListQuestions', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_FORM_QUESTION', NULL, NULL, 'False', 'True', 'Questions:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Question Response', '4', 'BaseControlDropdownListQuestionReponse', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '150', '150', 'False', 'True', 'Answers:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Radio Button Health Concersn', '3', 'BaseControlRadioButtonListHealthConcerns', NULL, NULL, 'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CHANGE_STATUS_REGISTRANT_SEARCH', 'Change Status Registrant Search Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Registrant Registry Status', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS_INELIGIBLE', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CHANGE_STATUS', 'Change Status for a Registrant', '3', 'BaseControlRadioButtonListStatus', NULL, NULL, 'Registrant Registry Status', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS_REVIEWED', NULL, NULL, 'False', 'True', 'Change Status To:&nbsp&nbsp&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelChangeStatus')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Answer', '5', 'BaseControlListBoxAnswer', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '200', '200', 'False', 'True', 'Answer:<br />', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Search Criteria Name', '2', 'BaseControlTextBoxSearchCriteriaName', 'Search Criteria Name is required.', NULL, 'Search Criteria Name', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'True', 'True', 'Search Criteria Name: ', NULL, NULL, 'OnSaveSearchCriteria', '256', 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with Registrant status=Participant', '1', 'BaseControlLabelParticipantStatus', NULL, NULL, 'Number of respondents with Registrant status=Participant', '1', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with Registrant status=Participant', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with reported health concerns', '1', 'BaseControlLabelHealthConcern', NULL, NULL, 'Number of respondents with reported health concerns', '2', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with reported health concerns', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with no reported health concerns', '1', 'BaseControlLabelNoHealthConcern', NULL, NULL, 'Number of respondents with no reported health concerns', '3', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with no reported health concerns', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with beneficiary status=Current Veteran', '1', 'BaseControlLabelVeteran', NULL, NULL, 'Number of respondents with beneficiary status=Current Veteran', '4', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with beneficiary status=Current Veteran', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with beneficiary status=Active Duty', '1', 'BaseControlLabelActiveDuty', NULL, NULL, 'Number of respondents with beneficiary status=Active Duty', '5', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with beneficiary status=Active Duty', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents with beneficiary status=Retiree', '1', 'BaseControlLabelRetiree', NULL, NULL, 'Number of respondents with beneficiary status=Retiree', '6', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents with beneficiary status=Retiree', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Iraq on or after Sept 11, 2001', '1', 'BaseControlLabelIrapAfter911', NULL, NULL, 'Number of respondents Deployed to Iraq on or after Sept 11, 2001', '7', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Iraq on or after Sept 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Afghanistan on or after Sept 11, 2001', '1', 'BaseControlLabelAfghanistanAfter911', NULL, NULL, 'Number of respondents Deployed to Afghanistan on or after Sept 11, 2001', '8', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Afghanistan on or after Sept 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Southwest Asia theater of operations after August 2nd, 1990 and prior to September 11, 2001', '1', 'BaseControlLabelAsiaBefore911', NULL, NULL, 'Number of respondents Deployed to Southwest Asia theater of operations after August 2nd, 1990 and prior to September 11, 2001', '9', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Southwest Asia theater of operations after August 2nd, 1990 and prior to September 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Southwest Asia (w/o Iraq) on or after Sept 11, 2001', '1', 'BaseControlLabelSouthwestAsiaAfter911', NULL, NULL, 'Number of respondents Deployed to Southwest Asia (w/o Iraq) on or after Sept 11, 2001', '10', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Southwest Asia (w/o Iraq) on or after Sept 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents that wish to discuss health concerns (Answer to Q7.B=Yes)', '1', 'BaseControlLabelDiscussHealthConcern', NULL, NULL, 'Number of respondents that wish to discuss health concerns (Answer to Q7.B=Yes)', '11', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents that wish to discuss health concerns (Answer to Q7.B=Yes)', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents that do not wish to discuss health concerns (Answer to Q7.B=No)', '1', 'BaseControlLabelNoDiscussHealthConcern', NULL, NULL, 'Number of respondents that do not wish to discuss health concerns (Answer to Q7.B=No)', '12', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents that do not wish to discuss health concerns (Answer to Q7.B=No)', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents that dont know if they wish to discuss health concerns (Answer to Q7.B=Dont know)', '1', 'BaseControlLabelUnknownDiscussHealthConcern', NULL, NULL, 'Number of respondents that dont know if they wish to discuss health concerns (Answer to Q7.B=Dont know)', '13', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents that dont know if they wish to discuss health concerns (Answer to Q7.B=Dont know)', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Median number of days from change of Registrant Record status=Eligible to Registrant Record status=Participant', '1', 'BaseControlLabelMedianTimeCompleteForm', NULL, NULL, 'Median number of days from change of Registrant Record status=Eligible to Registrant Record status=Participant', '14', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Median number of days from change of Registrant Record status=Eligible to Registrant Record status=Participant', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFORMATION', 'Report Duty Status', '5', 'BaseControlListBoxDutyStatus', NULL, NULL, 'Duty Status is the military standing of the registrant: Veteran, Retiree, or Active Duty. The Selection Criteria allows the user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_SERVICE_STATUS', NULL, NULL, 'False', 'True', 'Duty Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFORMATION', 'Report  Registrant Status', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFORMATION', 'Report Subpopulation Flag', '4', 'BaseControlDropDownListSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', @Today, @Today, 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', NULL, NULL, 'False', 'True', 'Subpopulation Flag:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Subpopulation Flag', '4', 'BaseControlDropDownListSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', @Today, @Today, 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', NULL, NULL, 'False', 'True', 'Subpopulation Flag:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Health Factor', '5', 'BaseControlListBoxHealthFactor', NULL, NULL, 'Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation.  This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation.  The Selection Criteria allows the user to filter with one or more health factors.', '0', @Today, @Today, 'DBA', 'DBA', 'HEALTH_FACTOR', '350', '350', 'False', 'True', 'Health Factor:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Deployment Country All', '4', 'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments.  ', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY', NULL, NULL, 'False', 'True', 'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Deployment Country With Exposure Response', '4', 'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 'False', 'True', 'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ELIGIBILITY_REVIEW', 'Report  Registrant Status', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CHANGE_STATUS_REGISTRANT_SEARCH', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name', '1', @Today, @Today, 'DBA', 'DBA', NULL, '100', NULL, 'False', 'True', 'Last Name:<br />', NULL, NULL, NULL, '50', 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CHANGE_STATUS_REGISTRANT_SEARCH', 'Last Four Digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant Last Four Digists of SSN', '2', @Today, @Today, 'DBA', 'DBA', NULL, '50', NULL, 'False', 'True', 'Last Four Digits of SSN:<br />', NULL, NULL, NULL, '4', 'PanelSearchCriteria')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_PARTICIPATION', 'Number of respondents Deployed to Djibouti on or after Sept 11, 2001', '1', 'BaseControlLabelDjiboutiAfter911', NULL, NULL, 'Number of respondents Deployed to Djibouti on or after Sept 11, 2001', '15', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Number of respondents Deployed to Djibouti on or after Sept 11, 2001', NULL, NULL, NULL, NULL, 'PanelParticipation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_HEALTH_FACTOR', 'Reported History of Asthma as Recorded by the Provider', '1', 'BaseControlLabelAsthma', NULL, NULL, 'Reported History of Asthma as Recorded by the Provider', '1', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Reported History of Asthma as Recorded by the Provider', NULL, NULL, NULL, NULL, 'PanelHealthFactor')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_HEALTH_FACTOR', 'Reported Initiation or Increase in Tobacco Smoking During Deployment', '1', 'BaseControlLabelSmokingDeployment', NULL, NULL, 'Reported Initiation or Increase in Tobacco Smoking During Deployment', '2', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Reported Initiation or Increase in Tobacco Smoking During Deployment', NULL, NULL, NULL, NULL, 'PanelHealthFactor')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_HEALTH_FACTOR', 'Reported Tobacco Smoking History', '1', 'BaseControlLabelTobacco', NULL, NULL, 'Reported Tobacco Smoking History', '3', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Reported Tobacco Smoking History', NULL, NULL, NULL, NULL, 'PanelHealthFactor')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_HEALTH_FACTOR', 'Presence of Birth Defects in Children', '1', 'BaseControlLabelBirthDefects', NULL, NULL, 'Presence of Birth Defects in Children', '4', @Today, @Today, 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Presence of Birth Defects in Children', NULL, NULL, NULL, NULL, 'PanelHealthFactor')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Full Name', '1', 'BaseControlTextboxFullName', 'Full Name is required.', NULL, 'Full Name', '0', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Full Name:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'First Name', '1', 'BaseControlTextboxFirstName', 'First Name is required.', NULL, 'First Name', '1', '2015-05-07 00:00:00.000', '2015-05-07 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'First Name:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Middle Name', '1', 'BaseControlTextBoxMiddleName', NULL, NULL, 'Middle Name', '2', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Middle Name:', NULL, NULL, NULL, NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Last Name', '1', 'BaseControlTextBoxLastName', 'Last Name is required.', NULL, 'Last Name', '3', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Last Name:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Maiden Name', '1', 'BaseControlTextBoxMaidenName', NULL, NULL, 'Maiden Name', '4', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Maiden Name:', NULL, NULL, NULL, NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Employee Number', '1', 'BaseControlTextBoxEmployeeNumber', NULL, NULL, 'Employee Number', '5', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Employee Number:', NULL, NULL, NULL, NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Job Title', '1', 'BaseControlTextBoxJobTitle', 'Job Title is required.', NULL, 'Job Title', '6', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Job Title:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Email Address', '1', 'BaseControlTextBoxEmail', 'Email Address is required.', NULL, 'Email Address', '7', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Email Address:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Phone Number', '1', 'BaseControlTextBoxTelephone', 'Telephone Number is required.', NULL, 'Telephone Number', '8', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'True', 'False', 'Telephone Number:', NULL, NULL, 'alpha', NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_CREATE_ACCOUNT', 'Fax', '1', 'BaseControlTextBoxFax', NULL, NULL, 'Fax Number', '9', '2015-05-05 00:00:00.000', '2015-05-05 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Fax Number:', NULL, NULL, NULL, NULL, 'entryPanel')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Race', '1', 'BaseControlLabelRace', NULL, NULL, 'Registrant''s Race', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Race:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantInformation')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Ethnicity', '1', 'BaseControlLabelEthnicity', NULL, NULL, 'Ethnicity', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Ethnicity:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Marital Status', '1', 'BaseControlLabelMaritalStatus', NULL, NULL, 'MaritalSttus', '0', '2015-05-19 13:22:24.530', '2015-05-09 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Marital Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'VitalStatus', '1', 'BaseControlLabelVitalStatus', NULL, NULL, 'Vital Status', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Vital Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Education Level', '1', 'BaseControlLabelEducationLevel', NULL, NULL, 'Eduaction Level', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Education Level:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Current Branch of Service', '1', 'BaseControlLabelCurrentBranchOfSvc', NULL, NULL, 'Current Branch of Service', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Current Branch Of Service:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Branch of Service at First Login', '1', 'BaseControlLabelBranchSvcFirstLogin', NULL, NULL, 'Branch of Service at First Login', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Branch of Service at First Login:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Current Component', '1', 'BaseControlLabelCurrentComponent', NULL, NULL, 'Current Component', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Current Component:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Component at FirstLogin', '1', 'BaseControlLabelComponentFirstLogin', NULL, NULL, 'Component at First Login', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Component at First Login:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Most recent Separation Type', '1', 'BaseControlLabelMostRecentSepType', NULL, NULL, 'Most recent Separation Type', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Most recent Separation Type:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelSeparationInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Separation Type at First Login', '1', 'BaseControlLabelSepTypeFirstLogin', NULL, NULL, 'Separation Type at First Login', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Separation Type at First Login:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelSeparationInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Most recent Separation Date', '1', 'BaseControlLabelMostRecentSepDate', NULL, NULL, 'Most recent Separation Date', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Most recent Separation Date:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelSeparationInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Separation Date at First Login', '1', 'BaseControlLabelSepDateFirstLogin', NULL, NULL, 'Separation Date at First Login', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Separation Date at First Login:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelSeparationInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Contact Preference', '1', 'BaseControlLabelContactPreferance', NULL, NULL, 'Contact Preference', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Contact Preference:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Phone', '1', 'BaseControlLabelPhone', NULL, NULL, 'Phone', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Phone:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Mobile', '1', 'BaseControlLabelMobile', NULL, NULL, 'Mobile', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Mobile:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Email', '1', 'BaseControlLabelEmail', NULL, NULL, 'Email', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Email:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Address', '1', 'BaseControlLabelAddress', NULL, NULL, 'Address', '0', '2015-05-19 13:22:24.530', '2015-05-19 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'False', 'Address:&nbsp&nbsp ', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFORMATION', 'Report Parmater State', '5', 'BaseControlListBoxState', NULL, NULL, 'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', '0', '2015-05-26 12:00:00.000', '2015-05-26 12:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_STATE', '170', '170', 'False', 'True', 'State:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Race', '4', 'BaseControlDropDownListRace', NULL, NULL, 'Race is the hereditary group to which the registrant identifies with. The Selection Criteria allows the user to filter by one Race.', '0', '2015-06-03 13:22:24.530', '2015-06-03 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_RACE', NULL, NULL, 'False', 'True', 'Race:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Gender', '4', 'BaseControlDropDownListGender', NULL, NULL, 'Gender is the sex of the registrant. The Selection Criteria allows the user to filter by one Gender.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_GENDER', NULL, NULL, 'False', 'True', 'Gender:  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Separation Type', '4', 'BaseControlDropDownListSeparationType', NULL, NULL, 'Separation Type is reason for the Registrants most recent separation.  The Selection Criteria allows the user to filter by one Separation Type.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_SEPARATIONREASON', NULL, NULL, 'False', 'True', 'Separation Type:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Ethnicity', '4', 'BaseControlDropDownListEthnicity', NULL, NULL, 'Ethnicity is the ethnic affiliation of the Registrant. The Selection Criteria allows the user to filter by one Ethnicity.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ETHNICITY', NULL, NULL, 'False', 'True', 'Ethnicity:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', 'Report Enrollment Status', '4', 'BaseControlDropDownListEnrollmentStatus', NULL, NULL, 'Health Care Enrollment Status is the Registrants status in VA Care. The Selection Criteria allows the user to filter by one Health Care Enrollment Status.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'ENROLLMENT_STATUS', NULL, NULL, 'False', 'True', ' Health Care (VA Care) Enrollment Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Duty Status', '1', 'BaseControlLabelDutyStatus', NULL, NULL, NULL, '0', '2015-06-04 00:00:00.000', '2015-06-17 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Current Duty Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Duty Status at First Login', '1', 'BaseControlLabelDutyStatusFirstLogin', NULL, NULL, NULL, '0', '2015-06-18 00:00:00.000', '2015-06-18 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Duty Status At First Login:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelRegistrantDemographics')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REGISTRANT_INFORMATION_USER_CONTROL', 'Report Character of Service', '1', 'BaseControlLabelCharOfService', NULL, NULL, NULL, '0', '2015-06-25 00:00:00.000', '2015-06-25 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_CHARACTEROFSERVICE', NULL, NULL, 'False', 'True', 'Character of Service:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelCurrentContactInfo')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Question Text', 2, N'BaseControlTextboxQuestionText', N'Question Text is required.', NULL, N'Question Text', 1, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, 300, 1, 0, N'Question Text: **&nbsp&nbsp', NULL, NULL, N'SaveQuestion', 4000, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Question Type', 7, N'BaseControlRadioButtonListTextValueQuestionType', N'Question Type is required.', NULL, N'Question Type', 2, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', N'TOOL_QUESTION_TYPE', NULL, NULL, 1, 0, N'Question Type: **&nbsp', NULL, NULL, N'SaveQuestion', NULL, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Question Key Words', 2, N'BaseControlTextboxQuestionKeyWords', NULL, NULL, N'Question Key Words', 3, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, 200, 0, 0, N'Key Words:&nbsp&nbsp&nbsp&nbsp', NULL, NULL, NULL, 2000, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Minimum Value', 2, N'BaseControlTextBoxMinValue', N'Minimum Value is numeric only.', N'^[0-9]+$', N'Minimum Value for Free Text Number Field', 4, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, NULL, 0, 0, N'Minimum Value:&nbsp&nbsp', NULL, NULL, N'SaveQuestion', 256, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION', N'Max Value', 2, N'BaseControlTextBoxMaxValue', N'Max Value is numeric only.', N'^[0-9]+$', N'Max Value for Free Text Number Field', 5, CAST(0x0000A54500000000 AS DateTime), CAST(0x0000A54500000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, NULL, 0, 0, N'Max Value:&nbsp&nbsp', NULL, NULL, N'SaveQuestion', 256, N'PanelEditQuestion')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION_GROUP', N'Question Group Name', 2, N'BaseControlTextboxFormName', N'Question Group Name is required.', NULL, N'Question Group Name', 1, CAST(0x0000A54600000000 AS DateTime), CAST(0x0000A54600000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, 200, 1, 0, N'Question Group Name: **&nbsp&nbsp', NULL, NULL, N'SaveQuestionGroup', 256, N'PanelEditQuestionGroup')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_TOOL_QUESTION_GROUP', N'Question Group Title', 2, N'BaseControlTextboxFormTitle', N'Question Group Title is required.', NULL, N'Question Group Title', 1, CAST(0x0000A54600000000 AS DateTime), CAST(0x0000A54600000000 AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', NULL, NULL, 300, 1, 0, N'Question Group Notes: **&nbsp&nbsp', NULL, NULL, N'SaveQuestionGroup', 500, N'PanelEditQuestionGroup')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Duty Status', '5', 'BaseControlListBoxDutyStatus', NULL, NULL, 'Duty Status is the military standing of the registrant: Veteran, Retiree, or Active Duty. The Selection Criteria allows the user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_SERVICE_STATUS', NULL, NULL, 'False', 'True', 'Duty Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Question Number', '4', 'BaseControlDropdownListQuestions', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_FORM_QUESTION', NULL, NULL, 'False', 'True', 'Questions:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Question Response', '4', 'BaseControlDropdownListQuestionReponse', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '150', '150', 'False', 'True', 'Answers:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Radio Button Health Concersn', '3', 'BaseControlRadioButtonListHealthConcerns', NULL, NULL, 'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Answer', '5', 'BaseControlListBoxAnswer', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '200', '200', 'False', 'True', 'Answer:<br />', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Search Criteria Name', '2', 'BaseControlTextBoxSearchCriteriaName', 'Search Criteria Name is required.', NULL, 'Search Criteria Name', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'True', 'True', 'Search Criteria Name: ', NULL, NULL, 'OnSaveSearchCriteria', '256', 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Subpopulation Flag', '5', 'BaseControlListBoxSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', '2015-11-11 16:26:06.280', '2015-11-11 16:26:06.280', 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', '300', '300', 'False', 'True', 'Subpopulation Flag:<br>', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Health Factor', '5', 'BaseControlListBoxHealthFactor', NULL, NULL, 'Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation.  This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation.  The Selection Criteria allows the user to filter with one or more health factors.', '0', @Today, @Today, 'DBA', 'DBA', 'HEALTH_FACTOR', '350', '350', 'False', 'True', 'Health Factor:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Deployment Country All', '4', 'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments.  ', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY', NULL, NULL, 'False', 'True', 'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Deployment Country With Exposure Response', '4', 'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 'False', 'True', 'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Race', '4', 'BaseControlDropDownListRace', NULL, NULL, 'Race is the hereditary group to which the registrant identifies with. The Selection Criteria allows the user to filter by one Race.', '0', '2015-06-03 13:22:24.530', '2015-06-03 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_RACE', NULL, NULL, 'False', 'True', 'Race:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Gender', '4', 'BaseControlDropDownListGender', NULL, NULL, 'Gender is the sex of the registrant. The Selection Criteria allows the user to filter by one Gender.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_GENDER', NULL, NULL, 'False', 'True', 'Gender:  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Separation Type', '4', 'BaseControlDropDownListSeparationType', NULL, NULL, 'Separation Type is reason for the Registrants most recent separation.  The Selection Criteria allows the user to filter by one Separation Type.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_SEPARATIONREASON', NULL, NULL, 'False', 'True', 'Separation Type:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Ethnicity', '4', 'BaseControlDropDownListEthnicity', NULL, NULL, 'Ethnicity is the ethnic affiliation of the Registrant. The Selection Criteria allows the user to filter by one Ethnicity.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ETHNICITY', NULL, NULL, 'False', 'True', 'Ethnicity:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Report Enrollment Status', '4', 'BaseControlDropDownListEnrollmentStatus', NULL, NULL, 'Health Care Enrollment Status is the Registrants status in VA Care. The Selection Criteria allows the user to filter by one Health Care Enrollment Status.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ELIGIBLITYSTATUS', NULL, NULL, 'False', 'True', ' Health Care (VA Care) Enrollment Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Template Title', '4', 'BaseControlDropDownListTemplate', 'Email/Notification is required.', NULL, 'Message Templates', '0', '2015-11-04 00:00:00.000', '2015-11-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'TEMPLATE_MESSAGE_TITLE', NULL, NULL, 'True', 'True', 'Email/Notification:&nbsp&nbsp', NULL, NULL,'sendEmailMessage', NULL, 'PanelSend')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Question Response', 4, N'BaseControlDropdownListQuestionReponse', NULL, NULL, N'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with one question and one or more responses.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', NULL, 150, 150, 0, 1, N'Answers:&nbsp&nbsp', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Radio Button Health Concersn', 3, N'BaseControlRadioButtonListHealthConcerns', NULL, NULL, N'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', NULL, NULL, NULL, 0, 0, N'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Status Parameters', 5, N'BaseControlListBoxStatus', NULL, NULL, N'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant. The Selection Criteria allows a user to filter with one or more statuses.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'REGISTRY_STATUS', 150, 150, 0, 1, N'Status:<br />', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Answer', 5, N'BaseControlListBoxAnswer', NULL, NULL, N'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with one question and one or more responses.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', NULL, 200, 200, 0, 1, N'Answer:<br />', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', 'Subpopulation Flag', '5', 'BaseControlListBoxSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user. The Selection Criteria allows the user to filter with one subpopulation flag.', '0', '2015-11-07 00:00:00.000', '2015-11-07 00:00:00.000', 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', '300', '300', 'False', 'True', 'Subpopulation Flag:<br>', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Health Factor', 5, N'BaseControlListBoxHealthFactor', NULL, NULL, N'Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation. This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation. The Selection Criteria allows the user to filter with one or more health factors.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'HEALTH_FACTOR', 350, 350, 0, 1, N'Health Factor:<br />', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Deployment Country All', 4, N'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, N'Deployment Country received from deployment data interfaces. The Selection Criteria allows the user to filter with one country and by all deployments. ', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'DEPLOYMENT_COUNTRY', NULL, NULL, 0, 1, N'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'Deployment Country With Exposure Response', 4, N'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, N'Deployment Country received from deployment data interfaces. The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses. The data for deployments that have exposure responses will only be available for registrants in Participant status.', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 0, 1, N'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', N'List of Follow-up Question Group', 4, N'BaseControlDropDownListFollowupQuestionGroup', N'Question Group is required.', NULL, N'Select a follow-up question group from the list', 0, CAST(0x0000A54900000000 AS DateTime), CAST(0x0000A54900000000 AS DateTime), N'DBA', N'DBA', N'FOLLOWUP_QUESTION_GROUP_LIST', NULL, NULL, 1, 1, N'Question Group:&nbsp&nbsp', NULL, NULL, N'SendQuestions', NULL, N'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Contact Preference', '4', 'BaseControlDropDownListContactPreference', NULL, NULL, 'Contact Preference is for the preferred method of being contacted.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'CONTACT_PREFERENCE', NULL, NULL, 'False', 'True', 'Contact Preference:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Last Name:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Last Four Digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant Last Four Digists of SSN.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Last Four Digits of SSN:&nbsp&nbsp', NULL, NULL, NULL, '4', 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'AHOBPR Evaluation', '3', 'BaseControlRadioButtonListEvaluation', NULL, NULL, 'Radio button for Registrant AHOBPR Evaluation status.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'AHOBPR Evaluation:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'Email', '3', 'BaseControlRadioButtonListEmail', NULL, NULL, 'Radio button for Registrants with and without emails.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Emai:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MESSAGE_TEMPLATE', 'State', '5', 'BaseControlListBoxState', NULL, NULL, 'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'DBA', 'DBA', 'STD_STATE', '170', '170', 'False', 'True', 'State:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name', '0', '2015-11-20 00:00:00.000', '2015-11-20 00:00:00.000', 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'True', 'Last Name:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_SEND_QUESTIONS', 'Last 4 digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant last Four Digist of SSN', '0', '2015-11-20 00:00:00.000', '2015-11-20 00:00:00.000', 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'True', 'Last Four Digits of SSN:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Report Radio Button Health Concersn', '3', 'BaseControlRadioButtonListHealthConcerns', NULL, NULL, 'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Report Subpopulation Flag', '5', 'BaseControlListBoxSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', '2015-11-11 16:26:06.280', '2015-11-11 16:26:06.280', 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', '300', '300', 'False', 'True', 'Subpopulation Flag:<br>', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Deployment Country All', '4', 'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments.  ', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY', NULL, NULL, 'False', 'True', 'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Deployment Country With Exposure Response', '4', 'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 'False', 'True', 'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Admin Tracking Flag', '4', 'BaseControlDropDownListAdminFlag', NULL, NULL, 'Select Admin Tracking Flag.  ', '0', @Today, @Today, 'DBA', 'DBA', 'ADMINTRACKING_FLAG_ACTIVE', NULL, NULL, 'False', 'True', 'Admin Flag Name:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelSubmitFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Subpopulation Flag', '4', 'BaseControlDropDownListSubpopFlag', NULL, NULL, 'Select Subpopulation Flag.', '0', @Today, @Today, 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ACTIVE', NULL, NULL, 'False', 'True', 'Subpopulation Flag Name:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelSubmitFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Registry Flag Type', '4', 'BaseControlDropDownListFlagType', NULL, NULL, 'Select Registry Flag Type.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_FLAG_TYPE', NULL, NULL, 'False', 'True', 'RegistryFlag Type:<br>', NULL, NULL, NULL, NULL, 'PanelSubmitFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Duty Status', '5', 'BaseControlListBoxDutyStatus', NULL, NULL, 'Duty Status is the military standing of the registrant: Veteran, Retiree, or Active Duty. The Selection Criteria allows the user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_SERVICE_STATUS', NULL, NULL, 'False', 'True', 'Duty Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Question Number', '4', 'BaseControlDropdownListQuestions', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_FORM_QUESTION', NULL, NULL, 'False', 'True', 'Questions:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Question Response', '4', 'BaseControlDropdownListQuestionReponse', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '150', '150', 'False', 'True', 'Answers:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Radio Button Health Concersn', '3', 'BaseControlRadioButtonListHealthConcerns', NULL, NULL, 'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Answer', '5', 'BaseControlListBoxAnswer', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '200', '200', 'False', 'True', 'Answer:<br />', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Search Criteria Name', '2', 'BaseControlTextBoxSearchCriteriaName', 'Search Criteria Name is required.', NULL, 'Search Criteria Name', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'True', 'True', 'Search Criteria Name: ', NULL, NULL, 'OnSaveSearchCriteria', '256', 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Subpopulation Flag', '5', 'BaseControlListBoxSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', '2015-11-11 16:26:06.280', '2015-11-11 16:26:06.280', 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', '300', '300', 'False', 'True', 'Subpopulation Flag:<br>', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Health Factor', '5', 'BaseControlListBoxHealthFactor', NULL, NULL, 'Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation.  This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation.  The Selection Criteria allows the user to filter with one or more health factors.', '0', @Today, @Today, 'DBA', 'DBA', 'HEALTH_FACTOR', '350', '350', 'False', 'True', 'Health Factor:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Deployment Country All', '4', 'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments.  ', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY', NULL, NULL, 'False', 'True', 'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Deployment Country With Exposure Response', '4', 'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 'False', 'True', 'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Race', '4', 'BaseControlDropDownListRace', NULL, NULL, 'Race is the hereditary group to which the registrant identifies with. The Selection Criteria allows the user to filter by one Race.', '0', '2015-06-03 13:22:24.530', '2015-06-03 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_RACE', NULL, NULL, 'False', 'True', 'Race:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Gender', '4', 'BaseControlDropDownListGender', NULL, NULL, 'Gender is the sex of the registrant. The Selection Criteria allows the user to filter by one Gender.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_GENDER', NULL, NULL, 'False', 'True', 'Gender:  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Separation Type', '4', 'BaseControlDropDownListSeparationType', NULL, NULL, 'Separation Type is reason for the Registrants most recent separation.  The Selection Criteria allows the user to filter by one Separation Type.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_SEPARATIONREASON', NULL, NULL, 'False', 'True', 'Separation Type:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Ethnicity', '4', 'BaseControlDropDownListEthnicity', NULL, NULL, 'Ethnicity is the ethnic affiliation of the Registrant. The Selection Criteria allows the user to filter by one Ethnicity.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ETHNICITY', NULL, NULL, 'False', 'True', 'Ethnicity:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Report Enrollment Status', '4', 'BaseControlDropDownListEnrollmentStatus', NULL, NULL, 'Health Care Enrollment Status is the Registrants status in VA Care. The Selection Criteria allows the user to filter by one Health Care Enrollment Status.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ELIGIBLITYSTATUS', NULL, NULL, 'False', 'True', ' Health Care (VA Care) Enrollment Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Template Title', '4', 'BaseControlDropDownListTemplate', 'My Message is required.', NULL, 'Message Templates', '0', '2015-11-04 00:00:00.000', '2015-11-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'MY_TEMPLATES_TITLE', NULL, NULL, 'True', 'True', 'My Message:&nbsp&nbsp', NULL, NULL,'sendEmailMessage', NULL, 'PanelSend')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name', '0', '2015-11-20 00:00:00.000', '2015-11-20 00:00:00.000', 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'True', 'Last Name:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Last 4 digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant last Four Digist of SSN', '0', '2015-11-20 00:00:00.000', '2015-11-20 00:00:00.000', 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'True', 'Last Four Digits of SSN:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
-- Build 2.0.13.0
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Contact Preference', '4', 'BaseControlDropDownListContactPreference', NULL, NULL, 'Contact Preference is for the preferred method of being contacted.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'CONTACT_PREFERENCE', NULL, NULL, 'False', 'True', 'Contact Preference:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'AHOBPR Evaluation', '3', 'BaseControlRadioButtonListEvaluation', NULL, NULL, 'Radio button for Registrant AHOBPR Evaluation status.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'AHOBPR Evaluation:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'Email', '3', 'BaseControlRadioButtonListEmail', NULL, NULL, 'Radio button for Registrants with and without emails.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Emai:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_MY_SEND_MESSAGE', 'State', '5', 'BaseControlListBoxState', NULL, NULL, 'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'DBA', 'DBA', 'STD_STATE', '170', '170', 'False', 'True', 'State:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
-- Build 2.0.14.0
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'State', '5', 'BaseControlListBoxState', NULL, NULL, 'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'DBA', 'DBA', 'STD_STATE', '170', '170', 'False', 'True', 'State:<br />', NULL, NULL, NULL, NULL, 'PanelAddFlag')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_ADD_FLAG', 'Health Factor', '5', 'BaseControlListBoxHealthFactor', NULL, NULL, 'Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation.  This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation.  The Selection Criteria allows the user to filter with one or more health factors.', '0', @Today, @Today, 'DBA', 'DBA', 'HEALTH_FACTOR', '350', '350', 'False', 'True', 'Health Factor:<br />', NULL, NULL, NULL, NULL, 'PanelAddFlag')
-- Build 2.0.15.0
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Duty Status', '5', 'BaseControlListBoxDutyStatus', NULL, NULL, 'Duty Status is the military standing of the registrant: Veteran, Retiree, or Active Duty. The Selection Criteria allows the user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_SERVICE_STATUS', NULL, NULL, 'False', 'True', 'Duty Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Question Number', '4', 'BaseControlDropdownListQuestions', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', 'STD_FORM_QUESTION', NULL, NULL, 'False', 'True', 'Questions:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Question Response', '4', 'BaseControlDropdownListQuestionReponse', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '150', '150', 'False', 'True', 'Answers:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Radio Button Health Concersn', '3', 'BaseControlRadioButtonListHealthConcerns', NULL, NULL, 'Health Concerns is any positive response to Q3.A3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'False', 'Health Concerns:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report  Status Parameters', '5', 'BaseControlListBoxStatus', NULL, NULL, 'Status is the status of the registrants questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Review-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses.', '0', @Today, @Today, 'DBA', 'DBA', 'REGISTRY_STATUS', '150', '150', 'False', 'True', 'Status:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Answer', '5', 'BaseControlListBoxAnswer', NULL, NULL, 'Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.', '0', @Today, @Today, 'DBA', 'DBA', NULL, '200', '200', 'False', 'True', 'Answer:<br />', NULL, NULL, NULL, NULL, 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Search Criteria Name', '2', 'BaseControlTextBoxSearchCriteriaName', 'Search Criteria Name is required.', NULL, 'Search Criteria Name', '0', @Today, @Today, 'DBA', 'DBA', NULL, NULL, NULL, 'True', 'True', 'Search Criteria Name: ', NULL, NULL, 'OnSaveSearchCriteria', '256', 'PanelParameterAdHocReport')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Subpopulation Flag', '5', 'BaseControlListBoxSubpopulationFlag', NULL, NULL, 'Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag.', '0', '2015-11-11 16:26:06.280', '2015-11-11 16:26:06.280', 'DBA', 'DBA', 'SUBPOPULATION_FLAG_ALL', '300', '300', 'False', 'True', 'Subpopulation Flag:<br>', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Health Factor', '5', 'BaseControlListBoxHealthFactor', NULL, NULL, 'Health Factors are entered into the CPRS Template by a Health Care Provider during the Clinical Exposure Evaluation.  This data will only be available for registrants in Participant status and have had a Clinical Exposure Evaluation.  The Selection Criteria allows the user to filter with one or more health factors.', '0', @Today, @Today, 'DBA', 'DBA', 'HEALTH_FACTOR', '350', '350', 'False', 'True', 'Health Factor:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Deployment Country All', '4', 'BaseControlDropDownListDeploymentCountryAll', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments.  ', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY', NULL, NULL, 'False', 'True', 'Deployment Country (All Deployments):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Deployment Country With Exposure Response', '4', 'BaseControlDropDownListDeploymentCountryExposure', NULL, NULL, 'Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.', '0', @Today, @Today, 'DBA', 'DBA', 'DEPLOYMENT_COUNTRY_EXPOSURE', NULL, NULL, 'False', 'True', 'Deployment Country (Deployments With Exposure Responses):&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Race', '4', 'BaseControlDropDownListRace', NULL, NULL, 'Race is the hereditary group to which the registrant identifies with. The Selection Criteria allows the user to filter by one Race.', '0', '2015-06-03 13:22:24.530', '2015-06-03 13:22:24.530', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_RACE', NULL, NULL, 'False', 'True', 'Race:&nbsp&nbsp  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Gender', '4', 'BaseControlDropDownListGender', NULL, NULL, 'Gender is the sex of the registrant. The Selection Criteria allows the user to filter by one Gender.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_GENDER', NULL, NULL, 'False', 'True', 'Gender:  ', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Separation Type', '4', 'BaseControlDropDownListSeparationType', NULL, NULL, 'Separation Type is reason for the Registrants most recent separation.  The Selection Criteria allows the user to filter by one Separation Type.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_SEPARATIONREASON', NULL, NULL, 'False', 'True', 'Separation Type:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Ethnicity', '4', 'BaseControlDropDownListEthnicity', NULL, NULL, 'Ethnicity is the ethnic affiliation of the Registrant. The Selection Criteria allows the user to filter by one Ethnicity.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ETHNICITY', NULL, NULL, 'False', 'True', 'Ethnicity:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Report Enrollment Status', '4', 'BaseControlDropDownListEnrollmentStatus', NULL, NULL, 'Health Care Enrollment Status is the Registrants status in VA Care. The Selection Criteria allows the user to filter by one Health Care Enrollment Status.', '0', '2015-06-04 00:00:00.000', '2015-06-04 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'STD_ELIGIBLITYSTATUS', NULL, NULL, 'False', 'True', ' Health Care (VA Care) Enrollment Status:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Last Name', '2', 'BaseControlTextBoxLastName', NULL, NULL, 'Registrant Last Name', '0', '2015-11-20 00:00:00.000', '2015-11-20 00:00:00.000', 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'True', 'Last Name:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Last 4 digits of SSN', '2', 'BaseControlTextBoxLast4SSN', NULL, NULL, 'Registrant last Four Digist of SSN', '0', '2015-11-20 00:00:00.000', '2015-11-20 00:00:00.000', 'DBA', 'DBA', NULL, NULL, NULL, 'False', 'True', 'Last Four Digits of SSN:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelParameterSendQuestions')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Contact Preference', '4', 'BaseControlDropDownListContactPreference', NULL, NULL, 'Contact Preference is for the preferred method of being contacted.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', 'CONTACT_PREFERENCE', NULL, NULL, 'False', 'True', 'Contact Preference:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'AHOBPR Evaluation', '3', 'BaseControlRadioButtonListEvaluation', NULL, NULL, 'Radio button for Registrant AHOBPR Evaluation status.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'AHOBPR Evaluation:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'Email', '3', 'BaseControlRadioButtonListEmail', NULL, NULL, 'Radio button for Registrants with and without emails.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'AHOBPR DBA', 'AHOBPR DBA', NULL, NULL, NULL, 'False', 'True', 'Emai:&nbsp&nbsp', NULL, NULL, NULL, NULL, 'PanelReportParm')
INSERT INTO [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) VALUES (@RegistryId, N'AHOBPR_REPORT_CONTACT_INFO', 'State', '5', 'BaseControlListBoxState', NULL, NULL, 'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', '0', '2015-11-13 00:00:00.000', '2015-11-13 00:00:00.000', 'DBA', 'DBA', 'STD_STATE', '170', '170', 'False', 'True', 'State:<br />', NULL, NULL, NULL, NULL, 'PanelReportParm')

SET NOCOUNT OFF;
go

---------------------------------------------------------------------------------------------------------
print N'Update complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


go
update  [dbo].[DatabaseChangeLog]
  set   ScriptDescription = 'Script Completed Successfully.'
  where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    and [PointReleaseNumber]  = '$(PointReleaseNumber)'
    and [ScriptName]          = '$(ScriptName)'
    and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)'
  and [ScriptName] = '$(ScriptName)';
go
-------------------------------------------------
-------------------------------------------------
-- 2.0.30.1
-------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "30"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.30.1.sql"


print ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
set nocount off;
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    begin
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
go
if EXISTS ( select * from [dbo].[DatabaseChangeLog]
            where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
              and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
              and [PointReleaseNumber] = '$(PointReleaseNumber)'
              and [ScriptName]         = '$(ScriptName)'
          )
begin
   raiserror('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
end
else
  insert 
    into [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       values
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE()
            );

go
---------------------------------------------------------------------------------------------------------
print '$(ScriptName) script started...';
print GETDATE();
go
---------------------------------------------------------------------------------------------------------
if exists(select * from sys.views where name = 'VIEW_LOOKUP'
           and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
         ) 
   and not exists (select * from sys.views where name = 'view_lookup_pre_2_0_30'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
  exec sp_rename 'AHOBPR.VIEW_LOOKUP','view_lookup_pre_2_0_30';
go

create VIEW [AHOBPR].[VIEW_LOOKUP] 
--last updated in 2.0.30.1 script
WITH SCHEMABINDING 
AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
		OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME = 'Eligibility Review - More Documentation Needed'))--2.0.13.1 changed this line
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_FAMILY
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DISCHARGE_CHARACTER
UNION ALL
SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 0
  AND TITLE NOT IN ('Eligible for Burn Pit Registry', 'Not Eligible for Burn Pit Registry', 'New Follow-up Questions', 'Need More Documentation') 
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Multiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
UNION ALL
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Multiple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
	   ,STD_FORM_ID AS ID
       ,NAME AS CODE
       ,NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM A
  WHERE FOLLOWUP_FLAG = 1
  --Follow up Send Page > Deactivated groups showing in Drop down (272277)
   AND NOT EXISTS (SELECT 'X' FROM AHOBPR.TOOL_FORM WHERE TOOL_FORM_ID = A.TOOL_FORM_ID AND ACTIVE_FLAG = 0)
UNION ALL
SELECT DISTINCT 'CONTACT_PREFERENCE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[CONTACT_PREFERENCE] AS CODE
       ,[CONTACT_PREFERENCE] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
  WHERE CONTACT_PREFERENCE > ''
UNION ALL
SELECT 'MY_TEMPLATES_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,CREATEDBY AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 1
UNION ALL
SELECT DISTINCT 'ENROLLMENT_STATUS' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[ENROLLMENT_STATUS] AS CODE
       ,[ENROLLMENT_STATUS] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
   WHERE ENROLLMENT_STATUS > ''

-- select * from  [AHOBPR].[VIEW_LOOKUP]

go

---------------------------------------------------------------------------------------------------------
print N'Update complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


go
update  [dbo].[DatabaseChangeLog]
  set   ScriptDescription = 'Script Completed Successfully.'
  where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    and [PointReleaseNumber]  = '$(PointReleaseNumber)'
    and [ScriptName]          = '$(ScriptName)'
    and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)'
  and [ScriptName] = '$(ScriptName)';  
GO



---------------------------------------------------------------------------------------------------------
print N'Update complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


go
update  [dbo].[DatabaseChangeLog]
  set   ScriptDescription = 'Script Completed Successfully.'
  where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    and [PointReleaseNumber]  = '$(PointReleaseNumber)'
    and [ScriptName]          = '$(ScriptName)'
    and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)'
  and [ScriptName] = '$(ScriptName)';  

-------------------------------------------------
-------------------------------------------------
-- 2.0.32.1
-------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "32"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.32.1.sql"


print ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
set nocount off;
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    begin
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
go
if EXISTS ( select * from [dbo].[DatabaseChangeLog]
            where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
              and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
              and [PointReleaseNumber] = '$(PointReleaseNumber)'
              and [ScriptName]         = '$(ScriptName)'
          )
begin
   raiserror('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
end
else
  insert 
    into [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       values
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE()
            );

go
---------------------------------------------------------------------------------------------------------
print '$(ScriptName) script started...';
print GETDATE();
go
---------------------------------------------------------------------------------------------------------
if exists(select * from sys.procedures where name = 'SP_GetRegistrantAddFlag'
           and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
         ) 
   and not exists (select * from sys.procedures where name = 'SP_GetRegistrantAddFlag_pre_2_0_32_1'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
  exec sp_rename 'AHOBPR.SP_GetRegistrantAddFlag','SP_GetRegistrantAddFlag_pre_2_0_32_1';
go
-- =============================================
-- Create date: December 1, 2015
-- Description:	Used to create the list of registrant to add mass Admin & Sub-population flags.  

-- Modification log
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantAddFlag]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @excludeAdminFlag varchar(1) = 'N',
       @deploymentStartFromDateText varchar(100) = NULL,
       @deploymentStartToDateText varchar(100) = NULL,
       @deploymentCompletionFromDateText varchar(100) = NULL,
       @deploymentCompletionToDateText varchar(100) = NULL
       
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @deploymentStartFromDate DATETIME2(0) = NULL,
          @deploymentStartToDate DATETIME2(0) = NULL,
          @deploymentCompletionFromDate DATETIME2(0) = NULL,
          @deploymentCompletionToDate DATETIME2(0) = NULL
          
  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
  
   --Temp table concatnate flags for Registrants with multiple flags
  CREATE TABLE #state
  (
     [Registrant_Id] INT,
     [state] VARCHAR(8000)
  ) 

  SET @state = REPLACE(@state, 'Foreign Country/Other', 'FM,MH,PW,UM,US,CANAD,MX,EU,PI,FG,OT,UN')

  INSERT INTO #state ([Registrant_Id], [state])
  -- Load Table
  SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
                 FROM AHOBPR.REGISTRANT_ADDRESS b 
                WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                FOR XML PATH('')), 1, 1, '')  [STATE]
    FROM AHOBPR.REGISTRANT a
   GROUP BY a.REGISTRANT_ID;
   
                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
  SET @deploymentStartFromDate = dbo.CleanDate(@deploymentStartFromDateText);
  SET @deploymentStartToDate = dbo.AddMaxTime(dbo.CleanDate(@deploymentStartToDateText));
  SET @deploymentCompletionFromDate = dbo.CleanDate(@deploymentCompletionFromDateText);
  SET @deploymentCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@deploymentCompletionToDateText)); 
  
     

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',s.STATE AS State ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
         
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                             ',RIGHT(a.SSN, 4) AS SSN ' +
		                    'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                'LEFT JOIN #state s ' +  'ON a.REGISTRANT_ID = s.Registrant_Id ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT rd ON a.REGISTRANT_ID =  rd.REGISTRANT_ID ';

  
    
--used to get all registrant without the selected adminflag
IF ISNULL(@excludeAdminFlag, 'N') = 'Y'
    SET @MainQuery = @MainQuery + ' Left JOIN (SELECT REGISTRANT_ID, STD_REGISTRY_FLAG_ID FROM AHOBPR.REGISTRANT_REGISTRY_FLAG  ' +
								  '	WHERE STD_REGISTRY_FLAG_ID IN (' + @adminFlag + '))  AS af on af.REGISTRANT_ID = a.REGISTRANT_ID ';  
     
								  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
    
	
IF ISNULL(@excludeAdminFlag, 'N') = 'Y'	
	SET @MainQuery = @MainQuery + ' AND STD_REGISTRY_FLAG_ID is NULL ';
                                                

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @deploymentStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_START_DATE >= ''' + CONVERT(VARCHAR(20),@deploymentStartFromDate,121) + '''';
     
  IF @deploymentStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_START_DATE <= ''' + CONVERT(VARCHAR(20),@deploymentStartToDate,121) + '''';
    
  IF @deploymentCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_END_DATE >= ''' + CONVERT(VARCHAR(20),@deploymentCompletionFromDate,121) + '''';

  IF @deploymentCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_END_DATE <= ''' + CONVERT(VARCHAR(20),@deploymentCompletionToDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '' AND ISNULL(@excludeAdminFlag,'N') = 'N') 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                                  
                     
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ; 
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
               

                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
  IF ISNULL(@state,'') > ''
    BEGIN
      SET @state = REPLACE(@State,',',''',''');
      SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT DISTINCT addr.REGISTRANT_ID ' + 
                                          'FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                         'WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                           'AND addr.STATE  IN ( ''' + @state + ''') ) ';
    END;  
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
      
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentStartFromDateText  = '20120101' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentAll = 'Iraq,djibouti'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag]
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

GO
if exists(select * from sys.procedures where name = 'SP_GetRegistrantSendMessage'
           and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
         ) 
   and not exists (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage_pre_2_0_32_1'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
  exec sp_rename 'AHOBPR.SP_GetRegistrantSendMessage','SP_GetRegistrantSendMessage_pre_2_0_32_1';
go
-- =============================================
-- Create date: October 28, 2015
-- Description:	Used to create the list of registrant to send email/notifications to.  

-- Modification log
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendMessage]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @contactPreference varchar(100) = '',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @formBirthDateText varchar(100) = NULL,
       @email varchar(100) = 'All',
       @evaluation varchar(100) = 'All',
       @excludeAdminFlag varchar(1) = 'N'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
    
  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
   SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
                            --',RIGHT(a.SSN, 4) AS SSN ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                            ',RIGHT(a.SSN, 4) AS SSN ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';
  							  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
    

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    SET @MainQuery = @MainQuery +  ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
                                    ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
                                  ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                                                    

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';                                         
   IF (@email = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') '
   ELSE IF (@email = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') ' ;  
                          
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;                        
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                       
  IF ISNULL(@state,'') != '' 
	BEGIN
		SET @state = REPLACE(@State,',',''','''); 
		SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_ADDRESS addr ' +
                        ' WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          'AND addr.STATE  IN ( ''' + @state + ''') ) ';              
	END;
                                                  
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
           
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@contactPreference,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + ''''; 
    
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @evaluation = 'N', @status = '7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @contactPreference = 'Email from the VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage_changes] @formBirthDateText  = '19770707'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]  @ssn = '1125'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'


GO

if exists(select * from sys.procedures where name = 'SP_ReportAdHocByIndividual'
           and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
         ) 
   and not exists (select * from sys.procedures where name = 'SP_ReportAdHocByIndividual_pre_2_0_32_1'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
  exec sp_rename 'AHOBPR.SP_ReportAdHocByIndividual','SP_ReportAdHocByIndividual_pre_2_0_32_1';
go

-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters and remove NULLs from display where possible
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-03-30 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 2015-04-27 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce CLegg - Rewrote as Dynamic SQL for performance
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByIndividual]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText)); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';

  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    SET @MainQuery = @MainQuery +  ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
                                    ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
                                  ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                                                    

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                              
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;     
                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @RegCriteria = @RegCriteria + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
    
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]  @ethnicity = 'JEWISH'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'


GO

if exists(select * from sys.procedures where name = 'SP_ReportRegistrantContact'
           and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
         ) 
   and not exists (select * from sys.procedures where name = 'SP_ReportRegistrantContact_pre_2_0_32_1'
                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                  )
  exec sp_rename 'AHOBPR.SP_ReportRegistrantContact','SP_ReportRegistrantContact_pre_2_0_32_1';
go
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 12, 2015
-- Description:	Used for the AHOBPR Contact Report  -- exec [AHOBPR].[SP_ReportRegistrantContact]    (More options at bottom)
-- 2015-02-23 - Clegg - provide individual field names
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150429 - Bruce Clegg - Added Email column (again)
-- 20150617 - D. Barr - Added state parameter
-- 20150722 - Bruce Clegg - Fix bug with @EvaluatedLocationType = 'Base'
-- 20150901 - Bruce Clegg Fix Main phone.  TYPE is not NULL so old way does not work
-- 20151028 - D. Barr - Changed input parameters
-- 20160203 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantContact]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @contactPreference varchar(100) = '',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @formBirthDateText varchar(100) = NULL,
       @email varchar(100) = 'All',
       @evaluation varchar(100) = 'All',
       @excludeAdminFlag varchar(1) = 'N'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
  
 --registrant contact numbers
  CREATE TABLE #phone
  (
     [Registrant_Id] INT,
     [Phone] VARCHAR(50),
  ) 
  
   CREATE TABLE #mobile
  (
     [Registrant_Id] INT,
     [PhoneMobile] VARCHAR(50),
  )  
   INSERT INTO #phone ([Registrant_Id], [Phone])
  -- Load Table
  SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') 
      FROM AHOBPR.REGISTRANT_PHONE	
     WHERE ISNULL(TYPE,'') != 'Mobile'
     
          
 INSERT INTO #mobile ([Registrant_Id], [PhoneMobile])
  -- Load Table
  SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') 
      FROM AHOBPR.REGISTRANT_PHONE	
    WHERE TYPE = 'Mobile'
     
  
     
     
   
  CREATE TABLE #state
  (
     [Registrant_Id] INT,
     [state] VARCHAR(8000)
  ) 

  SET @state = REPLACE(@state, 'Foreign Country/Other', 'Foreign Country/Other,FM,MH,PW,UM,US,CANAD,MX,EU,PI,FG,OT,UN')

  INSERT INTO #state ([Registrant_Id], [state])
  -- Load Table
  SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
                 FROM AHOBPR.REGISTRANT_ADDRESS b 
                WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                FOR XML PATH('')), 1, 1, '')  [STATE]
    FROM AHOBPR.REGISTRANT a
   GROUP BY a.REGISTRANT_ID;
   
                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
   SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',a.LAST_NAME AS LAST_NAME ' +
                            ',a.FIRST_NAME AS FIRST_NAME ' +
                            ',a.CONTACT_PREFERENCE AS ContactPreference ' +
                            ',regADDR.STREET1 AS STREET1 ' +
                            ',regADDR.STREET2 AS STREET2 ' +
                            ',regADDR.CITY AS CITY ' +
                            ',regADDR.STATE AS STATE ' +
                            ',regADDR.COUNTRY AS COUNTRY ' +
                            ',regADDR.ZIP AS ZIP ' +
                            ',regPhone.Phone AS  PHONE_NUMBER_Main' +
							',regMobile.PhoneMobile AS  PHONE_NUMBER_Mobile' +
                            ',regEmail.EMAIL AS EMAIL ';
                            
            
    
  SET @MainQuery = @MainQuery + 
		                            
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                'LEFT JOIN #state s ' +  'ON a.REGISTRANT_ID = s.Registrant_Id ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_ADDRESS regAddr ON a.REGISTRANT_ID = regAddr.REGISTRANT_ID ' +
		                            ' LEFT JOIN #phone regPhone ON a.REGISTRANT_ID = regPhone.REGISTRANT_ID ' +
		                            ' LEFT JOIN #mobile regMobile ON a.REGISTRANT_ID = regMobile.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_EMAIL regEmail ON a.REGISTRANT_ID = regEmail.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';
                                
								  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  
	
  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    SET @MainQuery = @MainQuery +  ' AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
                                    'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
                                    'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
                                    ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
                                  ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                                                    

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';                                         
   IF (@email = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') '
   ELSE IF (@email = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') ' ;  
                          
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ; 
                     
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
               

                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
  IF ISNULL(@state,'') > ''
    BEGIN
      SET @state = REPLACE(@State,',',''',''');
      SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT DISTINCT addr.REGISTRANT_ID ' + 
                                          'FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                         'WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                           'AND addr.STATE  IN ( ''' + @state + ''') ) ';
    END;  
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@contactPreference,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + ''''; 
    
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] 
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @evaluation = 'N', @status = '7'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @contactPreference = 'Email from the VA'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact_changes] @formBirthDateText  = '19770707'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_ReportRegistrantContact]
-- exec [AHOBPR].[SP_ReportRegistrantContact] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantContact]  @ssn = '1125'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantContact] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

GO

---------------------------------------------------------------------------------------------------------
print N'Update complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


go
update  [dbo].[DatabaseChangeLog]
  set   ScriptDescription = 'Script Completed Successfully.'
  where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    and [PointReleaseNumber]  = '$(PointReleaseNumber)'
    and [ScriptName]          = '$(ScriptName)'
    and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)'
  and [ScriptName] = '$(ScriptName)';  
go
-------------------------------------------------
-------------------------------------------------
-- 2.0.32.2
-------------------------------------------------
--:setvar DatabaseName "Registry_AHOBPR"
:setvar MajorReleaseNumber "2" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "32"
:setvar ScriptName "Registry.AHOBPR.Database.Build.2.0.32.2.sql"


print ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
print 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
print ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
go
:on error exit
go
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
*/
set noexec off; 
set nocount off;
go
if N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    begin
        print N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    end

go

use [$(DatabaseName)]
go
if EXISTS ( select * from [dbo].[DatabaseChangeLog]
            where [MajorReleaseNumber] = '$(MajorReleaseNumber)'
              and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
              and [PointReleaseNumber] = '$(PointReleaseNumber)'
              and [ScriptName]         = '$(ScriptName)'
          )
begin
   raiserror('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
end
else
  insert 
    into [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       values
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE()
            );

go
---------------------------------------------------------------------------------------------------------
print '$(ScriptName) script started...';
print GETDATE();
go
---------------------------------------------------------------------------------------------------------
print 'create nonclustered index IX_StdFormAnswer_StdFormQuestion...';
go
create nonclustered index IX_StdFormAnswer_StdFormQuestion ON AHOBPR.STD_FORM_ANSWER(STD_FORM_ANSWER_ID);
go
print 'create nonclustered index IX_StdFormAnswer_BRPFormAnswerId...';
go
create nonclustered index IX_StdFormAnswer_BRPFormAnswerId ON AHOBPR.STD_FORM_ANSWER(BRP_FORM_ANSWER_ID,STD_FORM_ANSWER_ID)
--drop index IX_StdFormAnswer_BRPFormAnswerId on AHOBPR.STD_FORM_ANSWER
go


print 'reCREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantContact]...';
go
if exists (select * from sys.procedures where name = 'SP_ReportRegistrantContact'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
  exec sp_rename 'ahobpr.SP_ReportRegistrantContact', 'SP_ReportRegistrantContact_pre_2_0_32_2'
go
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 12, 2015
-- Description:	Used for the AHOBPR Contact Report  -- exec [AHOBPR].[SP_ReportRegistrantContact]    (More options at bottom)
-- 2015-02-23 - Clegg - provide individual field names
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150429 - Bruce Clegg - Added Email column (again)
-- 20150617 - D. Barr - Added state parameter
-- 20150722 - Bruce Clegg - Fix bug with @EvaluatedLocationType = 'Base'
-- 20150901 - Bruce Clegg Fix Main phone.  TYPE is not NULL so old way does not work
-- 20151028 - D. Barr - Changed input parameters
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 2016-02-08 - D. Barr - Added logic from Dave to addressed performance of specific question query
-- 
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantContact]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @contactPreference varchar(100) = '',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @formBirthDateText varchar(100) = NULL,
       @email varchar(100) = 'All',
       @evaluation varchar(100) = 'All',
       @excludeAdminFlag varchar(1) = 'N'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);
  DECLARE @AnswerWith VARCHAR(8000) = '';    
  
 --registrant contact numbers
  CREATE TABLE #phone
  (
     [Registrant_Id] INT,
     [Phone] VARCHAR(50),
  ) 
  
   CREATE TABLE #mobile
  (
     [Registrant_Id] INT,
     [PhoneMobile] VARCHAR(50),
  )  
   INSERT INTO #phone ([Registrant_Id], [Phone])
  -- Load Table
  SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') 
      FROM AHOBPR.REGISTRANT_PHONE	
     WHERE ISNULL(TYPE,'') != 'Mobile'
     
          
 INSERT INTO #mobile ([Registrant_Id], [PhoneMobile])
  -- Load Table
  SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') 
      FROM AHOBPR.REGISTRANT_PHONE	
    WHERE TYPE = 'Mobile'
     
  
     
     
   
  CREATE TABLE #state
  (
     [Registrant_Id] INT,
     [state] VARCHAR(8000)
  ) 

  SET @state = REPLACE(@state, 'Foreign Country/Other', 'Foreign Country/Other,FM,MH,PW,UM,US,CANAD,MX,EU,PI,FG,OT,UN')

  INSERT INTO #state ([Registrant_Id], [state])
  -- Load Table
  SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
                 FROM AHOBPR.REGISTRANT_ADDRESS b 
                WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                FOR XML PATH('')), 1, 1, '')  [STATE]
    FROM AHOBPR.REGISTRANT a
   GROUP BY a.REGISTRANT_ID;
   
                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
   SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',a.LAST_NAME AS LAST_NAME ' +
                            ',a.FIRST_NAME AS FIRST_NAME ' +
                            ',a.CONTACT_PREFERENCE AS ContactPreference ' +
                            ',regADDR.STREET1 AS STREET1 ' +
                            ',regADDR.STREET2 AS STREET2 ' +
                            ',regADDR.CITY AS CITY ' +
                            ',regADDR.STATE AS STATE ' +
                            ',regADDR.COUNTRY AS COUNTRY ' +
                            ',regADDR.ZIP AS ZIP ' +
                            ',regPhone.Phone AS  PHONE_NUMBER_Main' +
							',regMobile.PhoneMobile AS  PHONE_NUMBER_Mobile' +
                            ',regEmail.EMAIL AS EMAIL ';
                            
            
    
  SET @MainQuery = @MainQuery + 
		                            
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                'LEFT JOIN #state s ' +  'ON a.REGISTRANT_ID = s.Registrant_Id ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_ADDRESS regAddr ON a.REGISTRANT_ID = regAddr.REGISTRANT_ID ' +
		                            ' LEFT JOIN #phone regPhone ON a.REGISTRANT_ID = regPhone.REGISTRANT_ID ' +
		                            ' LEFT JOIN #mobile regMobile ON a.REGISTRANT_ID = regMobile.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_EMAIL regEmail ON a.REGISTRANT_ID = regEmail.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';
                                
								  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  
	
  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
 BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                       

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';                                         
   IF (@email = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') '
   ELSE IF (@email = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') ' ;  
                          
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ; 
                     
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
               

                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
  IF ISNULL(@state,'') > ''
    BEGIN
      SET @state = REPLACE(@State,',',''',''');
      SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT DISTINCT addr.REGISTRANT_ID ' + 
                                          'FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                         'WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                           'AND addr.STATE  IN ( ''' + @state + ''') ) ';
    END;  
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@contactPreference,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + ''''; 
    
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;          

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] 
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @evaluation = 'N', @status = '7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @contactPreference = 'Email from the VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage_changes] @formBirthDateText  = '19770707'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]  @ssn = '1125'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

go

print 'reCREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendQuestions]...';
go
if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendQuestions'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
  exec sp_rename 'ahobpr.SP_GetRegistrantSendQuestions', 'SP_GetRegistrantSendQuestions_pre_2_0_32_2'
go

-- =============================================
-- Create date: October 28, 2015
-- Description:	Used to create the list of registrant to send follow-up questions to.  

-- Modification log
-- -- 2016-02-08 - D. Barr - Added logic from Dave to addressed performance of specific question query
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendQuestions]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'Y',
       @excludeAdminFlag varchar(1) = 'N',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @formBirthDateText varchar(100) = NULL
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);
  DECLARE @AnswerWith VARCHAR(8000) = '';                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE()));
  SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, a.SSN,'+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',a.SSN, (a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                            ',RIGHT(a.SSN, 4) AS Last4SSN ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';

  --used to get all registrant without the selected adminflag
IF ISNULL(@excludeAdminFlag, 'N') = 'Y'
    SET @MainQuery = @MainQuery + ' Left JOIN (SELECT REGISTRANT_ID, STD_REGISTRY_FLAG_ID FROM AHOBPR.REGISTRANT_REGISTRY_FLAG  ' +
								  '	WHERE STD_REGISTRY_FLAG_ID IN (' + @adminFlag + '))  AS af on af.REGISTRANT_ID = a.REGISTRANT_ID ';
  
  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  

IF ISNULL(@excludeAdminFlag, 'N') = 'Y'	
	SET @MainQuery = @MainQuery + ' AND STD_REGISTRY_FLAG_ID is NULL ';  

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                          

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '' AND ISNULL(@excludeAdminFlag,'N') = 'N') 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                              
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
   IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';  
  
  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
    
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + '''';    
  
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID, a.SSN ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID, a.SSN ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID, a.SSN ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;           

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions]
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @status = '6,7'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formStartFromDateText  = '20010101'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formStartToDateText = '20141231'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formCompletionFromDateText  = '20010101'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formCompletionToDateText  = '20141231'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @healthConcerns = 'Yes'     , 
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @subpopulationFlag = '64,65,66,67'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @deploymentAll = 'Egypt'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @deploymentExposure  = 'Iraq'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @lastName = 'horton'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formBirthDateText = '05/05/1975'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @ssn = '1125'
go

print 'reCREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendMessage]...';
go
if exists (select * from sys.procedures where name = 'SP_GetRegistrantSendMessage'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
  exec sp_rename 'ahobpr.SP_GetRegistrantSendMessage', 'SP_GetRegistrantSendMessage_pre_2_0_32_2'
go
-- =============================================
-- Create date: October 28, 2015
-- Description:	Used to create the list of registrant to send email/notifications to.  

-- Modification log
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 2016-02-08 - D. Barr - Added logic from Dave to addressed performance of specific question query
-- 
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendMessage]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @contactPreference varchar(100) = '',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @formBirthDateText varchar(100) = NULL,
       @email varchar(100) = 'All',
       @evaluation varchar(100) = 'All',
       @excludeAdminFlag varchar(1) = 'N'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);
  DECLARE @AnswerWith VARCHAR(8000) = '';   
    
  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
   SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
                            --',RIGHT(a.SSN, 4) AS SSN ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                            ',RIGHT(a.SSN, 4) AS SSN ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';
  							  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
    

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
 BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                    

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';                                         
   IF (@email = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') '
   ELSE IF (@email = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') ' ;  
                          
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;                        
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                       
  IF ISNULL(@state,'') != '' 
	BEGIN
		SET @state = REPLACE(@State,',',''','''); 
		SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_ADDRESS addr ' +
                        ' WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          'AND addr.STATE  IN ( ''' + @state + ''') ) ';              
	END;
                                                  
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
           
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@contactPreference,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + ''''; 
    
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;             

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @evaluation = 'N', @status = '7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @contactPreference = 'Email from the VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage_changes] @formBirthDateText  = '19770707'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]  @ssn = '1125'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

GO

print 'reCREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByLocation]...';
go

if exists (select * from sys.procedures where name = 'SP_ReportAdHocByLocation'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
  exec sp_rename 'ahobpr.SP_ReportAdHocByLocation', 'SP_ReportAdHocByLocation_pre_2_0_32_2'
go

-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters, Add distinct and outer query to group counts.
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-05-07 - Bruce Clegg - Change Facility name from "Other" to "No Facitilty Assigned" when not found
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce Clegg - Rewrote as Dynamic SQL for performance
-- 2015-08-05 - Bruce Clegg - Fix bug with AdminFlag - Set From and To date defaults
-- 2015-12-11 - D Barr      - added evaluation parameter
-- Deborah Barr - Script 2.0.16.1
-- 2016-02-08    D May - Performance Improvement when answer is specified. Script 2.0.32.2
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByLocation]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(10) = 'All', 
       @requestToBeSeen varchar(10) = 'All',
       @groupBy VARCHAR(50) = '',                 -- 'VISN' or 'Facility'   
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All'
AS

BEGIN

  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL;
          
  DECLARE @Query VARCHAR(8000);         
  DECLARE @AnswerWith VARCHAR(8000) = '';

  -- Convert date parameters      

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));   

  -- Build Src TDE
  SET @Query = 'WITH ';

  IF ISNULL(@answer,'') != ''
    SET @Query = @Query + '
selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
), ';

 SET @Query = @Query + '
 Src 
    AS( SELECT a.REGISTRANT_ID, a.STD_INSTITUTION_ID 
        FROM AHOBPR.REGISTRANT a 
        WHERE 1 = 1 
';
                                   
  IF @status IS NOT NULL
    SET @Query = @Query + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @Query = @Query + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @Query = @Query + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @Query = @Query + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
    
  IF @formStartFromDate IS NOT NULL OR @formStartToDate IS NOT NULL 
    OR @formCompletionFromDate IS NOT NULL OR @formCompletionToDate IS NOT NULL
  BEGIN
    SET @Query = @Query + '
AND EXISTS( SELECT d.REGISTRANT_ID 
            FROM AHOBPR.FORM_RESPONSE d 
		        JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID	
		        WHERE a.REGISTRANT_ID = d.REGISTRANT_ID ';
		IF @formStartFromDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
		IF @formStartToDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
		IF @formCompletionFromDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';
		IF @formCompletionToDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
		SET @Query = @Query + ' ) ' -- Close Exists statement
  END    
    
  IF ISNULL(@answer,'') != '' 
  BEGIN
    SET @Query = @Query +  '
and exists( select *
            from AHOBPR.FORM_RESPONSE_ANSWER fra 
            join AHOBPR.FORM_RESPONSE_QUESTION frq  on frq.FORM_RESPONSE_QUESTION_ID = fra.FORM_RESPONSE_QUESTION_id
            join AHOBPR.FORM_RESPONSE fr           on fr.FORM_RESPONSE_ID = frq.FORM_RESPONSE_ID
            join selectedAnswer                   on selectedAnswer.STD_FORM_ANSWER_ID = fra.STD_FORM_ANSWER_ID
            where a.REGISTRANT_ID = fr.REGISTRANT_ID
          )'; 
                 
--  SET @Query = @Query + '
--AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
--                        'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
--                        'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
--                        'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
--                        ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
--                      ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                         
  END;                       
  
  IF ISNULL(@subpopulationFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                            
  IF ISNULL(@healthFactor,'') != ''
    SET @Query = @Query + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

  IF ISNULL(@deploymentAll,'') != '' 
    SET @Query = @Query + ' AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                       ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                           AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;

  IF ISNULL(@deploymentExposure,'') != '' 
    SET @Query = @Query + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID = ''1.2.A'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
IF (@evaluation = 'Yes') 
		 SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @Query = @Query + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;                                    
                                      
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @Query = @Query + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @Query = @Query + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @Query = @Query + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @Query = @Query + ' AND ''' + @separationType + ''' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @Query = @Query + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @Query = @Query + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @Query = @Query + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @Query = @Query + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  -- Add Summary TDE                   
  SET @Query = @Query + '  )	,Summary  AS( ' + 
                        ' SELECT Src.STD_INSTITUTION_ID, COUNT(*) AS TotalRegistrants FROM Src ' +
                        ' GROUP BY STD_INSTITUTION_ID ) ';
-- By Facility 
	IF @groupBy = 'Facility'
	BEGIN  SET @Query = @Query + ' 
SELECT  inst.Name AS Location, 
        ISNULL(CONVERT(VARCHAR(10),Summary.STD_INSTITUTION_ID),''-1'') AS LocationId, 
        SUM(TotalRegistrants) AS TotalRegistrants 
FROM      Summary
JOIN      AHOBPR.VIEW_INSTITUTION_NAME inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1) 
GROUP BY  inst.Name,STD_INSTITUTION_ID 
OPTION    (OPTIMIZE FOR UNKNOWN);';
  END
  ELSE -- By VISN
  BEGIN
	  IF @groupBy = 'VISN'
	     SET @Query = @Query + '
,VisnSummary AS 
 ( 
  SELECT ISNULL(inst.VisnID,''NLA'') AS Location, 
        ISNULL(inst.VisnID, ''-1'') AS LocationId, 
        SUM(TotalRegistrants) AS TotalRegistrants        
   FROM Summary 
   LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1)  
   GROUP BY inst.VisnID  
 ) --close the WITH
 SELECT REPLACE(Location,''NLA'',''No Facitilty Assigned'') AS Location,
        CONVERT(VARCHAR(10),LocationId) AS LocationId, TotalRegistrants 
   FROM VisnSummary  
  ORDER BY Location 
  OPTION (OPTIMIZE FOR UNKNOWN); ' ;
	END;

  PRINT @Query;		
  		                     
  EXECUTE (@Query);  		                     		
END
-- Parameters
  --@status, @dutyStatus ,@questionnaireStartDate, @questionnaireCompleteDate, 
  --@questionNumber, @answer, @healthConcerns= 'All', @requestToBeSeen = 'All',
  --@registryFlag,@InstitutionId = 0, @VisnId = '' 
-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @evaluation = 'No'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthConcerns = 'Yes' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @requestToBeSeen = 'Yes'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentAll = 'Iraq'    -- 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @answer = '39'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy =  'Facility' , @status = '6,7' ,@answer = '2346,1571,17'   -- '20,795,1570' 
go
print 'reCREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByIndividual]...';
go
if exists (select * from sys.procedures where name = 'SP_ReportAdHocByIndividual'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
          )
  exec sp_rename 'ahobpr.SP_ReportAdHocByIndividual', 'SP_ReportAdHocByIndividual_pre_2_0_32_2'
go

-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters and remove NULLs from display where possible
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-03-30 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 2015-04-27 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce CLegg - Rewrote as Dynamic SQL for performance
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 2016-02-07 - D. May - Addressed performance of specific question query
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByIndividual]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
  DECLARE @AnswerWith VARCHAR(8000) = '';             

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText)); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
  -- Set InstitutionID values if needed.
  DECLARE @AssignedInstitutionId INT = 0,
          @EvaluatedInstitutionId INT = 0;


  IF @AssignedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@AssignedLocationKey) = 1
    SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
  IF @EvaluatedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@EvaluatedLocationKey) = 1
    SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);


  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = '
WITH SubPop AS 
     ( 
      SELECT a.REGISTRANT_ID, 
             STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME 
                    FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b 
                    JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID 
                    WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                       AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) + '
                   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] 
      FROM AHOBPR.REGISTRANT a 
      WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = '
                    , Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = '
                    , Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                               ' FROM AHOBPR.REGISTRANT a ' +
                               '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                 
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';

  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
  BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                   

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                              
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;     
                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @RegCriteria = @RegCriteria + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
    
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]  @ethnicity = 'JEWISH'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'


--EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual]  @status = '7', @questionNumber = '1.3.A'  , @answer = '39'; --4:08 atfer index
--

GO
---------------------------------------------------------------------------------------------------------
print N'Update complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------


go
update  [dbo].[DatabaseChangeLog]
  set   ScriptDescription = 'Script Completed Successfully.'
  where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    and [PointReleaseNumber]  = '$(PointReleaseNumber)'
    and [ScriptName]          = '$(ScriptName)'
    and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)'
  and [ScriptName] = '$(ScriptName)';  
go

--------------------------------------------------------
--------------------------------------------------------
-- Refresh views and procedures
--------------------------------------------------------
print 'Refresh sql modules (views, procedures, etc) to recognize the changes made...';
go
declare @dependedUponModules table
	            (	id int identity(1,1) not null,
		            qualifiedName nvarchar(128) not null
	            );
declare 
	@maxID int,
	@id int = 0,
	@qualifiedName nvarchar(128) = '';

  /*
  Get a list of modules that other modules are dependent on.
  Sp that they can be rRefreshed those first.
  */
  print 'Refresh the modules that other modules depoend on...';
  with dependedUpon
  as  (
        select  distinct 
                ('['+ s.name + '].[' + dependedUponObject.name + ']') as name
              , s.name SchemaName
              , dependentObject.name                                  as dependentObjectName 
              , dependentObject.object_id                             as dependentId
              , dependedUponObject.name                               as dependedUponObjectName
              , dependedUponObject.object_id                          as dependedUponId
		          , substring(dependedUponObject_v.name, 5, 66)           as dependedUponObjectType				-- spt_values.name is nvarchar(70)
		          , substring(dependentObject_v.name, 5, 66)              as dependentObjectType				-- spt_values.name is nvarchar(70)
		    from  sys.sysdepends                      as d
		    join  sys.objects                         as dependentObject--this object references the object identified as dependedUponObject
		      on  dependentObject.object_id = d.id
		    join  master.dbo.spt_values               as dependentObject_v
		      on  dependentObject.type = substring(dependentObject_v.name,1,2) COLLATE database_default and dependentObject_v.type = 'O9T'    		  
		    join  sys.objects                         as dependedUponObject
		      on  dependedUponObject.object_id = d.depid
		    join  master.dbo.spt_values               as dependedUponObject_v
		      on  dependedUponObject.type = substring(dependedUponObject_v.name,1,2) collate database_default and dependedUponObject_v.type = 'O9T'
		    join  sys.schemas                         as s
		      on  dependedUponObject.schema_id = s.schema_id
		    where --d.depid = 219967960 and--267968131 and
			        d.deptype < 2
			        --and  dependedUponObject.object_id =331968359
              and exists (select * from sys.sql_modules m where  dependedUponObject.object_id = m.object_id and m.is_schema_bound = 0)
              and dependedUponObject.schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') 
              and substring(dependedUponObject_v.name, 5, 66) != 'user table'

		)
,   leveledDependencyModule 
as  (
      select 
              --distinct dependedUponObjectType
              *, dependedUponId BaseViewId, dependentId DependentViewId, 0 [Level]
        from dependedUpon as independentModule
        where 1=1
          --and dependedUponObjectType in ('View')
          --and dependentObjectType = 'View'
          and not exists (select * 
                          from dependedUpon 
                          where independentModule.dependedUponId = dependedUpon.dependentId 
                            --and dependedUponObjectType = 'View'
                            --and dependentObjectType = 'View'
                          )
      union all
        select dependentModule.*, dependentModule.dependedUponId BaseViewId, dependentModule.dependentId DependentViewId, [Level] + 1 as [Level]
        from leveledDependencyModule
        join dependedUpon as dependentModule
          on  leveledDependencyModule.DependentViewId = dependentModule.dependedUponId --331968359
        --where dependentBaseView.dependedUponObjectType = 'View'
        --      and dependentBaseView.dependentObjectType = 'View'
    )
--select * from baseModule

,   rankedBaseModule
as  (
      select distinct name, [Level], rank() over(partition by name order by level) RowRank
      from leveledDependencyModule
    )
--select * from rankedBaseModule
insert into @dependedUponModules(qualifiedName)
  select name
  from  rankedBaseModule
  where RowRank = 1
  order by [Level];
				
select @maxID = coalesce(@@ROWCOUNT,0)

while @id <> @maxID
begin
	select  top (1) 
          @id = id
        , @qualifiedName = qualifiedName
		from @dependedUponModules
		where @id < id		
		order by id asc;
			
	print 'Refreshing '+ @qualifiedName;
	execute sp_refreshsqlmodule @qualifiedName
end
---------------------------------------
-- Now refresh all the other modules --
---------------------------------------
print 'Now refresh all the other modules';

declare @dependentModules table
	          (	id int identity(1,1) not null,
		          qualifiedName nvarchar(128) not null
	          );

insert into @dependentModules(qualifiedName)
select  'AHOBPR.' + o.name
from 	  sys.objects o
--where it is a non-schema bound sql-module in the AHOBPR schema and has not already been refreshed
where   exists (select * from sys.sql_modules m where  o.object_id = m.object_id and m.is_schema_bound = 0)
  and   o.schema_id = (select schema_id from sys.schemas where name = 'AHOBPR') 
  and   not exists (select * from @dependedUponModules a where a.qualifiedName = o.name) ;

select @maxID = coalesce(@@ROWCOUNT,0)

while @id <> @maxID
begin
	select  top (1) 
          @id = id
        , @qualifiedName = qualifiedName
		from @dependentModules
		where @id < id		
		order by id asc;
			
	print 'Refreshing '+ @qualifiedName;
	execute sp_refreshsqlmodule @qualifiedName
end;
print 'Refresh done.';
go
print 'SQL Module Refresh complete.';
print '====================================================';
print 'Deployment script complete.';
print getdate();
print '====================================================';
        